/*
 * Decompiled with CFR 0.152.
 */
package com.trs.util.dbcp;

import com.trs.util.dbcp.ConnectionCache;
import com.trs.util.dbcp.ConnectionCacheFactory;
import com.trs.util.dbcp.Message00;
import java.io.FileInputStream;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Properties;

public class PoolDriver
implements Driver {
    private static final String AcceptPrefix = "jdbc:trs:pool:";
    private static final Hashtable CacheOfCache = new Hashtable();
    private static final int MajorVersion = 2;
    private static final int MinorVersion = 0;

    static {
        try {
            DriverManager.registerDriver(new PoolDriver());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean acceptsURL(String url) throws SQLException {
        return this.trsAcceptsURL(url) > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Connection connect(String url, Properties info) throws SQLException {
        int iPosition = this.trsAcceptsURL(url);
        if (iPosition <= 0) {
            throw new SQLException(String.valueOf(Message00.getString("pooldriver.invalid.url")) + url);
        }
        String sPoolName = url.substring(iPosition).trim();
        if (sPoolName.length() == 0) {
            throw new SQLException(String.valueOf(Message00.getString("pooldriver.invalid.url")) + url);
        }
        ConnectionCache cci = (ConnectionCache)CacheOfCache.get(sPoolName);
        if (cci == null) {
            Hashtable hashtable = CacheOfCache;
            synchronized (hashtable) {
                cci = (ConnectionCache)CacheOfCache.get(sPoolName);
                if (cci == null) {
                    cci = this.loadCache(sPoolName);
                }
            }
        }
        return cci.getConnection();
    }

    public int getMajorVersion() {
        return 2;
    }

    public int getMinorVersion() {
        return 0;
    }

    public DriverPropertyInfo[] getPropertyInfo(String url, Properties info) throws SQLException {
        return new DriverPropertyInfo[0];
    }

    public boolean jdbcCompliant() {
        return true;
    }

    private int trsAcceptsURL(String url) {
        if (url == null || url.length() <= AcceptPrefix.length()) {
            return -1;
        }
        if (url.startsWith(AcceptPrefix)) {
            return AcceptPrefix.length();
        }
        return -1;
    }

    private ConnectionCache loadCache(String sPoolName) throws SQLException {
        Properties props = null;
        char first = sPoolName.charAt(0);
        int index = sPoolName.lastIndexOf(63);
        if (index <= 0) {
            index = sPoolName.length();
        }
        String sFileName = sPoolName.substring(1, index);
        switch (first) {
            case '#': {
                props = this.loadResource(sFileName);
                break;
            }
            case '@': {
                props = this.loadFileSystem(sFileName);
                break;
            }
            default: {
                props = null;
            }
        }
        if (props == null) {
            throw new SQLException(String.valueOf(Message00.getString("pooldriver.invalid.name")) + sPoolName);
        }
        ConnectionCache cci = ConnectionCacheFactory.getInstance().createConnectionCache(props);
        CacheOfCache.put(sPoolName, cci);
        return cci;
    }

    private Properties loadResource(String sFileName) {
        Properties prop = null;
        InputStream is = null;
        try {
            try {
                is = this.getClass().getResourceAsStream(sFileName);
                if (is != null) {
                    prop = new Properties();
                    prop.load(is);
                }
            }
            catch (Exception exception) {
                try {
                    if (is != null) {
                        is.close();
                    }
                }
                catch (Exception exception2) {}
            }
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (Exception exception) {}
        }
        return null;
    }

    private Properties loadFileSystem(String sFileName) {
        Properties prop = null;
        FileInputStream fis = null;
        try {
            try {
                fis = new FileInputStream(sFileName);
                prop = new Properties();
                prop.load(fis);
            }
            catch (Exception exception) {
                try {
                    if (fis != null) {
                        fis.close();
                    }
                }
                catch (Exception exception2) {}
            }
        }
        finally {
            try {
                if (fis != null) {
                    fis.close();
                }
            }
            catch (Exception exception) {}
        }
        return prop;
    }
}

