/*
 * Decompiled with CFR 0.152.
 */
package org.apache.soap.server;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.soap.Constants;
import org.apache.soap.Envelope;
import org.apache.soap.Header;
import org.apache.soap.SOAPException;
import org.apache.soap.Utils;
import org.apache.soap.encoding.soapenc.SoapEncUtils;
import org.apache.soap.rpc.Call;
import org.apache.soap.rpc.Parameter;
import org.apache.soap.rpc.RPCConstants;
import org.apache.soap.rpc.Response;
import org.apache.soap.rpc.SOAPContext;
import org.apache.soap.server.DeploymentDescriptor;
import org.apache.soap.server.ServiceManager;
import org.apache.soap.util.Bean;
import org.apache.soap.util.MethodUtils;
import org.apache.soap.util.StringUtils;
import org.w3c.dom.Element;

public class RPCRouter {
    static /* synthetic */ Class class$org$apache$soap$rpc$SOAPContext;
    static /* synthetic */ Class class$org$apache$soap$server$DeploymentDescriptor;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class array$Ljava$lang$Object;

    public static Call extractCallFromEnvelope(ServiceManager serviceManager, Envelope callEnv, SOAPContext ctx) throws SOAPException {
        Header header;
        Vector bodyEntries = callEnv.getBody().getBodyEntries();
        Element mainEntry = (Element)bodyEntries.elementAt(0);
        String targetObjectURI = StringUtils.parseFullTargetObjectURI(mainEntry.getNamespaceURI());
        DeploymentDescriptor dd = serviceManager.query(targetObjectURI);
        if (dd == null) {
            throw new SOAPException(Constants.FAULT_CODE_SERVER_BAD_TARGET_OBJECT_URI, "Unable to determine object id from call: is the method element namespaced?");
        }
        if (dd.getCheckMustUnderstands() && (header = callEnv.getHeader()) != null) {
            Utils.checkMustUnderstands(header);
        }
        return Call.extractFromEnvelope(callEnv, serviceManager, ctx);
    }

    public static boolean validCall(DeploymentDescriptor dd, Call call) {
        String callMethodName = call.getMethodName();
        String[] pubMethods = dd.getMethods();
        for (int i = 0; i < pubMethods.length; ++i) {
            if (!callMethodName.equals(pubMethods[i])) continue;
            return true;
        }
        return false;
    }

    public static Response invoke(DeploymentDescriptor dd, Call call, Object targetObject, SOAPContext reqCtx, SOAPContext resCtx) throws SOAPException {
        Bean result;
        String respEncStyle;
        block20: {
            byte providerType = dd.getProviderType();
            Vector params = call.getParams();
            respEncStyle = call.getEncodingStyleURI();
            Object[] args = null;
            Class[] argTypes = null;
            if (params != null) {
                int paramsCount = params.size();
                args = new Object[paramsCount];
                argTypes = new Class[paramsCount];
                for (int i = 0; i < paramsCount; ++i) {
                    Parameter param = (Parameter)params.elementAt(i);
                    args[i] = param.getValue();
                    argTypes[i] = param.getType();
                    if (respEncStyle != null) continue;
                    respEncStyle = param.getEncodingStyleURI();
                }
            }
            if (respEncStyle == null) {
                respEncStyle = "http://schemas.xmlsoap.org/soap/encoding/";
            }
            result = null;
            try {
                if (providerType == 0 || providerType == 3) {
                    Class serClass;
                    String val;
                    Hashtable props;
                    Class<?> retClass;
                    Method m = null;
                    try {
                        m = MethodUtils.getMethod(targetObject, call.getMethodName(), argTypes);
                    }
                    catch (NoSuchMethodException e) {
                        try {
                            int i;
                            int paramsCount = 0;
                            if (params != null) {
                                paramsCount = params.size();
                            }
                            Class[] tmpArgTypes = new Class[paramsCount + 1];
                            Object[] tmpArgs = new Object[paramsCount + 1];
                            for (i = 0; i < paramsCount; ++i) {
                                tmpArgTypes[i + 1] = argTypes[i];
                            }
                            argTypes = tmpArgTypes;
                            argTypes[0] = class$org$apache$soap$rpc$SOAPContext == null ? (class$org$apache$soap$rpc$SOAPContext = RPCRouter.class$("org.apache.soap.rpc.SOAPContext")) : class$org$apache$soap$rpc$SOAPContext;
                            m = MethodUtils.getMethod(targetObject, call.getMethodName(), argTypes);
                            for (i = 0; i < paramsCount; ++i) {
                                tmpArgs[i + 1] = args[i];
                            }
                            tmpArgs[0] = reqCtx;
                            args = tmpArgs;
                        }
                        catch (NoSuchMethodException e2) {
                            throw e;
                        }
                        catch (Exception e2) {
                            throw e2;
                        }
                    }
                    catch (Exception e) {
                        throw e;
                    }
                    Object ret = m.invoke(targetObject, args);
                    Class retType = m.getReturnType();
                    if (ret != null && retType != Void.TYPE && !retType.isPrimitive() && (retClass = ret.getClass()) != retType && (props = dd.getProps()) != null && (val = (String)props.get("PolymorphicSerialization")) != null && SoapEncUtils.decodeBooleanValue(val) && (serClass = call.getSOAPMappingRegistry().getCompatibleClassWithSerializer(retClass, respEncStyle)) != null) {
                        retType = serClass;
                    }
                    result = new Bean(retType, ret);
                    break block20;
                }
                Class<?> bc = Class.forName("org.apache.soap.server.InvokeBSF");
                Class[] sig = new Class[]{class$org$apache$soap$server$DeploymentDescriptor == null ? (class$org$apache$soap$server$DeploymentDescriptor = RPCRouter.class$("org.apache.soap.server.DeploymentDescriptor")) : class$org$apache$soap$server$DeploymentDescriptor, class$java$lang$Object == null ? (class$java$lang$Object = RPCRouter.class$("java.lang.Object")) : class$java$lang$Object, class$java$lang$String == null ? (class$java$lang$String = RPCRouter.class$("java.lang.String")) : class$java$lang$String, array$Ljava$lang$Object == null ? (array$Ljava$lang$Object = RPCRouter.class$("[Ljava.lang.Object;")) : array$Ljava$lang$Object};
                Method m = MethodUtils.getMethod(bc, "service", sig, true);
                result = (Bean)m.invoke(null, dd, targetObject, call.getMethodName(), args);
            }
            catch (InvocationTargetException e) {
                Throwable t = e.getTargetException();
                if (t instanceof SOAPException) {
                    throw (SOAPException)t;
                }
                throw new SOAPException(Constants.FAULT_CODE_SERVER, "Exception from service object: " + t.getMessage(), t);
            }
            catch (ClassNotFoundException e) {
                throw new SOAPException(Constants.FAULT_CODE_SERVER, "Unable to load BSF: script services unsupported without BSF", e);
            }
            catch (Throwable t) {
                throw new SOAPException(Constants.FAULT_CODE_SERVER, "Exception while handling service request: " + t.getMessage(), t);
            }
        }
        Parameter ret = null;
        if (result.type != Void.TYPE) {
            ret = new Parameter(RPCConstants.ELEM_RETURN, result.type, result.value, null);
        }
        return new Response(call.getTargetObjectURI(), call.getMethodName(), ret, null, null, respEncStyle, resCtx);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

