/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.dom;

import org.apache.batik.dom.DocumentWrapper;
import org.apache.batik.dom.NodeWrapper;
import org.apache.batik.dom.events.EventListenerWrapper;
import org.apache.batik.dom.events.EventWrapper;
import org.apache.batik.dom.util.HashTable;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.w3c.dom.events.Event;
import org.w3c.dom.events.EventException;
import org.w3c.dom.events.EventListener;
import org.w3c.dom.events.EventTarget;

public class NodeWrapper
implements Node,
EventTarget {
    protected DocumentWrapper documentWrapper;
    protected Node node;
    protected HashTable capturingListeners;
    protected HashTable bubblingListeners;

    public NodeWrapper(DocumentWrapper documentWrapper, Node node) {
        this.documentWrapper = documentWrapper;
        this.node = node;
    }

    public Node getNode() {
        return this.node;
    }

    protected void finalize() throws Throwable {
        this.documentWrapper.nodeWrapperFinalized(this);
    }

    public String getNodeName() {
        class Query
        implements Runnable {
            String result;
            private final /* synthetic */ NodeWrapper this$0;

            Query(NodeWrapper nodeWrapper) {
                this.this$0 = nodeWrapper;
            }

            public void run() {
                this.result = this.this$0.node.getNodeName();
            }
        }
        Query query = new Query(this);
        this.invokeAndWait(query);
        return query.result;
    }

    public short getNodeType() {
        return this.node.getNodeType();
    }

    public String getNodeValue() throws DOMException {
        class Query
        implements Runnable {
            String result;
            DOMException exception;
            private final /* synthetic */ NodeWrapper this$0;

            Query(NodeWrapper nodeWrapper) {
                this.this$0 = nodeWrapper;
            }

            public void run() {
                try {
                    this.result = this.this$0.node.getNodeValue();
                }
                catch (DOMException dOMException) {
                    this.exception = dOMException;
                }
            }
        }
        Query query = new Query(this);
        this.invokeAndWait(query);
        if (query.exception != null) {
            throw query.exception;
        }
        return query.result;
    }

    public void setNodeValue(String string) throws DOMException {
        class Request
        implements Runnable {
            DOMException exception;
            private final /* synthetic */ String val$nodeValue;
            private final /* synthetic */ NodeWrapper this$0;

            Request(NodeWrapper nodeWrapper, String string) {
                this.this$0 = nodeWrapper;
                this.val$nodeValue = string;
            }

            public void run() {
                try {
                    this.this$0.node.setNodeValue(this.val$nodeValue);
                }
                catch (DOMException dOMException) {
                    this.exception = dOMException;
                }
            }
        }
        Request request = new Request(this, string);
        this.invokeAndWait(request);
        if (request.exception != null) {
            throw request.exception;
        }
    }

    public Node getParentNode() {
        class Query
        implements Runnable {
            Node result;
            private final /* synthetic */ NodeWrapper this$0;

            Query(NodeWrapper nodeWrapper) {
                this.this$0 = nodeWrapper;
            }

            public void run() {
                this.result = this.this$0.node.getParentNode();
            }
        }
        Query query = new Query(this);
        this.invokeAndWait(query);
        return this.createNodeWrapper(query.result);
    }

    public NodeList getChildNodes() {
        class Query
        implements Runnable {
            NodeList result;
            private final /* synthetic */ NodeWrapper this$0;

            Query(NodeWrapper nodeWrapper) {
                this.this$0 = nodeWrapper;
            }

            public void run() {
                this.result = this.this$0.node.getChildNodes();
            }
        }
        Query query = new Query(this);
        this.invokeAndWait(query);
        if (query.result == null) {
            return null;
        }
        return this.createNodeListWrapper(query.result);
    }

    public Node getFirstChild() {
        class Query
        implements Runnable {
            Node result;
            private final /* synthetic */ NodeWrapper this$0;

            Query(NodeWrapper nodeWrapper) {
                this.this$0 = nodeWrapper;
            }

            public void run() {
                this.result = this.this$0.node.getFirstChild();
            }
        }
        Query query = new Query(this);
        this.invokeAndWait(query);
        return this.createNodeWrapper(query.result);
    }

    public Node getLastChild() {
        class Query
        implements Runnable {
            Node result;
            private final /* synthetic */ NodeWrapper this$0;

            Query(NodeWrapper nodeWrapper) {
                this.this$0 = nodeWrapper;
            }

            public void run() {
                this.result = this.this$0.node.getLastChild();
            }
        }
        Query query = new Query(this);
        this.invokeAndWait(query);
        return this.createNodeWrapper(query.result);
    }

    public Node getPreviousSibling() {
        class Query
        implements Runnable {
            Node result;
            private final /* synthetic */ NodeWrapper this$0;

            Query(NodeWrapper nodeWrapper) {
                this.this$0 = nodeWrapper;
            }

            public void run() {
                this.result = this.this$0.node.getPreviousSibling();
            }
        }
        Query query = new Query(this);
        this.invokeAndWait(query);
        return this.createNodeWrapper(query.result);
    }

    public Node getNextSibling() {
        class Query
        implements Runnable {
            Node result;
            private final /* synthetic */ NodeWrapper this$0;

            Query(NodeWrapper nodeWrapper) {
                this.this$0 = nodeWrapper;
            }

            public void run() {
                this.result = this.this$0.node.getNextSibling();
            }
        }
        Query query = new Query(this);
        this.invokeAndWait(query);
        return this.createNodeWrapper(query.result);
    }

    public boolean hasAttributes() {
        class Query
        implements Runnable {
            boolean result;
            private final /* synthetic */ NodeWrapper this$0;

            Query(NodeWrapper nodeWrapper) {
                this.this$0 = nodeWrapper;
            }

            public void run() {
                this.result = this.this$0.node.hasAttributes();
            }
        }
        Query query = new Query(this);
        this.invokeAndWait(query);
        return query.result;
    }

    public NamedNodeMap getAttributes() {
        class Query
        implements Runnable {
            NamedNodeMap result;
            private final /* synthetic */ NodeWrapper this$0;

            Query(NodeWrapper nodeWrapper) {
                this.this$0 = nodeWrapper;
            }

            public void run() {
                this.result = this.this$0.node.getAttributes();
            }
        }
        Query query = new Query(this);
        this.invokeAndWait(query);
        if (query.result == null) {
            return null;
        }
        return this.createNamedNodeMapWrapper(query.result);
    }

    public Document getOwnerDocument() {
        return this.documentWrapper;
    }

    public String getNamespaceURI() {
        class Query
        implements Runnable {
            String result;
            private final /* synthetic */ NodeWrapper this$0;

            Query(NodeWrapper nodeWrapper) {
                this.this$0 = nodeWrapper;
            }

            public void run() {
                this.result = this.this$0.node.getNamespaceURI();
            }
        }
        Query query = new Query(this);
        this.invokeAndWait(query);
        return query.result;
    }

    public Node insertBefore(Node node, Node node2) throws DOMException {
        class Query
        implements Runnable {
            Node result;
            DOMException exception;
            private final /* synthetic */ Node val$newChild;
            private final /* synthetic */ Node val$refChild;
            private final /* synthetic */ NodeWrapper this$0;

            Query(NodeWrapper nodeWrapper, Node node, Node node2) {
                this.this$0 = nodeWrapper;
                this.val$newChild = node;
                this.val$refChild = node2;
            }

            public void run() {
                try {
                    this.result = this.this$0.node.insertBefore(((NodeWrapper)this.val$newChild).node, ((NodeWrapper)this.val$refChild).node);
                }
                catch (DOMException dOMException) {
                    this.exception = dOMException;
                }
            }
        }
        Query query = new Query(this, node, node2);
        this.invokeAndWait(query);
        if (query.exception != null) {
            throw query.exception;
        }
        return this.createNodeWrapper(query.result);
    }

    public Node replaceChild(Node node, Node node2) throws DOMException {
        class Query
        implements Runnable {
            Node result;
            DOMException exception;
            private final /* synthetic */ Node val$newChild;
            private final /* synthetic */ Node val$oldChild;
            private final /* synthetic */ NodeWrapper this$0;

            Query(NodeWrapper nodeWrapper, Node node, Node node2) {
                this.this$0 = nodeWrapper;
                this.val$newChild = node;
                this.val$oldChild = node2;
            }

            public void run() {
                try {
                    this.result = this.this$0.node.replaceChild(((NodeWrapper)this.val$newChild).node, ((NodeWrapper)this.val$oldChild).node);
                }
                catch (DOMException dOMException) {
                    this.exception = dOMException;
                }
            }
        }
        Query query = new Query(this, node, node2);
        this.invokeAndWait(query);
        if (query.exception != null) {
            throw query.exception;
        }
        return this.createNodeWrapper(query.result);
    }

    public Node removeChild(Node node) throws DOMException {
        class Query
        implements Runnable {
            Node result;
            DOMException exception;
            private final /* synthetic */ Node val$oldChild;
            private final /* synthetic */ NodeWrapper this$0;

            Query(NodeWrapper nodeWrapper, Node node) {
                this.this$0 = nodeWrapper;
                this.val$oldChild = node;
            }

            public void run() {
                try {
                    this.result = this.this$0.node.removeChild(((NodeWrapper)this.val$oldChild).node);
                }
                catch (DOMException dOMException) {
                    this.exception = dOMException;
                }
            }
        }
        Query query = new Query(this, node);
        this.invokeAndWait(query);
        if (query.exception != null) {
            throw query.exception;
        }
        return this.createNodeWrapper(query.result);
    }

    public Node appendChild(Node node) throws DOMException {
        class Query
        implements Runnable {
            Node result;
            DOMException exception;
            private final /* synthetic */ Node val$newChild;
            private final /* synthetic */ NodeWrapper this$0;

            Query(NodeWrapper nodeWrapper, Node node) {
                this.this$0 = nodeWrapper;
                this.val$newChild = node;
            }

            public void run() {
                try {
                    this.result = this.this$0.node.appendChild(((NodeWrapper)this.val$newChild).node);
                }
                catch (DOMException dOMException) {
                    this.exception = dOMException;
                }
            }
        }
        Query query = new Query(this, node);
        this.invokeAndWait(query);
        if (query.exception != null) {
            throw query.exception;
        }
        return this.createNodeWrapper(query.result);
    }

    public boolean hasChildNodes() {
        class Query
        implements Runnable {
            boolean result;
            private final /* synthetic */ NodeWrapper this$0;

            Query(NodeWrapper nodeWrapper) {
                this.this$0 = nodeWrapper;
            }

            public void run() {
                this.result = this.this$0.node.hasChildNodes();
            }
        }
        Query query = new Query(this);
        this.invokeAndWait(query);
        return query.result;
    }

    public Node cloneNode(boolean bl) {
        class Query
        implements Runnable {
            Node result;
            private final /* synthetic */ boolean val$deep;
            private final /* synthetic */ NodeWrapper this$0;

            Query(NodeWrapper nodeWrapper, boolean bl) {
                this.this$0 = nodeWrapper;
                this.val$deep = bl;
            }

            public void run() {
                this.result = this.this$0.node.cloneNode(this.val$deep);
            }
        }
        Query query = new Query(this, bl);
        this.invokeAndWait(query);
        return this.createNodeWrapper(query.result);
    }

    public void normalize() {
        this.invokeLater(new Runnable(){

            public void run() {
                NodeWrapper.this.node.normalize();
            }
        });
    }

    public boolean isSupported(String string, String string2) {
        class Query
        implements Runnable {
            boolean result;
            private final /* synthetic */ String val$feature;
            private final /* synthetic */ String val$version;
            private final /* synthetic */ NodeWrapper this$0;

            Query(NodeWrapper nodeWrapper, String string, String string2) {
                this.this$0 = nodeWrapper;
                this.val$feature = string;
                this.val$version = string2;
            }

            public void run() {
                this.result = this.this$0.node.isSupported(this.val$feature, this.val$version);
            }
        }
        Query query = new Query(this, string, string2);
        this.invokeAndWait(query);
        return query.result;
    }

    public String getPrefix() {
        class Query
        implements Runnable {
            String result;
            private final /* synthetic */ NodeWrapper this$0;

            Query(NodeWrapper nodeWrapper) {
                this.this$0 = nodeWrapper;
            }

            public void run() {
                this.result = this.this$0.node.getPrefix();
            }
        }
        Query query = new Query(this);
        this.invokeAndWait(query);
        return query.result;
    }

    public void setPrefix(String string) throws DOMException {
        class Request
        implements Runnable {
            DOMException exception;
            private final /* synthetic */ String val$prefix;
            private final /* synthetic */ NodeWrapper this$0;

            Request(NodeWrapper nodeWrapper, String string) {
                this.this$0 = nodeWrapper;
                this.val$prefix = string;
            }

            public void run() {
                try {
                    this.this$0.node.setPrefix(this.val$prefix);
                }
                catch (DOMException dOMException) {
                    this.exception = dOMException;
                }
            }
        }
        Request request = new Request(this, string);
        this.invokeAndWait(request);
        if (request.exception != null) {
            throw request.exception;
        }
    }

    public String getLocalName() {
        class Query
        implements Runnable {
            String result;
            private final /* synthetic */ NodeWrapper this$0;

            Query(NodeWrapper nodeWrapper) {
                this.this$0 = nodeWrapper;
            }

            public void run() {
                this.result = this.this$0.node.getLocalName();
            }
        }
        Query query = new Query(this);
        this.invokeAndWait(query);
        return query.result;
    }

    public void addEventListener(String string, EventListener eventListener, boolean bl) {
        HashTable hashTable;
        EventListenerWrapper eventListenerWrapper = new EventListenerWrapper(this.documentWrapper, eventListener);
        if (bl) {
            if (this.capturingListeners == null) {
                this.capturingListeners = new HashTable(3);
            }
            hashTable = this.capturingListeners;
        } else {
            if (this.bubblingListeners == null) {
                this.bubblingListeners = new HashTable(3);
            }
            hashTable = this.bubblingListeners;
        }
        HashTable hashTable2 = (HashTable)hashTable.get(string);
        if (hashTable2 == null) {
            hashTable2 = new HashTable(3);
            hashTable.put(string, hashTable2);
        }
        hashTable2.put(hashTable, eventListenerWrapper);
        class Request
        implements Runnable {
            private final /* synthetic */ String val$type;
            private final /* synthetic */ EventListener val$l;
            private final /* synthetic */ boolean val$useCapture;
            private final /* synthetic */ NodeWrapper this$0;

            Request(NodeWrapper nodeWrapper, String string, EventListener eventListener, boolean bl) {
                this.this$0 = nodeWrapper;
                this.val$type = string;
                this.val$l = eventListener;
                this.val$useCapture = bl;
            }

            public void run() {
                ((EventTarget)((Object)this.this$0.node)).addEventListener(this.val$type, this.val$l, this.val$useCapture);
            }
        }
        this.invokeLater(new Request(this, string, eventListenerWrapper, bl));
    }

    public void removeEventListener(String string, EventListener eventListener, boolean bl) {
        HashTable hashTable;
        HashTable hashTable2 = hashTable = bl ? this.capturingListeners : this.bubblingListeners;
        if (hashTable == null) {
            return;
        }
        HashTable hashTable3 = (HashTable)hashTable.get(string);
        if (hashTable3 == null) {
            return;
        }
        EventListener eventListener2 = (EventListener)hashTable3.remove(hashTable);
        if (eventListener2 == null) {
            return;
        }
        class Request
        implements Runnable {
            private final /* synthetic */ String val$type;
            private final /* synthetic */ EventListener val$l;
            private final /* synthetic */ boolean val$useCapture;
            private final /* synthetic */ NodeWrapper this$0;

            Request(NodeWrapper nodeWrapper, String string, EventListener eventListener, boolean bl) {
                this.this$0 = nodeWrapper;
                this.val$type = string;
                this.val$l = eventListener;
                this.val$useCapture = bl;
            }

            public void run() {
                ((EventTarget)((Object)this.this$0.node)).removeEventListener(this.val$type, this.val$l, this.val$useCapture);
            }
        }
        this.invokeLater(new Request(this, string, eventListener2, bl));
    }

    public boolean dispatchEvent(Event event) throws EventException {
        class Query
        implements Runnable {
            boolean result;
            EventException exception;
            private final /* synthetic */ Event val$evt;
            private final /* synthetic */ NodeWrapper this$0;

            Query(NodeWrapper nodeWrapper, Event event) {
                this.this$0 = nodeWrapper;
                this.val$evt = event;
            }

            public void run() {
                try {
                    this.result = ((EventTarget)((Object)this.this$0.node)).dispatchEvent(((EventWrapper)this.val$evt).getEvent());
                }
                catch (EventException eventException) {
                    this.exception = eventException;
                }
            }
        }
        Query query = new Query(this, event);
        this.invokeAndWait(query);
        if (query.exception != null) {
            throw query.exception;
        }
        return query.result;
    }

    protected void invokeAndWait(Runnable runnable) {
        this.documentWrapper.invokeAndWait(runnable);
    }

    protected void invokeLater(Runnable runnable) {
        this.documentWrapper.invokeLater(runnable);
    }

    protected Node createNodeWrapper(Node node) {
        return this.documentWrapper.createNodeWrapper(node);
    }

    protected Attr createAttrWrapper(Attr attr) {
        return this.documentWrapper.createAttrWrapper(attr);
    }

    protected Text createTextWrapper(Text text) {
        return this.documentWrapper.createTextWrapper(text);
    }

    protected Element createElementWrapper(Element element) {
        return this.documentWrapper.createElementWrapper(element);
    }

    protected NodeList createNodeListWrapper(NodeList nodeList) {
        return this.documentWrapper.createNodeListWrapper(nodeList);
    }

    protected NamedNodeMap createNamedNodeMapWrapper(NamedNodeMap namedNodeMap) {
        return this.documentWrapper.createNamedNodeMapWrapper(namedNodeMap);
    }
}

