/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.oss.utils;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ServiceSettings {
    private static final String SETTINGS_FILE_NAME = String.valueOf(System.getProperty("user.home")) + System.getProperty("file.separator") + "aliyun-oss-test.properties";
    private static final Log log = LogFactory.getLog(ServiceSettings.class);
    private Properties properties = new Properties();

    public String getOSSEndpoint() {
        return this.properties.getProperty("oss.endpoint");
    }

    public void setOSSEndpoint(String ossEndpoint) {
        this.properties.setProperty("oss.endpoint", ossEndpoint);
    }

    public String getOSSAccessKeyId() {
        return this.properties.getProperty("oss.accesskeyid");
    }

    public void setOSSAccessKeyId(String ossAccessKeyId) {
        this.properties.setProperty("oss.accesskeyid", ossAccessKeyId);
    }

    public String getOSSAccessKeySecret() {
        return this.properties.getProperty("oss.accesskeysecret");
    }

    public void setOSSAccessKeySecret(String ossAccessKeySecret) {
        this.properties.setProperty("oss.accesskeysecret", ossAccessKeySecret);
    }

    public String getProxyHost() {
        return this.properties.getProperty("proxy.host");
    }

    public void setProxyHost(String proxyHost) {
        this.properties.setProperty("proxy.host", proxyHost);
    }

    public int getProxyPort() {
        if (this.properties.getProperty("proxy.port") != null) {
            return Integer.parseInt(this.properties.getProperty("proxy.port"));
        }
        return 0;
    }

    public void setProxyPort(int proxyPort) {
        this.properties.setProperty("proxy.port", String.valueOf(proxyPort));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ServiceSettings load() {
        ServiceSettings ss = new ServiceSettings();
        FileInputStream is = null;
        try {
            try {
                is = new FileInputStream(SETTINGS_FILE_NAME);
                Properties pr = new Properties();
                pr.load(is);
                ss.properties = pr;
                return ss;
            }
            catch (FileNotFoundException e) {
                log.warn((Object)("The settings file '" + SETTINGS_FILE_NAME + "' does not exist."));
                if (is == null) return ss;
                try {
                    ((InputStream)is).close();
                    return ss;
                }
                catch (IOException iOException) {}
                return ss;
            }
            catch (IOException e) {
                log.warn((Object)("Failed to load the settings from the file: " + SETTINGS_FILE_NAME));
                if (is == null) return ss;
                try {
                    ((InputStream)is).close();
                    return ss;
                }
                catch (IOException iOException) {}
                return ss;
            }
        }
        finally {
            if (is != null) {
                try {
                    ((InputStream)is).close();
                }
                catch (IOException iOException) {}
            }
        }
    }
}

