/*
 * Decompiled with CFR 0.152.
 */
package com.trs.ckm.samples;

import com.trs.ckm.soap.CkmSoapException;
import com.trs.ckm.soap.TrsCkmSoapClient;
import com.trs.ckm.soap.UsageInfo;
import com.trs.ckm.soap.UserInfo;
import java.util.GregorianCalendar;

public class SysInterfaceTest {
    public static TrsCkmSoapClient client = null;

    public SysInterfaceTest(TrsCkmSoapClient _client) {
        client = _client;
    }

    public void test_getModelList() throws CkmSoapException {
        String[] modlist = client.getModelList(256);
    }

    public void test_getPassWord() {
        String pwd = client.getPassWord();
        System.out.println(pwd);
    }

    public void test_getPort() {
        int port = client.getPort();
        System.out.println(port);
    }

    public void test_getUserName() {
        String username = client.getUserName();
        System.out.println(username);
    }

    public void test_SetKeepAlive() {
        client.SetKeepAlive(true);
    }

    public void test_SetServer() {
        String host = "http://192.9.200.60:8888";
        String user = "admin";
        String pwd = "admin";
        client.SetServer(host, user, pwd);
        System.out.println(client.getHost());
        System.out.println(client.getUserName());
        System.out.println(client.getPassWord());
    }

    public void test_SetUrn() {
        try {
            try {
                client.SetUrn("newURN");
            }
            catch (Exception exception) {
                client.SetUrn("ckmURN");
            }
        }
        finally {
            client.SetUrn("ckmURN");
        }
    }

    public void test_AddUser() throws CkmSoapException {
        String str = "admin";
        UserInfo user = new UserInfo();
        user.setAllowedIp("192.9.200.50");
        user.setComment("no comment");
        user.setPassword("password");
        user.setPublicKey("");
        user.setUserName(str);
        user.setUserRightDesc("");
        int i = client.UserAddNew(user);
        System.out.println(i);
        client.UserDelete(user);
    }

    public void test_DeleteUser() throws CkmSoapException {
        String str = "admin";
        UserInfo user = new UserInfo();
        user.setAllowedIp("192.9.200.50");
        user.setComment("no comment");
        user.setPassword("password");
        user.setPublicKey("");
        user.setUserName(str);
        user.setUserRightDesc("");
        client.UserAddNew(user);
        int i = client.UserDelete(user);
        System.out.println(i);
    }

    public void test_GetUserList() throws CkmSoapException {
        String[] users = client.GetUserList(null);
        int i = 0;
        while (i < users.length) {
            System.out.println(users[i]);
            ++i;
        }
    }

    public void test_ModifyUser() throws CkmSoapException {
        UserInfo user1 = new UserInfo();
        user1.setAllowedIp("a");
        user1.setComment("a");
        user1.setPassword("a");
        user1.setPublicKey("a");
        user1.setUserName("liujuan");
        client.UserAddNew(user1);
        UserInfo user2 = new UserInfo();
        user2.setAllowedIp("192.9.200.50");
        user2.setComment("no comment");
        user2.setPassword("password");
        user2.setPublicKey("aaaa");
        user2.setUserName("liujuan");
        client.UserModify(user2);
        UserInfo user = client.GetUserInfo("liujuan");
        client.UserDelete(user2);
        System.out.println(user.getAllowedIp());
        System.out.println(user.getComment());
        System.out.println(user.getPassword());
        System.out.println(user.getPublicKey());
    }

    public void test_ModifyErrUser() {
        UserInfo user = new UserInfo();
        user.setAllowedIp("192.9.200.50");
        user.setComment("no comment");
        user.setPassword("password");
        user.setPublicKey("aaaa");
        user.setUserName("liujuan");
        try {
            client.UserModify(user);
        }
        catch (CkmSoapException ckmSoapException) {
            // empty catch block
        }
    }

    public void test_GetUserInfo() throws CkmSoapException {
        UserInfo result = client.GetUserInfo("admin");
        System.out.println(result.getComment());
        System.out.println(result.getPassword());
        System.out.println(result.getPublicKey());
        System.out.println(result.getUserName());
        System.out.println(result.getUserRightDesc());
    }

    public void test_getSysUsageInfo() throws CkmSoapException {
        UsageInfo info = client.GetSysUsagInfo(0);
        String xmlRet = null;
        GregorianCalendar calendar = new GregorianCalendar();
        if (info != null) {
            xmlRet = "<?xml version=\"1.0\" encoding=\"gb2312\"?>\n";
            xmlRet = String.valueOf(xmlRet) + "<TRSServerInfo>\n<ServerLive>1</ServerLive>\n<ServerIp>";
            int month = calendar.get(2);
            String time = String.valueOf(calendar.get(1)) + "-" + ++month + "-" + calendar.get(5) + " " + calendar.get(11) + ":" + calendar.get(12) + ":" + calendar.get(13);
            xmlRet = String.valueOf(xmlRet) + client.getHost() + "</ServerIp>\n<ServerName>CKMServer V4.6</ServerName>\n<MonitorTime>" + time + "</MonitorTime>\n";
            xmlRet = String.valueOf(xmlRet) + "<CpuUsed>" + info.getCpuUsage() + "</CpuUsed>\n<FreeMemory>" + info.getAvailMem() + "</FreeMemory>\n<Memory>" + info.getTotalMem() + "</Memory>\n<DeviceAvailSize>" + (int)info.getAvailSpace() + "</DeviceAvailSize>\n<DeviceTotalSize>" + (int)info.getTotalSpace() + "</DeviceTotalSize>\n</TRSServerInfo>";
        }
        System.out.println(xmlRet);
    }

    public static void main(String[] args) throws Exception {
        TrsCkmSoapClient _client = new TrsCkmSoapClient("http://192.9.200.142:8000", "admin", "trsadmin");
        SysInterfaceTest test = new SysInterfaceTest(_client);
        test.test_getSysUsageInfo();
    }
}

