/*
 * Decompiled with CFR 0.152.
 */
package com.trs.scm.domain.impl;

import com.trs.cms.ContextHelper;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.content.CMSObj;
import com.trs.components.common.publish.domain.publisher.PublishPathCompass;
import com.trs.components.common.publish.persistent.element.IPublishContent;
import com.trs.components.common.publish.persistent.element.IPublishFolder;
import com.trs.components.common.publish.persistent.element.PublishElementFactory;
import com.trs.components.metadata.center.MetaViewData;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.components.wcm.content.persistent.ChnlDoc;
import com.trs.components.wcm.content.persistent.Document;
import com.trs.components.wcm.content.persistent.WebSite;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.util.CMyString;
import com.trs.scm.domain.ISCMMicroContentTemplateMgr;
import com.trs.scm.persistent.SCMMicroContentTemplate;
import com.trs.scm.persistent.SCMMicroContentTemplates;

public class SCMMicroContentTemplateMgr
implements ISCMMicroContentTemplateMgr {
    @Override
    public boolean delete(SCMMicroContentTemplate microContentTemplate) throws Exception {
        return false;
    }

    @Override
    public String getSCMMicroContent(ChnlDoc _oChnlDoc, int _nSiteType) throws Exception {
        if (_oChnlDoc == null) {
            throw new WCMException("\u6587\u6863\u5bf9\u8c61\u4e3a\u7a7a");
        }
        CMSObj oTarget = null;
        int nHostId = _oChnlDoc.getChannelId();
        Document oDocument = _oChnlDoc.getDocument();
        oTarget = _nSiteType == 4 ? MetaViewData.findById(oDocument.getId()) : (oDocument.getKindId() > 0 ? MetaViewData.findById(oDocument.getId()) : oDocument);
        SCMMicroContentTemplate oSCMMicroContentTemplate = null;
        oSCMMicroContentTemplate = _nSiteType == 0 ? this.getTemplateIncludeParent(nHostId, 101) : this.getMicroContentTemplate(nHostId, 101);
        if (oSCMMicroContentTemplate == null || CMyString.isEmpty(oSCMMicroContentTemplate.getMicroContentStyle())) {
            if (_nSiteType == 0) {
                return this.getDefaultContentByDocumentFields(nHostId, oDocument);
            }
            return "";
        }
        return CMyString.parsePageVariables(oSCMMicroContentTemplate.getMicroContentStyle(), oTarget.getAllProperty());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getDefaultContentByDocumentFields(int nHostId, Document oDocument) throws WCMException {
        String sSCMMCContent = "\u3010" + oDocument.getTitle() + "\u3011";
        if (!CMyString.isEmpty(oDocument.getAbstract())) {
            sSCMMCContent = sSCMMCContent + oDocument.getAbstract();
        }
        PublishPathCompass compass = new PublishPathCompass();
        String sPath = "";
        try {
            IPublishContent oPublishDocument = (IPublishContent)PublishElementFactory.lookupElement(605, oDocument.getId());
            IPublishFolder oPublishFolder = (IPublishFolder)PublishElementFactory.lookupElement(101, nHostId);
            oPublishDocument.setFolder(oPublishFolder);
            sPath = compass.getHttpUrl(oPublishDocument, 0);
        }
        finally {
            compass.clear();
        }
        if (!CMyString.isEmpty(sPath)) {
            sSCMMCContent = sSCMMCContent + sPath;
        }
        return sSCMMCContent;
    }

    private SCMMicroContentTemplate getTemplateIncludeParent(int _nHostId, int _nHostType) throws Exception {
        SCMMicroContentTemplate oSCMMicroContentTemplate = null;
        SCMMicroContentTemplates oSCMMicroContentTemplates = this.getTemplate(_nHostId, _nHostType);
        if (oSCMMicroContentTemplates == null || oSCMMicroContentTemplates.size() == 0) {
            oSCMMicroContentTemplate = this.getParentMicroTemplate(_nHostId, _nHostType);
            if (oSCMMicroContentTemplate != null) {
                this.save(oSCMMicroContentTemplate);
            }
        } else {
            oSCMMicroContentTemplate = (SCMMicroContentTemplate)oSCMMicroContentTemplates.getAt(0);
        }
        if (oSCMMicroContentTemplate != null) {
            return oSCMMicroContentTemplate;
        }
        return null;
    }

    @Override
    public SCMMicroContentTemplate getMicroContentTemplate(int _nHostId, int _nHostType) throws WCMException {
        SCMMicroContentTemplate oSCMMicroContentTemplate;
        SCMMicroContentTemplates oSCMMicroContentTemplates = this.getTemplate(_nHostId, _nHostType);
        if (oSCMMicroContentTemplates != null && oSCMMicroContentTemplates.size() != 0 && (oSCMMicroContentTemplate = (SCMMicroContentTemplate)oSCMMicroContentTemplates.getAt(0)) != null) {
            return oSCMMicroContentTemplate;
        }
        return null;
    }

    private SCMMicroContentTemplates getTemplate(int _nHostId, int _nHostType) throws WCMException {
        User oUser = ContextHelper.getLoginUser();
        WCMFilter oFilter = new WCMFilter("XWCMSCMMICROCONTENTTEMPLATE", "HostId= ? and HostType= ?", "", "");
        oFilter.addSearchValues(_nHostId);
        oFilter.addSearchValues(_nHostType);
        SCMMicroContentTemplates oSCMMicroContentTemplates = SCMMicroContentTemplates.openWCMObjs(oUser, oFilter);
        return oSCMMicroContentTemplates;
    }

    private SCMMicroContentTemplate getParentMicroTemplate(int _nHostId, int _nHostType) throws Exception {
        SCMMicroContentTemplate oSCMMicroContentTemplate = null;
        SCMMicroContentTemplates oSCMMicroContentTemplates = null;
        int nHostId = _nHostId;
        int nHostType = _nHostType;
        if (_nHostType == 101) {
            Channel oChannel = Channel.findById(nHostId);
            if (oChannel == null) {
                throw new WCMException("\u6ca1\u6709\u627e\u5230ID=\u3010" + nHostId + "\u7684\u680f\u76ee\uff01");
            }
            Channel oParentChannel = oChannel.getParent();
            if (oParentChannel == null) {
                WebSite oWebSite = oChannel.getSite();
                if (oWebSite == null) {
                    throw new WCMException("\u680f\u76ee\u83b7\u53d6\u7ad9\u70b9\u65f6\u5931\u8d25\uff01\u680f\u76eeID\u4e3a\u3010" + nHostId + "\u3011");
                }
                nHostType = 103;
                oSCMMicroContentTemplate = this.getWebSiteMicroTemplate(oWebSite.getId(), nHostType);
            } else {
                nHostId = oParentChannel.getId();
                oSCMMicroContentTemplates = this.getTemplate(nHostId, nHostType = 101);
                oSCMMicroContentTemplate = oSCMMicroContentTemplates == null || oSCMMicroContentTemplates.size() == 0 ? this.getParentMicroTemplate(nHostId, nHostType) : (SCMMicroContentTemplate)oSCMMicroContentTemplates.getAt(0);
            }
            if (oSCMMicroContentTemplate != null) {
                return oSCMMicroContentTemplate;
            }
        } else if (_nHostType == 103) {
            oSCMMicroContentTemplate = this.getWebSiteMicroTemplate(_nHostId, _nHostType);
        }
        return null;
    }

    private SCMMicroContentTemplate getWebSiteMicroTemplate(int _nHostId, int _nHostType) throws Exception {
        WebSite oWebSite = WebSite.findById(_nHostId);
        if (oWebSite == null) {
            throw new WCMException("\u6ca1\u6709\u627e\u5230ID=\u3010" + _nHostId + "\u3011\u7684\u7ad9\u70b9");
        }
        SCMMicroContentTemplates oSCMMicroContentTemplates = null;
        SCMMicroContentTemplate oSCMMicroContentTemplate = null;
        oSCMMicroContentTemplates = this.getTemplate(_nHostId, _nHostType);
        if (oSCMMicroContentTemplates == null || oSCMMicroContentTemplates.size() == 0) {
            if (oSCMMicroContentTemplates == null || oSCMMicroContentTemplates.size() == 0) {
                return null;
            }
        } else {
            oSCMMicroContentTemplate = (SCMMicroContentTemplate)oSCMMicroContentTemplates.getAt(0);
        }
        if (oSCMMicroContentTemplate != null) {
            return oSCMMicroContentTemplate;
        }
        return null;
    }

    @Override
    public SCMMicroContentTemplate save(SCMMicroContentTemplate _oMicroContentTemplate) throws Exception {
        if (_oMicroContentTemplate == null) {
            throw new WCMException("\u4fdd\u5b58\u65f6\u4f20\u5165\u7684\u5bf9\u8c61\u4e3a\u7a7a");
        }
        User oUser = ContextHelper.getLoginUser();
        _oMicroContentTemplate.save(oUser);
        return _oMicroContentTemplate;
    }
}

