/*
 * Decompiled with CFR 0.152.
 */
package com.trs.scm.domain.impl;

import com.trs.cms.ContextHelper;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.process.engine.FlowDocs;
import com.trs.components.wcm.resource.Status;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.support.file.FilesMan;
import com.trs.infra.util.CMyDateTime;
import com.trs.infra.util.CMyFile;
import com.trs.infra.util.CMyString;
import com.trs.scm.domain.ISCMMicroContentMgr;
import com.trs.scm.domain.OAuthObjUtil;
import com.trs.scm.persistent.Account;
import com.trs.scm.persistent.AccountMicroContent;
import com.trs.scm.persistent.AccountMicroContents;
import com.trs.scm.persistent.Accounts;
import com.trs.scm.persistent.SCMMicroContent;
import com.trs.scm.persistent.SCMMicroContents;
import com.trs.scm.persistent.SCMRetweededMC;
import com.trs.scm.persistent.SCMRetweededMCs;
import com.trs.scm.publish.persistent.SCMMCPublishTasks;
import com.trs.scm.sdk.IMicroContentMgr;
import com.trs.scm.sdk.factory.PlatformFactory;
import com.trs.scm.sdk.model.ExtraParams;
import com.trs.scm.sdk.model.MicroContent;
import com.trs.scm.sdk.model.MicroContentWrapper;
import com.trs.scm.sdk.model.MicroUser;
import com.trs.scm.sdk.model.OAuth;
import com.trs.scm.stat.MicroContentStatDatas;
import java.util.Map;
import org.apache.log4j.Logger;

public class SCMMicroContentMgr
implements ISCMMicroContentMgr {
    private static Logger logger = Logger.getLogger(SCMMicroContentMgr.class);

    @Override
    public boolean delete(SCMMicroContent _oSCMMicroContent) throws Exception {
        if (_oSCMMicroContent == null) {
            throw new Exception("\u6307\u5b9a\u7684\u8981\u5220\u9664\u7684SCM\u5fae\u535a\u6570\u636e\u4e0d\u5b58\u5728!");
        }
        User oUser = _oSCMMicroContent.getCrUser();
        String sWhere = "SCMMICROCONTENTID = ?";
        WCMFilter oFilter = new WCMFilter("", sWhere, "");
        int nSCMMicroContentId = _oSCMMicroContent.getId();
        oFilter.addSearchValues(nSCMMicroContentId);
        AccountMicroContents oAccountMCs = AccountMicroContents.openWCMObjs(oUser, oFilter);
        if (oAccountMCs != null && oAccountMCs.size() > 0) {
            int nSize = oAccountMCs.size();
            for (int i = 0; i < nSize; ++i) {
                AccountMicroContent tempAccountMC = (AccountMicroContent)oAccountMCs.getAt(i);
                if (tempAccountMC == null) continue;
                Account oAccount = Account.findById(tempAccountMC.getAccountId());
                this.delete(oAccount, tempAccountMC.getMicroContentId());
            }
        }
        int nContentType = 1844552626;
        WCMFilter oFlowDocFilter = new WCMFilter("", "ObjType=? and ObjId=?", "PostTime desc, FlowDocId desc");
        oFlowDocFilter.addSearchValues(nContentType);
        oFlowDocFilter.addSearchValues(_oSCMMicroContent.getId());
        FlowDocs oFlowDocsResult = FlowDocs.openWCMObjs(oUser, oFlowDocFilter);
        if (oFlowDocsResult != null && oFlowDocsResult.size() > 0) {
            oFlowDocsResult.removeAll(true);
        }
        oFilter = new WCMFilter("", "SCMMCID = ?", "");
        oFilter.addSearchValues(nSCMMicroContentId);
        SCMMCPublishTasks oPublishingTasks = SCMMCPublishTasks.openWCMObjs(oUser, oFilter);
        if (oPublishingTasks != null && oPublishingTasks.size() > 0) {
            oPublishingTasks.removeAll(true);
        }
        _oSCMMicroContent.delete(oUser);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean delete(Account _oAccount, String _sMicroContentId) throws Exception {
        block8: {
            if (CMyString.isEmpty(_sMicroContentId)) {
                throw new Exception("\u8981\u5220\u9664\u7684\u5fae\u535a\u7684Id\u4e3a\u7a7a\uff01");
            }
            User oUser = ContextHelper.getLoginUser();
            if (_oAccount == null || _oAccount.getStatus() == -1) {
                this.deleteReleatedMCInfo(oUser, _sMicroContentId);
                return true;
            }
            IMicroContentMgr oMicroContentMgr = this.queryMicroContentMgrByAccount(_oAccount);
            try {
                oMicroContentMgr.destroyMicroContent(_sMicroContentId);
            }
            catch (Exception _oException) {
                if (_oException.getMessage().indexOf("\u5fae\u535a\u6216\u8bc4\u8bba\u5df2\u88ab\u5220\u9664\uff01") >= 0) {
                    break block8;
                }
                throw _oException;
            }
            finally {
                this.deleteReleatedMCInfo(oUser, _sMicroContentId);
            }
        }
        return true;
    }

    private void deleteReleatedMCInfo(User _oUser, String _oMicroContentId) throws Exception {
        MicroContentStatDatas oMCStatDatas;
        String sWhere = "MICROCONTENTID = ?";
        WCMFilter oFilter = new WCMFilter("", sWhere, "");
        oFilter.addSearchValues(_oMicroContentId);
        AccountMicroContents oAccountMCs = AccountMicroContents.openWCMObjs(_oUser, oFilter);
        int nSize = oAccountMCs.size();
        AccountMicroContent oAccountMicroContent = null;
        if (nSize != 0) {
            oAccountMicroContent = (AccountMicroContent)oAccountMCs.getAt(0);
        }
        oAccountMCs.removeAll();
        WCMFilter aFilter = new WCMFilter("", "MCID = ? OR ORIGINALMCID = ?", "");
        aFilter.addSearchValues(_oMicroContentId);
        aFilter.addSearchValues(_oMicroContentId);
        SCMRetweededMCs oSCMRetweededMCs = SCMRetweededMCs.openWCMObjs(_oUser, aFilter);
        if (oSCMRetweededMCs != null) {
            oSCMRetweededMCs.removeAll();
        }
        if ((oMCStatDatas = MicroContentStatDatas.openWCMObjs(_oUser, oFilter)) != null) {
            oMCStatDatas.removeAll();
        }
    }

    @Override
    public MicroContent findById(Account _oAccount, String _sMicroContentId) throws Exception {
        if (CMyString.isEmpty(_sMicroContentId)) {
            throw new Exception("\u8981\u83b7\u53d6\u7684\u5fae\u535a\u7684Id\u4e3a\u7a7a\uff01");
        }
        IMicroContentMgr oMicroContentMgr = this.queryMicroContentMgrByAccount(_oAccount);
        MicroContent oMicroContent = null;
        try {
            oMicroContent = oMicroContentMgr.findById(_sMicroContentId);
        }
        catch (Exception e) {
            if (e.getMessage().indexOf("\u5fae\u535a\u6216\u8bc4\u8bba\u5df2\u88ab\u5220\u9664\uff01") >= 0) {
                this.deleteReleatedMCInfo(ContextHelper.getLoginUser(), _sMicroContentId);
            }
            logger.error((Object)"SCMMicroContentMgr.findById\u5f02\u5e38", (Throwable)e);
            return null;
        }
        return oMicroContent;
    }

    @Override
    public MicroContentWrapper queryHomeTimeline(Account _oAccount, int _nPageIndex, int _nPageSize, Map _oExtraParams) throws Exception {
        IMicroContentMgr oMicroContentMgr = this.queryMicroContentMgrByAccount(_oAccount);
        ExtraParams oExtraParams = this.getExtraParams(_oExtraParams);
        MicroContentWrapper oMicroContentWrapper = oMicroContentMgr.getHomeTimeline(_nPageIndex, _nPageSize, oExtraParams);
        return oMicroContentWrapper;
    }

    @Override
    public MicroContentWrapper queryMentions(Account _oAccount, int _nPageIndex, int _nPageSize, Map _oExtraParams) throws Exception {
        IMicroContentMgr oMicroContentMgr = this.queryMicroContentMgrByAccount(_oAccount);
        ExtraParams oExtraParams = this.getExtraParams(_oExtraParams);
        MicroContentWrapper oMicroContentWrapper = oMicroContentMgr.getMentions(_nPageIndex, _nPageSize, oExtraParams);
        return oMicroContentWrapper;
    }

    @Override
    public MicroContentWrapper queryUserTimeline(Account _oAccount, int _nPageIndex, int _nPageSize, Map _oExtraParams) throws Exception {
        IMicroContentMgr oMicroContentMgr = this.queryMicroContentMgrByAccount(_oAccount);
        ExtraParams oExtraParams = this.getExtraParams(_oExtraParams);
        String sUid = _oAccount.getUId();
        oExtraParams.setParam("UserId", sUid);
        MicroContentWrapper oMicroContentWrapper = oMicroContentMgr.getUserTimeline(_nPageIndex, _nPageSize, oExtraParams);
        return oMicroContentWrapper;
    }

    @Override
    public MicroContentWrapper queryUserTimelineByType(Account _oAccount, int _nType, int _nPageIndex, int _nPageSize, Map _oExtraParams) throws Exception {
        IMicroContentMgr oMicroContentMgr = this.queryMicroContentMgrByAccount(_oAccount);
        ExtraParams oExtraParams = this.getExtraParams(_oExtraParams);
        String sUid = _oAccount.getUId();
        oExtraParams.setParam("UserId", sUid);
        MicroContentWrapper oMicroContentWrapper = oMicroContentMgr.getUserTimelineByType(_nType, _nPageIndex, _nPageSize, oExtraParams);
        return oMicroContentWrapper;
    }

    @Override
    public SCMMicroContents querySCMMicroContents(WCMFilter _oFilter) throws Exception {
        return SCMMicroContents.openWCMObjs(ContextHelper.getLoginUser(), _oFilter);
    }

    @Override
    public boolean forwardMicroContent(Accounts _oAccounts, String _sContent, String _sMicroContentId, Map _oExtraParams) throws Exception {
        if (CMyString.isEmpty(_sMicroContentId)) {
            throw new Exception("\u8981\u8f6c\u53d1\u7684\u5fae\u535a\u7684Id\u4e3a\u7a7a\uff01");
        }
        int nSCMMCID = (Integer)_oExtraParams.get("SCMMicroContentID");
        SCMMicroContent oTarget = SCMMicroContent.findById(nSCMMCID);
        if (oTarget == null) {
            throw new Exception("\u672a\u67e5\u627e\u5230\u76f8\u5173SCM\u5fae\u535a\u8bb0\u5f55\uff0c\u4e0d\u80fd\u8fdb\u884c\u5fae\u535a\u7684\u8f6c\u53d1\uff01");
        }
        String sAccountNames = "";
        String sAccountMicroContents = "";
        String sRetweetMCs = "";
        for (int i = 0; i < _oAccounts.size(); ++i) {
            Account oCurrAccount = (Account)_oAccounts.getAt(i);
            IMicroContentMgr oMicroContentMgr = this.queryMicroContentMgrByAccount(oCurrAccount);
            ExtraParams oExtraParams = this.getExtraParams(_oExtraParams);
            MicroContent oMicroContent = null;
            try {
                oMicroContent = oMicroContentMgr.repostMicroContent(_sContent, _sMicroContentId, oExtraParams);
            }
            catch (Exception e) {
                sAccountNames = sAccountNames + oCurrAccount.getAccountName() + ":" + e.getMessage() + "\n";
            }
            AccountMicroContent oAccountMicroContent = null;
            try {
                oAccountMicroContent = this.createAccountMicroContent(oCurrAccount.getId(), nSCMMCID, oMicroContent);
                oAccountMicroContent.setIsRetweeted(true);
                oAccountMicroContent.save(oTarget.getCrUser());
            }
            catch (Exception e) {
                sAccountMicroContents = sAccountMicroContents + oCurrAccount.getAccountName() + ":\u4fdd\u5b58\u6570\u636e\u5e93\u5f02\u5e38\uff01\n";
            }
            try {
                this.saveRetweededMC(oCurrAccount, nSCMMCID, _sMicroContentId, _oExtraParams);
                continue;
            }
            catch (Exception e) {
                sRetweetMCs = sRetweetMCs + oCurrAccount.getAccountName() + "\uff1a\u4fdd\u5b58\u8f6c\u53d1\u5fae\u535a\u5185\u5bb9\u5f02\u5e38\uff01\n";
            }
        }
        if (!CMyString.isEmpty(sAccountNames)) {
            String sErrorMsg = sAccountNames.substring(0, sAccountNames.length() - 1);
            throw new WCMException(sErrorMsg);
        }
        return true;
    }

    @Override
    public void saveRetweededMC(Account _oAccount, int _nSCMMCId, String _sMicroContentId, Map _oExtraParams) throws Exception {
        if (_oAccount == null) {
            throw new Exception("\u8f6c\u53d1\u5fae\u535a\u7684\u8d26\u53f7\u4e3a\u7a7a\uff01");
        }
        IMicroContentMgr oMicroContentMgr = this.queryMicroContentMgrByAccount(_oAccount);
        MicroContent oMicroContent = oMicroContentMgr.findById(_sMicroContentId);
        if (oMicroContent == null) {
            throw new Exception("\u88ab\u8f6c\u53d1\u7684\u5fae\u535a\u4e3a\u7a7a\uff01");
        }
        SCMRetweededMC oRetweededMC = SCMRetweededMC.createNewInstance();
        if (oMicroContent.isRetweeted()) {
            oMicroContent = oMicroContent.getRetweetedMicroContent();
            oRetweededMC.setOriginalMCId(oMicroContent.getId());
        }
        oRetweededMC.setContent(oMicroContent.getContent());
        oRetweededMC.setMCId(_sMicroContentId);
        oRetweededMC.setSCMMCId(_nSCMMCId);
        CMyDateTime oDate = new CMyDateTime();
        oDate.setDateTime(oMicroContent.getCreateDate());
        oRetweededMC.setCreateDate(oDate);
        MicroUser oMicroUser = oMicroContent.getUser();
        if (oMicroUser != null) {
            oRetweededMC.setAccountNickName(oMicroUser.getName());
        }
        oRetweededMC.setThumbnailPics(oMicroContent.getThumbnailPics());
        oRetweededMC.setBmiddlePics(oMicroContent.getBmiddlePics());
        oRetweededMC.setOriginalPics(oMicroContent.getOriginalPics());
        oRetweededMC.setSource(oMicroContent.getSource());
        oRetweededMC.save(User.getSystem());
    }

    @Override
    public SCMMicroContent getTopOne() throws Exception {
        SCMMicroContent oMicroContent = null;
        WCMFilter oFilter = new WCMFilter("", "", "CRTIME", "CRTIME", 1);
        User loginUser = ContextHelper.getLoginUser();
        SCMMicroContents oTarget = SCMMicroContents.openWCMObjs(loginUser, oFilter);
        if (oTarget == null || oTarget.size() == 0) {
            return null;
        }
        for (int i = 0; i < oTarget.size(); ++i) {
            SCMMicroContent oTempSCMMicroContent = (SCMMicroContent)oTarget.getAt(i);
            if (oTempSCMMicroContent == null) continue;
            oMicroContent = oTempSCMMicroContent;
            break;
        }
        return oMicroContent;
    }

    @Override
    public SCMMicroContent save(SCMMicroContent _oMicroContent, Accounts _oAccounts, Map _oExtraParams) throws Exception {
        if (_oMicroContent == null) {
            throw new Exception("\u8981\u53d1\u5e03\u7684\u5fae\u535a\u4e3a\u7a7a\uff01");
        }
        if (_oAccounts == null || _oAccounts.size() == 0) {
            throw new Exception("\u8981\u53d1\u5e03\u5230\u7684\u8d26\u53f7\u4e3a\u7a7a\uff01");
        }
        User oUser = _oMicroContent.getCrUser();
        _oMicroContent.save(oUser);
        return _oMicroContent;
    }

    @Override
    public void createMicroContent(Accounts _oAccounts, SCMMicroContent _oMicroContent, Map _oExtraParams) throws Exception {
        String sContent = _oMicroContent.getContent();
        String sPicPaths = _oMicroContent.getPicture();
        String sPicPath = "";
        StringBuffer sBufPicPaths = new StringBuffer();
        boolean bWithPic = false;
        if (!CMyString.isEmpty(sPicPaths)) {
            String[] sPicPathArray = sPicPaths.split(",");
            for (int i = 0; i < sPicPathArray.length; ++i) {
                sPicPath = sPicPathArray[i];
                sPicPath = FilesMan.getFilesMan().mapFilePath(sPicPath, 0) + sPicPath;
                if (!CMyFile.fileExists(sPicPath)) {
                    throw new NullPointerException("\u6307\u5b9a\u7684\u56fe\u7247\u627e\u4e0d\u5230\uff0c\u56fe\u7247\u8def\u5f84\u4e3a[" + sPicPath + "]");
                }
                sBufPicPaths.append(sPicPath);
                if (sPicPathArray.length - 1 == i) continue;
                sBufPicPaths.append(",");
            }
            bWithPic = true;
        }
        ExtraParams oExtraParams = this.getExtraParams(_oExtraParams);
        int nSCMMicroContentId = _oMicroContent.getId();
        User oUser = _oMicroContent.getCrUser();
        int nSize = _oAccounts.size();
        for (int i = 0; i < nSize; ++i) {
            Account oAccount = (Account)_oAccounts.getAt(i);
            if (oAccount == null) continue;
            IMicroContentMgr oMicroContentMgr = this.queryMicroContentMgrByAccount(oAccount);
            MicroContent oMicroContent = bWithPic ? oMicroContentMgr.createMicroContent(sContent, sBufPicPaths.toString(), oExtraParams) : oMicroContentMgr.createMicroContent(sContent, oExtraParams);
            AccountMicroContent oAccountMicroContent = this.createAccountMicroContent(oAccount.getId(), nSCMMicroContentId, oMicroContent);
            oAccountMicroContent.save(oUser);
        }
    }

    private AccountMicroContent createAccountMicroContent(int _nAccountId, int _nSCMMicroContentId, MicroContent _oMicroContent) throws Exception {
        AccountMicroContent oAccountMicroContent = AccountMicroContent.createNewInstance();
        oAccountMicroContent.setAccountId(_nAccountId);
        oAccountMicroContent.setCommentCount(0L);
        oAccountMicroContent.setRepostCount(0L);
        oAccountMicroContent.setSCMMicroContentId(_nSCMMicroContentId);
        oAccountMicroContent.setMicroContentId(_oMicroContent.getId());
        return oAccountMicroContent;
    }

    @Override
    public Accounts findPostedAccounts(SCMMicroContent _oMicroContent) throws Exception {
        if (_oMicroContent == null) {
            throw new Exception("\u6307\u5b9a\u7684SCM\u5fae\u535a\u5bf9\u8c61\u4e3a\u7a7a\uff01");
        }
        String sWhere = "EXISTS(select 1 from XWCMACCOUNTMICROCONTENT where SCMMICROCONTENTID = ? and XWCMACCOUNTMICROCONTENT.ACCOUNTID = XWCMACCOUNT.ACCOUNTID)";
        WCMFilter oFilter = new WCMFilter("", sWhere, "");
        oFilter.addSearchValues(_oMicroContent.getId());
        Accounts oAccounts = Accounts.openWCMObjs(ContextHelper.getLoginUser(), oFilter);
        return oAccounts;
    }

    private ExtraParams getExtraParams(Map _oExtraParamMap) {
        if (_oExtraParamMap == null) {
            return null;
        }
        ExtraParams oExtraParams = new ExtraParams();
        oExtraParams.setParams(_oExtraParamMap);
        return oExtraParams;
    }

    private IMicroContentMgr queryMicroContentMgrByAccount(Account _oAccount) throws Exception {
        if (_oAccount == null) {
            throw new Exception("\u6307\u5b9a\u7684\u8d26\u53f7\u4e3a\u7a7a\uff01");
        }
        OAuth oOAuth = OAuthObjUtil.constructOAuth(_oAccount);
        String sPlatform = _oAccount.getPlatform();
        IMicroContentMgr oMicroContentMgr = PlatformFactory.createMicroContentMgr(sPlatform, oOAuth);
        return oMicroContentMgr;
    }

    public void changeFlowStatus(SCMMicroContent _SCMMicroContent2, Status _NewStatus) throws WCMException {
        if (_NewStatus == null) {
            throw new WCMException(10, "New status required!");
        }
        this.changeStatus(_SCMMicroContent2, _NewStatus.getId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void changeStatus(SCMMicroContent _MicroContent2, int _nNewStatus) throws WCMException {
        if (_MicroContent2 == null) {
            throw new NullPointerException("\u8981\u66f4\u65b0\u5ba1\u6838\u72b6\u6001\u7684\u5fae\u535a\u4e3a\u7a7a\uff01");
        }
        if (_MicroContent2.getStatusId() == _nNewStatus) {
            return;
        }
        User currUser = ContextHelper.getLoginUser();
        if (_MicroContent2.canEdit(currUser)) {
            try {
                boolean bPublished;
                boolean bl = bPublished = 10 == _MicroContent2.getStatusId();
                if (bPublished) {
                    _MicroContent2.setReviewTime(new CMyDateTime());
                }
                _MicroContent2.setStatus(_nNewStatus);
                _MicroContent2.save(currUser);
            }
            finally {
                _MicroContent2.unlock();
            }
        }
    }
}

