/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.wechat.service;

import com.trs.DreamFactory;
import com.trs.cms.ContextHelper;
import com.trs.cms.auth.persistent.User;
import com.trs.components.common.publish.domain.PublishServer;
import com.trs.components.common.publish.persistent.element.IPublishFolder;
import com.trs.components.common.publish.persistent.element.PublishElementFactory;
import com.trs.components.common.publish.persistent.publisher.FolderPublishConfig;
import com.trs.components.metadata.center.MetaViewData;
import com.trs.components.metadata.center.MetaViewDatas;
import com.trs.components.metadata.definition.MetaView;
import com.trs.components.metadata.service.MetaDataCenterServiceProvider;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.components.wcm.content.persistent.ChnlDoc;
import com.trs.components.wcm.content.persistent.ChnlDocs;
import com.trs.components.wcm.content.persistent.Documents;
import com.trs.components.wcm.util.INameGenerator;
import com.trs.components.wechat.IWeChatMgr;
import com.trs.components.wechat.service.WXLoadConfig;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.support.config.ConfigServer;
import com.trs.infra.util.CMyDateTime;
import com.trs.infra.util.CMyException;
import com.trs.infra.util.CMyString;
import com.trs.webframework.context.MethodContext;
import com.trs.webframework.controler.JSPRequestProcessor;
import com.trs.webframework.provider.IQueryServiceProvider;
import com.trs.webframework.provider.ISelfDefinedServiceProvider;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class WXInteractionServiceProvider
implements ISelfDefinedServiceProvider,
IQueryServiceProvider {
    private static Logger logger = Logger.getLogger(WXInteractionServiceProvider.class);
    private Map mWXChannelMetaViewMapping;
    private Map mWXChannelOutlineTemplateMapping;
    private Map mWXChannelDetailTemplateMapping;
    private IWeChatMgr m_WeChatMgr = (IWeChatMgr)DreamFactory.createObjectById("IWeChatMgr");

    private void changePChannel(Channel pChannel) throws WCMException {
        if (this.m_WeChatMgr.isWXCustomMenu(pChannel)) {
            return;
        }
        pChannel.setAttribute("chnlType", "4");
        pChannel.save();
    }

    private void isAllow(Channel pChannel, int menuId) throws WCMException {
        User currUser = this.getLoginUser();
        if (this.m_WeChatMgr.isWXCustomMenu(pChannel)) {
            if (this.m_WeChatMgr.isWXCustomMenu(Channel.findById(menuId).getParent())) {
                return;
            }
            if (pChannel.getChildrenSize(currUser) >= 3) {
                throw new WCMException("\u5f53\u524d\u83dc\u5355\u5df2\u7ecf\u62e5\u6709\u6700\u5927\u9650\u5236\u7684\u5b50\u83dc\u5355\uff0c\u65e0\u6cd5\u7ee7\u7eed\u521b\u5efa\uff01");
            }
        } else {
            if (!this.m_WeChatMgr.isWXCustomMenu(Channel.findById(menuId).getParent())) {
                return;
            }
            if (pChannel.getChildrenSize(currUser) >= 5) {
                throw new WCMException("\u5f53\u524d\u83dc\u5355\u5df2\u7ecf\u62e5\u6709\u6700\u5927\u9650\u5236\u7684\u5b50\u83dc\u5355\uff0c\u65e0\u6cd5\u7ee7\u7eed\u521b\u5efa\uff01");
            }
        }
    }

    @Override
    public String query(MethodContext _methodContext) throws Throwable {
        User currUser = this.getLoginUser();
        int channelid = _methodContext.getValue("nodeId", -1);
        Channel channel = Channel.findById(channelid);
        StringBuffer bJson = new StringBuffer();
        bJson.append("{\"root\":[");
        List<Channel> childChannels = channel.getChildren(currUser, 0);
        for (int i = 0; i < childChannels.size(); ++i) {
            Channel childChannel = childChannels.get(i);
            String chnlTypes = childChannel.getAttributeValue("chnlType");
            int chnlType = 1;
            if (!CMyString.isEmpty(chnlTypes)) {
                chnlType = Integer.parseInt(childChannel.getAttributeValue("chnlType"));
            }
            int textRecId = 0;
            int appRecId = 0;
            String appContent = "-1";
            String sMetaViewName = (String)WXLoadConfig.getMetaViewMaping().get("0");
            MetaView viewText = MetaView.findByIdentity("VIEWDESC", sMetaViewName);
            MetaViewDatas viewDatasText = new MetaViewDatas(viewText);
            viewDatasText.open(childChannel, null);
            if (viewDatasText.size() > 0) {
                MetaViewData viewData = (MetaViewData)viewDatasText.getAt(0);
                textRecId = viewData.getChnlDocId();
            }
            String sMetaViewNameApp = (String)WXLoadConfig.getMetaViewMaping().get("3");
            MetaView viewApp = MetaView.findByIdentity("VIEWDESC", sMetaViewNameApp);
            MetaViewDatas viewDatasApp = new MetaViewDatas(viewApp);
            viewDatasApp.open(childChannel, null);
            if (viewDatasApp.size() > 0) {
                MetaViewData viewData = (MetaViewData)viewDatasApp.getAt(0);
                appContent = viewData.getPropertyAsString("appId");
                appRecId = viewData.getChnlDocId();
            }
            HashMap param = new HashMap();
            JSPRequestProcessor oProcessor = new JSPRequestProcessor();
            bJson.append("{\"data-nodeName\": \"").append(CMyString.filterForHTMLValue(childChannel.getDesc())).append("\" ,\"nodeId\": \"").append(childChannel.getId()).append("\" ,\"nodeType\": \"").append(chnlType).append("\" ,\"textRecId\": \"").append(textRecId).append("\" ,\"appRecId\": \"").append(appRecId).append("\" ,\"appContent\": \"").append(appContent).append("\"},");
        }
        if (childChannels.size() > 0) {
            bJson.deleteCharAt(bJson.length() - 1);
        }
        bJson.append("]}");
        return bJson.toString();
    }

    public void remove(MethodContext _methodContext) throws Throwable {
        int menuId = _methodContext.getValue("menuId", -1);
        Channel menuChannel = Channel.findById(menuId);
        if (!this.m_WeChatMgr.isWXCustomSubMenu(menuChannel)) {
            throw new WCMException("\u6240\u9009\u680f\u76ee\u4e0d\u662f\u81ea\u5b9a\u4e49\u83dc\u5355\u4e0b\u7684\u5b50\u680f\u76ee\uff01");
        }
        JSPRequestProcessor processsor = new JSPRequestProcessor();
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("OBJECTIDS", menuId);
        params.put("Drop", "true");
        processsor.excute("wcm61_channel", "delete", params);
    }

    public String update(MethodContext _methodContext) throws Throwable {
        User currUser = this.getLoginUser();
        int nodeId = _methodContext.getValue("nodeId", -1);
        int nodeType = _methodContext.getValue("nodeType", -1);
        Channel channel = Channel.findById(nodeId);
        channel.setAttribute("chnlType", nodeType + "");
        this.setMetaViewAndTemplate(channel, nodeType);
        channel.setType(0);
        channel.save(currUser);
        JSPRequestProcessor processsor = new JSPRequestProcessor();
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("OBJECTIDS", nodeId + "");
        params.put("OBJECTTYPE", "101");
        processsor.excute("wcm6_publish", "soloPublish", params);
        if (nodeType != 0 && nodeType != 3) {
            return "";
        }
        String content = "";
        params = new HashMap();
        params.put("ChannelId", nodeId + "");
        MetaViewDatas viewDatas = (MetaViewDatas)processsor.excute("wcm61_metaviewdata", "queryViewDatas", params);
        if (viewDatas.size() > 0) {
            MetaViewData viewData = (MetaViewData)viewDatas.getAt(0);
            content = nodeType == 0 ? viewData.getPropertyAsString("content") : viewData.getPropertyAsString("appID");
        }
        return content;
    }

    public void synchMenu(MethodContext _methodContext) throws Throwable {
        int zdyChannelId = _methodContext.getValue("menuId", -1);
        Channel zdyChannel = Channel.findById(zdyChannelId);
        PublishServer pubServer = PublishServer.getInstance();
        IPublishFolder folder = (IPublishFolder)PublishElementFactory.makeElementFrom(zdyChannel);
        pubServer.publishFolder(folder, 8);
    }

    private User getLoginUser() {
        User loginUser = ContextHelper.getLoginUser();
        return loginUser;
    }

    private Channel saveChannel(MethodContext _methodContext, int zdyChannelId) throws Throwable {
        User loginUser = this.getLoginUser();
        String sMenuName = _methodContext.getValue("menuName");
        int nParentId = _methodContext.getValue("parentId", -1);
        int nMenuType = _methodContext.getValue("menuType", -1);
        int nWXSiteId = Integer.parseInt(ConfigServer.getServer().getSysConfigValue("WX_SITE_ID", ""));
        Channel oChannel = new Channel();
        INameGenerator m_oNameGenerator = (INameGenerator)DreamFactory.createObjectById("INameGenerator");
        String sNewMenuName = m_oNameGenerator.generate(oChannel, "CHNLNAME", sMenuName);
        oChannel.setName(sNewMenuName);
        oChannel.setDesc(sMenuName);
        oChannel.setParent(nParentId);
        oChannel.setSite(nWXSiteId);
        oChannel.setCanPub(true);
        oChannel.setType(0);
        oChannel.setAttribute("chnlType", nMenuType + "");
        if (nMenuType == 2) {
            String sLinkUrl = _methodContext.getValue("link");
            oChannel.setLinkUrl(sLinkUrl);
            oChannel.setType(11);
        }
        oChannel.save(loginUser);
        FolderPublishConfig pubConfig = FolderPublishConfig.createNewInstance();
        WCMFilter filter = new WCMFilter("", "FolderType=? and FolderId in(select ChannelId from WCMChannel where SiteId=?)", "");
        filter.addSearchValues(101);
        filter.addSearchValues(nWXSiteId);
        String sDataPath = m_oNameGenerator.generate(pubConfig, "DataPath", sMenuName, filter);
        pubConfig.setFolder(101, oChannel.getId());
        pubConfig.setDataPath(sDataPath);
        pubConfig.save(loginUser);
        this.setMetaViewAndTemplate(oChannel, nMenuType);
        if (nMenuType == 1) {
            this.setSyn(oChannel, zdyChannelId);
        }
        String content = _methodContext.getValue("content");
        if (nMenuType == 0 && !CMyString.isEmpty(content)) {
            _methodContext.setValue("OBJECTID", 0);
            _methodContext.setValue("CHANNELID", oChannel.getId());
            MetaDataCenterServiceProvider oMetaDataCenterSP = new MetaDataCenterServiceProvider();
            MetaViewData metaViewData = oMetaDataCenterSP.saveMetaViewData(_methodContext);
        }
        return oChannel;
    }

    private void setSyn(Channel oChannel, int dstChannelId) throws CMyException {
        CMyDateTime datetime = new CMyDateTime();
        String date = datetime.now().toString("yyyy-MM-dd");
        String edate = datetime.now().dateAdd(1, 10).toString();
        JSPRequestProcessor processsor = new JSPRequestProcessor();
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("CHANNELID", oChannel.getId());
        params.put("OBJECTID", 0);
        params.put("CHANNELASTARGET", "false");
        params.put("SDATE", date);
        params.put("EDATE", edate);
        params.put("DOCSDATE", date);
        params.put("DOCEDATE", date);
        params.put("SYNTYPES", "NEW,MODIFY");
        params.put("STATUSES", "2,3,10,15,16,18");
        params.put("STATUSESASS", "2,3,10,15,16,18");
        params.put("ATTRIBUTE", "TransmitType=3");
        params.put("TRANSMITTYPEASS", 3);
        params.put("DSTCHANNELIDS", dstChannelId + "");
        params.put("OPERAFTER", 0);
        processsor.excute("wcm6_documentSyn", "save", params);
    }

    private void setMetaViewAndTemplate(Channel oChannel, int nMenuType) throws WCMException {
        Map oWXChannelMetaViewMapping = WXLoadConfig.getMetaViewMaping();
        String sMetaViewName = (String)oWXChannelMetaViewMapping.get(nMenuType + "");
        this.m_WeChatMgr.setMetaView(oChannel, sMetaViewName);
        Map oWXChannelOutlineTemplateMapping = WXLoadConfig.getOutLineTemplateMaping();
        String sOutlineTemplateName = (String)oWXChannelOutlineTemplateMapping.get(nMenuType + "");
        Map oWXChannelDetailTemplateMapping = WXLoadConfig.getDetailTemplateMaping();
        String sDetailTemplateName = (String)oWXChannelDetailTemplateMapping.get(nMenuType + "");
        if (!CMyString.isEmpty(sOutlineTemplateName)) {
            this.m_WeChatMgr.setTemplate(oChannel, sOutlineTemplateName);
        }
        if (!CMyString.isEmpty(sDetailTemplateName)) {
            this.m_WeChatMgr.setTemplate(oChannel, sDetailTemplateName);
        }
    }

    private void traverse(List channel, StringBuffer bJson) throws WCMException, UnsupportedEncodingException {
        User currUser = this.getLoginUser();
        if (channel == null || channel.size() == 0) {
            return;
        }
        for (int i = 0; i < channel.size(); ++i) {
            Channel childChannel = (Channel)channel.get(i);
            String chnlType = childChannel.getAttributeValue("chnlType");
            String content = "";
            HashMap<String, Object> param = new HashMap<String, Object>();
            int recId = 0;
            JSPRequestProcessor oProcessor = new JSPRequestProcessor();
            if (CMyString.isEmpty(chnlType)) continue;
            int menuType = Integer.parseInt(chnlType);
            block1 : switch (menuType) {
                case 0: {
                    String sMetaViewName = (String)WXLoadConfig.getMetaViewMaping().get("0");
                    int viewid = this.m_WeChatMgr.getMetaView(sMetaViewName).getId();
                    param.put("ViewId", viewid);
                    param.put("ChannelId", childChannel.getId());
                    MetaViewDatas viewDatas = (MetaViewDatas)oProcessor.excute("wcm61_metaviewdata", "queryViewDatas", param);
                    if (viewDatas.size() <= 0) {
                        content = "\u6682\u672a\u5f55\u5165\u5185\u5bb9";
                        break;
                    }
                    content = viewDatas.getAt(0).getPropertyAsString("content");
                    MetaViewData viewData = (MetaViewData)viewDatas.getAt(0);
                    recId = viewData.getChnlDocId();
                    break;
                }
                case 1: {
                    WCMFilter filter = new WCMFilter();
                    filter.setWhere("chnlId=" + childChannel.getId() + " and docstatus > 0");
                    ChnlDocs chnlDocs = ChnlDocs.openWCMObjs(this.getLoginUser(), filter);
                    content = "\u6682\u672a\u5f55\u5165\u5185\u5bb9";
                    for (int j = 0; j < chnlDocs.size(); ++j) {
                        ChnlDoc chnlDoc = (ChnlDoc)chnlDocs.getAt(j);
                        int dockind = chnlDoc.getPropertyAsInt("DOCKIND", 0);
                        if (dockind != 0) continue;
                        content = chnlDoc.getDocument().getContent();
                        recId = chnlDoc.getPropertyAsInt("recid", 0);
                        break block1;
                    }
                    break;
                }
                case 2: {
                    content = childChannel.getLinkUrl();
                    break;
                }
                case 3: {
                    param.put("ChannelId", childChannel.getId());
                    param.put("SelectFields", "DOCTITLE");
                    Documents appTitleDocs = (Documents)oProcessor.excute("wcm6_document", "query", param);
                    if (appTitleDocs.size() <= 0) {
                        content = "\u6682\u672a\u5f55\u5165\u5185\u5bb9";
                        break;
                    }
                    appTitleDocs.getAt(0).getPropertyAsString("DOCTITLE");
                    recId = appTitleDocs.getAt(0).getId();
                    break;
                }
                case 4: {
                    content = "\u6b64\u83dc\u5355\u5e76\u6ca1\u6709\u7c7b\u578b\u9009\u62e9\uff0c\u4ec5\u663e\u793a\u5176\u5b50\u83dc\u5355\u3002";
                    break;
                }
            }
            bJson.append("{\"data-nodeName\": \"").append(CMyString.filterForHTMLValue(childChannel.getDesc())).append("\" ,\"nodeId\": \"").append(childChannel.getId()).append("\" ,\"order\": \"").append(childChannel.getOrder()).append("\" ,\"recid\": \"").append(recId).append("\" ,\"nodeType\": \"").append(chnlType).append("\" ,\"content\": \"").append(URLEncoder.encode(content.length() > 30 ? CMyString.truncateStr(content, 60) + "..." : content, "utf-8")).append("\"");
            try {
                List<Channel> grandChildChannel = childChannel.getChildren(currUser, 0);
                if (grandChildChannel != null && grandChildChannel.size() > 0) {
                    bJson.append(",\"childNodes\":[");
                    this.traverse(grandChildChannel, bJson);
                    bJson.append("]");
                }
                bJson.append("},");
                continue;
            }
            catch (WCMException e) {
                throw new RuntimeException("\u904d\u5386\u83dc\u5355\u51fa\u9519\uff01", e);
            }
        }
        if (bJson.charAt(bJson.length() - 1) == ',') {
            bJson.deleteCharAt(bJson.length() - 1);
        }
    }

    public String getFolderMenu(MethodContext _methodContext) throws Throwable {
        User currUser = this.getLoginUser();
        int gzhChannelId = _methodContext.getValue("gzhChannelId", -1);
        Channel customMenu = this.getCumstomMenu(gzhChannelId);
        if (customMenu == null) {
            throw new WCMException("\u680f\u76ee\u7ed3\u6784\u6709\u8bef\uff0c\u6ca1\u6709\u81ea\u5b9a\u4e49\u83dc\u5355\u680f\u76ee\u3002");
        }
        List<Channel> childList = customMenu.getChildren(currUser);
        StringBuffer bJson = new StringBuffer();
        bJson.append("{\"root\":[{\"data-nodeName\":\"\u5fae\u83dc\u5355\",\"nodeId\":\"" + customMenu.getId() + "\"},");
        for (int i = 0; i < childList.size(); ++i) {
            Channel channel = childList.get(i);
            bJson.append("{\"data-nodeName\":\"").append(channel.getDesc()).append("\",\"nodeId\":\"").append(channel.getId()).append("\"},");
        }
        bJson.deleteCharAt(bJson.length() - 1);
        bJson.append("]}");
        return bJson.toString();
    }

    private Channel getCumstomMenu(int gzhChannelId) throws WCMException {
        Channel gzhChannel = Channel.findById(gzhChannelId);
        List<Channel> childList = gzhChannel.getChildren(this.getLoginUser());
        String customMenuName = ConfigServer.getServer().getSysConfigValue("WX_MENU_CHANNEL_DESC", "\u81ea\u5b9a\u4e49\u83dc\u5355");
        for (int i = 0; i < childList.size(); ++i) {
            Channel customMenu = childList.get(i);
            if (!customMenu.getDesc().equalsIgnoreCase(customMenuName)) continue;
            return customMenu;
        }
        return null;
    }
}

