/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.metadata.definition;

import com.trs.DreamFactory;
import com.trs.cms.auth.persistent.User;
import com.trs.components.metadata.definition.IMetaDataDefMgr;
import com.trs.components.metadata.definition.IMetaViewFieldGroupMgr;
import com.trs.components.metadata.definition.MetaView;
import com.trs.components.metadata.definition.MetaViewField;
import com.trs.components.metadata.definition.MetaViewFieldGroup;
import com.trs.components.metadata.definition.MetaViewFieldGroups;
import com.trs.components.metadata.definition.MetaViewFields;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.WCMFilter;

public class MetaViewFieldGroupMgr
implements IMetaViewFieldGroupMgr {
    private IMetaDataDefMgr m_oMetaDataDefMgr = (IMetaDataDefMgr)DreamFactory.createObjectById("IMetaDataDefMgr");
    public static final int GROUPID_NUM = 0;

    @Override
    public MetaViewFieldGroups queryGroupsForSelectParent(User _currUser, MetaViewFieldGroup group, int _nMetaviewId) throws WCMException {
        int nCurrGroupId = 0;
        if (group != null) {
            nCurrGroupId = group.getId();
        }
        WCMFilter filter = new WCMFilter("", "", "GroupOrder ASC");
        String sWhere = "PARENTID=0 AND METAVIEWID=?";
        filter.addSearchValues(_nMetaviewId);
        if (nCurrGroupId > 0) {
            sWhere = sWhere + " AND METAVIEWFIELDGROUPID !=?";
            filter.addSearchValues(nCurrGroupId);
        }
        filter.setWhere(sWhere);
        return MetaViewFieldGroups.openWCMObjs(_currUser, filter);
    }

    @Override
    public MetaViewFieldGroups queryGroupsForView(User user, MetaView metaView, WCMFilter _oFilter) throws WCMException {
        if (metaView == null) {
            throw new WCMException(I18NMessage.get(MetaViewFieldGroupMgr.class, "MetaViewFieldGroupMgr.label1", "\u89c6\u56fe\u5bf9\u8c61\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u83b7\u53d6\u5176\u5206\u7ec4\uff01"));
        }
        int nMetaViewId = metaView.getId();
        WCMFilter filter = new WCMFilter("", "METAVIEWID=?", "GroupOrder ASC");
        filter.addSearchValues(nMetaViewId);
        if (_oFilter != null) {
            filter.mergeWith(_oFilter);
        }
        return MetaViewFieldGroups.openWCMObjs(user, filter);
    }

    @Override
    public MetaViewFields queryViewFieldsByViewAndGroup(User user, MetaView metaView, MetaViewFieldGroup group) throws WCMException {
        if (metaView == null) {
            throw new WCMException(I18NMessage.get(MetaViewFieldGroupMgr.class, "MetaViewFieldGroupMgr.label2", "\u89c6\u56fe\u5bf9\u8c61\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u83b7\u53d6\u5176\u5b57\u6bb5\u96c6\u5408\uff01"));
        }
        if (group == null) {
            throw new WCMException(I18NMessage.get(MetaViewFieldGroupMgr.class, "MetaViewFieldGroupMgr.label3", "\u5b57\u6bb5\u5206\u7ec4\u5bf9\u8c61\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u83b7\u53d6\u5176\u4e0b\u7684\u5b57\u6bb5\u96c6\u5408\uff01"));
        }
        WCMFilter filter = new WCMFilter("", "VIEWID=? AND FIELDGROUPID=?", "FIELDORDER desc");
        filter.addSearchValues(metaView.getId());
        filter.addSearchValues(group.getId());
        return MetaViewFields.openWCMObjs(user, filter);
    }

    @Override
    public MetaViewFieldGroup findGroup(MetaView _oView, String _sGroupName) throws WCMException {
        WCMFilter filter = new WCMFilter("", "ParentId=0 and MetaViewId=? and GroupName=?", "");
        filter.addSearchValues(_oView.getId());
        filter.addSearchValues(_sGroupName);
        MetaViewFieldGroups groups = MetaViewFieldGroups.openWCMObjs(null, filter);
        if (groups.isEmpty()) {
            return null;
        }
        return (MetaViewFieldGroup)groups.getAt(0);
    }

    @Override
    public MetaViewFieldGroups queryChildGroups(MetaView view, MetaViewFieldGroup _group) throws WCMException {
        WCMFilter filter = new WCMFilter("", "MetaViewId=? and ParentId=?", "");
        filter.addSearchValues(view.getId());
        filter.addSearchValues(_group.getId());
        return MetaViewFieldGroups.openWCMObjs(null, filter);
    }

    @Override
    public void delete(User user, MetaViewFieldGroup metaViewFieldGroup) throws WCMException {
        int nGroupId = metaViewFieldGroup.getId();
        int nViewId = metaViewFieldGroup.getMetaViewId();
        MetaView oMetaView = MetaView.findById(nViewId);
        MetaViewFields oMetaViewFields = this.m_oMetaDataDefMgr.getViewFields(user, oMetaView, null);
        metaViewFieldGroup.delete(user);
        int nSize = oMetaViewFields.size();
        for (int i = 0; i < nSize; ++i) {
            MetaViewField oMetaViewField = (MetaViewField)oMetaViewFields.getAt(i);
            if (oMetaViewField == null || oMetaViewField.getPropertyAsInt("FIELDGROUPID", 0) != nGroupId) continue;
            oMetaViewField.setProperty("FIELDGROUPID", 0L);
            oMetaViewField.save(user);
        }
    }
}

