/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.common.message.notify;

import com.trs.DreamFactory;
import com.trs.components.common.message.notify.NotificationSchemeConfig;
import com.trs.infra.BaseServer;
import com.trs.infra.config.XMLConfigServer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.aton.container.IClearable;

public class NotificationServer
extends BaseServer
implements IClearable {
    private static final Logger logger = Logger.getLogger((String)NotificationServer.class.getName());
    private Map m_hSchemes = new HashMap();
    private boolean m_bLoaded = false;

    public synchronized void clear() {
        this.m_hSchemes.clear();
    }

    public static NotificationServer getInstance() {
        NotificationServer server = (NotificationServer)DreamFactory.createObjectById("NotificationServer");
        if (!server.isStarted()) {
            server.startup();
        }
        return server;
    }

    public NotificationSchemeConfig lookupSchemeForEvent(String _sEvent) {
        NotificationServer server = NotificationServer.getInstance();
        return (NotificationSchemeConfig)server.m_hSchemes.get(_sEvent);
    }

    public boolean needNotifyForEvent(String _sEvent) {
        NotificationSchemeConfig scheme = NotificationServer.getInstance().lookupSchemeForEvent(_sEvent);
        return scheme != null && scheme.isEnabled();
    }

    public synchronized void refresh() {
        if (this.m_bLoaded) {
            this.clear();
            this.m_bLoaded = false;
        }
        List listNotiSchemeConfig = XMLConfigServer.getInstance().getConfigObjects(NotificationSchemeConfig.class);
        for (int i = 0; i < listNotiSchemeConfig.size(); ++i) {
            NotificationSchemeConfig scheme = (NotificationSchemeConfig)listNotiSchemeConfig.get(i);
            this.m_hSchemes.put(scheme.getEvent(), scheme);
        }
        this.m_bLoaded = true;
        logger.info((Object)"Finished to refresh the notification server.");
    }

    @Override
    protected void doShutdown() {
        this.clear();
    }

    @Override
    protected boolean doStart() {
        this.refresh();
        return this.m_bLoaded;
    }
}

