/*
 * Decompiled with CFR 0.152.
 */
package com.eprobiti.trs;

import com.eprobiti.trs.TRSJNIV61;

public class TRSException
extends Exception {
    private static final long serialVersionUID = 1L;
    private int ErrorNo = 0;
    private static final String[] ErrorTable = new String[]{"", "", "-500001,\u65f6\u95f4\u683c\u5f0f\u4e0d\u6b63\u786e", "-500001,invalid dateformat", "-500002,\u8fde\u63a5\u53e5\u67c4\u4e3a\u7a7a", "-500002,connection null", "-500003,\u83b7\u53d6\u9519\u8bef\u4fe1\u606f\u5931\u8d25", "-500003,get error failed", "-500004,\u6ca1\u6709\u627e\u5230\u672c\u5730\u65b9\u6cd5\u5e93", "-500004,native library not found", "-500005,\u4e0d\u80fd\u8fde\u63a5\u5230\u672c\u5730\u65b9\u6cd5\u5e93", "-500005,native library found, but can't linked", "-500006,\u672c\u5730\u65b9\u6cd5\u5e93\u7248\u672c\u4e0d\u5339\u914d", "-500006,native library version mismatched", "-500007,\u672c\u5730\u65b9\u6cd5\u5e93\u65f6\u672a\u77e5\u9519\u8bef", "-500007,native library unknown error", "-500008,\u9519\u8bef\u7684\u8bed\u8a00\u7c7b\u578b", "-500008,Language error", "-500009,\u5c5e\u6027\u4e32\u5207\u5206\u9519\u8bef", "-500009,property split error", "-500010,\u5c5e\u6027\u540d\u9519\u8bef", "-500010,property name error", "-500011,\u5c5e\u6027\u503c\u9519\u8bef", "-500011,property value error", "-500012,\u5c5e\u6027\u4e0d\u5b58\u5728", "-500012,property not found", "-500013,\u9519\u8bef\u7684\u8bcd\u5178\u7c7b\u578b", "-500013,invalid knowass", "-500014,\u65e0\u6548\u7684\u5bf9\u8c61\u540d\u79f0", "-500014,invalid object name", "-500015,\u65e0\u6548\u7684\u5bf9\u8c61\u7c7b\u578b", "-500015,invalid object type", "-500016,\u65e0\u6548\u7684\u53c2\u6570", "-500016,invalid parameter", "-500017,\u8bb0\u5f55\u5b57\u6bb5\u503c\u4e3a\u7a7a", "-500017,column value empty", "-500018,\u672a\u8fdb\u884c\u68c0\u7d22,\u53e5\u67c4\u4e3a\u7a7a", "-500018,result null", "-500019,\u8bb0\u5f55\u4f4d\u7f6e\u65e0\u6548", "-500019,invalid reocord pos", "-500020,\u5b57\u6bb5\u540d\u65e0\u6548", "-500020,invalid column name", "-500021,\u5b57\u6bb5\u4e0d\u5b58\u5728", "-500021,column not found", "-500022,\u5b57\u6bb5\u7c7b\u578b\u65e0\u6548", "-500022,invalid column type", "-500023,\u5b57\u6bb5\u503c\u65e0\u6548", "-500023,invalid column value", "-500024,\u5bf9\u8c61\u7684\u5b57\u6bb5\u5217\u8868\u4e3a\u7a7a", "-500024,column list null", "-500025,\u5b57\u6bb5\u540d\u5217\u8868\u4e2a\u6570\u4e0d\u4e00\u81f4", "-500025,column count mismatched", "-500026,\u5220\u9664\u6761\u4ef6\u65e0\u6548", "-500026,invalid where"};
    protected static final int ERR_NONE = 500000;
    protected static final int ERR_DATAFORMAT = 500001;
    protected static final int ERR_CONNECT_HANDLE = 500002;
    protected static final int ERR_LAST_FAILED = 500003;
    protected static final int ERR_JNI_DLLNOFOUND = 500004;
    protected static final int ERR_JNI_DLLNOLINKED = 500005;
    protected static final int ERR_JNI_VERMISMATCH = 500006;
    protected static final int ERR_JNI_DLLUNKNOWN = 500007;
    protected static final int ERR_LANGUAGE_TYPE = 500008;
    protected static final int ERR_PROPERTY_SPLIT = 500009;
    protected static final int ERR_PROPERTY_NAME = 500010;
    protected static final int ERR_PROPERTY_VALUE = 500011;
    protected static final int ERR_PROPERTY_NOFOUND = 500012;
    protected static final int ERR_KNOWASS_TYPE = 500013;
    protected static final int ERR_OBJECT_NAME = 500014;
    protected static final int ERR_OBJECT_TYPE = 500015;
    protected static final int ERR_INVALID_PARAMETER = 500016;
    protected static final int ERR_EMPTY_VALUES = 500017;
    protected static final int ERR_RESULT_HANDLE = 500018;
    protected static final int ERR_RECORD_POS = 500019;
    protected static final int ERR_COLUMN_NAME = 500020;
    protected static final int ERR_COLUMN_NOFOUND = 500021;
    protected static final int ERR_COLUMN_TYPE = 500022;
    protected static final int ERR_COLUMN_VALUE = 500023;
    protected static final int ERR_COLUMN_LIST = 500024;
    protected static final int ERR_COLUMN_NUM = 500025;
    protected static final int ERR_DELETE_WHERE = 500026;
    private static final int ERR_MIN = 500000;
    private static final int ERR_NUM = ErrorTable.length / 2;
    private static final int ERR_MAX = 500000 + ERR_NUM;

    public TRSException() {
    }

    public TRSException(String strErrorMsg) {
        super(strErrorMsg);
    }

    public TRSException(int iErrorCode, String strErrorMsg) {
        super(strErrorMsg);
        this.ErrorNo = iErrorCode;
    }

    static TRSException New(int iErrorCode, String strErrorMsg) throws TRSException {
        int idx;
        if (iErrorCode >= 500000 && iErrorCode <= ERR_MAX && (idx = 2 * (iErrorCode - 500000) + TRSJNIV61.DLLErrorEnglish) < ErrorTable.length && ErrorTable[idx] != null && ErrorTable[idx].length() != 0) {
            strErrorMsg = strErrorMsg == null || strErrorMsg.length() == 0 ? ErrorTable[idx] : String.valueOf(ErrorTable[idx]) + "," + strErrorMsg;
        }
        throw new TRSException(iErrorCode, strErrorMsg);
    }

    public int getErrorCode() {
        return this.ErrorNo;
    }

    public String getErrorString() {
        return this.getMessage();
    }
}

