/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.metadata.service;

import com.trs.DreamFactory;
import com.trs.components.metadata.center.MetaViewData;
import com.trs.components.metadata.center.MetaViewDatas;
import com.trs.components.metadata.definition.ClassInfo;
import com.trs.components.metadata.definition.ClassInfos;
import com.trs.components.metadata.definition.IClassInfoMgr;
import com.trs.components.metadata.definition.MetaView;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.util.CMyDateTime;
import com.trs.infra.util.CMyMemory;
import com.trs.infra.util.CMyString;
import java.io.FileWriter;
import java.io.Writer;
import java.util.Enumeration;
import java.util.Hashtable;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class GovInfoToXML {
    private static int[] m_aYearSpan = new int[]{2003, 2008};
    private static String m_sClassInfoIds = "366";
    private static String m_sClassInfosTagName = "ClassInfos";
    private static String m_sClassInfoTagName = "ClassInfo";
    private static String m_sMetaDatasTagName = "MetaDatas";
    private static String m_sMetaDataTagName = "MetaData";
    private static String m_sPropertiesTagName = "Properties";
    private static int m_nMetaViewId = 39;
    private static int m_nProcessIndex = 1;
    private static WCMFilter m_oFilterOfYear = null;
    private static MetaView m_oMetaView = null;
    private static IClassInfoMgr m_oClassInfoMgr = null;
    private static boolean m_bDebug = true;
    private static String[] m_aFieldName = new String[]{"fileNum", "idxID", "acesmthd", "svobjcat", "Publisher", "PubDate", "Description", "Relation", "subcat"};

    public static void setYearSpan(String sYearSpan) {
        if (CMyString.isEmpty(sYearSpan)) {
            return;
        }
        int[] aTempYearSpan = CMyString.splitToInt(sYearSpan, ",");
        m_aYearSpan = new int[]{aTempYearSpan[0], aTempYearSpan.length > 1 ? aTempYearSpan[1] : aTempYearSpan[0]};
    }

    public static void setClassInfoIds(String sClassInfoIds) {
        m_sClassInfoIds = sClassInfoIds;
    }

    public static void setMetaViewId(int iMetaViewId) {
        m_nMetaViewId = iMetaViewId;
    }

    public void setDebug(boolean isDebug) {
        m_bDebug = isDebug;
    }

    public static Element toXML() throws Exception {
        m_oMetaView = MetaView.findById(m_nMetaViewId);
        m_oClassInfoMgr = (IClassInfoMgr)DreamFactory.createObjectById("IClassInfoMgr");
        Element rootElement = DocumentHelper.createElement((String)m_sClassInfosTagName);
        for (int nYear = m_aYearSpan[0]; nYear <= m_aYearSpan[1]; ++nYear) {
            GovInfoToXML.appendClassInfoOfYear(nYear, rootElement);
        }
        if (m_bDebug) {
            System.out.println(CMyMemory.toMemoryInfo());
        }
        FileWriter fw = new FileWriter("e:/GovInfo.xml");
        rootElement.write((Writer)fw);
        fw.close();
        return rootElement;
    }

    private static void appendClassInfoOfYear(int nYear, Element oNode) throws Exception {
        GovInfoToXML.storeWCMFilter(nYear);
        Element oClassInfoNode = oNode.addElement(m_sClassInfoTagName);
        Element oProperties = oClassInfoNode.addElement(m_sPropertiesTagName);
        oProperties.addElement("CName").addCDATA(GovInfoToXML.int2StrOfYear(nYear) + "\u5e74");
        ClassInfos oClassInfos = ClassInfos.findByIds(null, m_sClassInfoIds);
        GovInfoToXML.appendClassInfos(oClassInfoNode, oClassInfos);
    }

    private static void storeWCMFilter(int nYear) throws Exception {
        WCMFilter filter = new WCMFilter();
        filter.setOrder("PubDate asc");
        filter.setWhere("PubDate >= ? and PubDate < ?");
        CMyDateTime dtStart = new CMyDateTime();
        dtStart.setDateTimeWithString(nYear + "-1-1 00:00:00");
        filter.addSearchValues(dtStart);
        CMyDateTime dtEnd = new CMyDateTime();
        dtEnd.setDateTimeWithString(nYear + 1 + "-1-1 00:00:00");
        filter.addSearchValues(dtEnd);
        m_oFilterOfYear = filter;
    }

    private static void appendClassInfo(Element oNode, ClassInfo _oClassInfo) throws Exception {
        if (_oClassInfo == null) {
            return;
        }
        Element oClassInfoNode = oNode.addElement(m_sClassInfoTagName);
        GovInfoToXML.appendProperties(oClassInfoNode, _oClassInfo);
        GovInfoToXML.appendMetaDatas(oClassInfoNode, _oClassInfo);
        ClassInfos oClassInfos = m_oClassInfoMgr.queryChildren(null, _oClassInfo, null);
        GovInfoToXML.appendClassInfos(oClassInfoNode, oClassInfos);
    }

    private static void appendProperties(Element oNode, ClassInfo _oClassInfo) {
        if (_oClassInfo == null) {
            return;
        }
        Element oProperties = oNode.addElement(m_sPropertiesTagName);
        oProperties.addElement("CName").addCDATA(_oClassInfo.getName());
    }

    private static void appendMetaDatas(Element oNode, ClassInfo _oClassInfo) throws Exception {
        if (_oClassInfo == null) {
            return;
        }
        MetaViewDatas oMetaDatas = new MetaViewDatas(m_oMetaView);
        oMetaDatas.open(GovInfoToXML.getMetaDatasFilter(_oClassInfo));
        if (oMetaDatas == null || oMetaDatas.size() <= 0) {
            return;
        }
        Element oMetaDatasNode = oNode.addElement(m_sMetaDatasTagName);
        int nSize = oMetaDatas.size();
        for (int i = 0; i < nSize; ++i) {
            MetaViewData oMetaData = (MetaViewData)oMetaDatas.getAt(i);
            if (oMetaData == null) continue;
            GovInfoToXML.appendMetaData(oMetaDatasNode, oMetaData, _oClassInfo);
        }
    }

    public static WCMFilter getMetaDatasFilter(ClassInfo _oClassInfo) {
        if (_oClassInfo == null) {
            return null;
        }
        WCMFilter filter = new WCMFilter("", "", "PubDate asc");
        StringBuffer sbWhere = new StringBuffer(300);
        sbWhere.append("exists(select XWCMClassInfoView.MetaDataId");
        sbWhere.append(" from XWCMClassInfoView");
        sbWhere.append(" where XWCMClassInfoView.ClassInfoId = ?");
        filter.addSearchValues(_oClassInfo.getId());
        sbWhere.append(" and XWCMClassInfoView.MetaDataId=WCMMetaTableGovInfo.MetaDataId)");
        filter.setWhere(sbWhere.toString());
        filter.mergeWith(m_oFilterOfYear);
        return filter;
    }

    private static void appendMetaData(Element _oNode, MetaViewData _oMetaData, ClassInfo _oClassInfo) throws Exception {
        if (_oMetaData == null) {
            return;
        }
        Hashtable<String, String> propertis = new Hashtable<String, String>();
        for (int i = 0; i < m_aFieldName.length; ++i) {
            String sValue = _oMetaData.getRealProperty(m_aFieldName[i]);
            if (sValue == null || sValue.trim().equalsIgnoreCase("null")) {
                sValue = "";
            }
            propertis.put(m_aFieldName[i].toUpperCase(), sValue);
        }
        propertis.put("CCODE", CMyString.showNull(_oClassInfo.getCode(), ""));
        CMyDateTime dtEefect = _oMetaData.getPropertyAsDateTime("efectdate");
        if (dtEefect == null || dtEefect.isNull()) {
            propertis.put("efectdate".toUpperCase(), (String)propertis.get("PubDate".toUpperCase()));
        }
        Element eProperties = _oNode.addElement(m_sMetaDataTagName).addElement(m_sPropertiesTagName);
        Enumeration keys = propertis.keys();
        while (keys.hasMoreElements()) {
            String sKey = (String)keys.nextElement();
            String sValue = (String)propertis.get(sKey);
            eProperties.addElement(sKey).addCDATA(sValue);
        }
        if (m_bDebug) {
            System.out.println("\u5df2\u751f\u6210\u7b2c" + m_nProcessIndex++ + "\u6761\u8bb0\u5f55");
        }
    }

    private static void appendClassInfos(Element oNode, ClassInfos _oClassInfos) throws Exception {
        if (_oClassInfos == null || _oClassInfos.size() <= 0) {
            return;
        }
        Element oClassInfosNode = oNode.addElement(m_sClassInfosTagName);
        int nSize = _oClassInfos.size();
        for (int i = 0; i < nSize; ++i) {
            ClassInfo oClassInfo = (ClassInfo)_oClassInfos.getAt(i);
            if (oClassInfo == null) continue;
            GovInfoToXML.appendClassInfo(oClassInfosNode, oClassInfo);
        }
    }

    private static String int2StrOfYear(int nYear) {
        String[] aYearDesc = new String[]{"\u25cb", "\u4e00", "\u4e8c", "\u4e09", "\u56db", "\u4e94", "\u516d", "\u4e03", "\u516b", "\u4e5d"};
        StringBuffer sb = new StringBuffer(4);
        String sYear = String.valueOf(nYear);
        int length = sYear.length();
        for (int i = 0; i < length; ++i) {
            sb.append(aYearDesc[Integer.parseInt(sYear.substring(i, i + 1))]);
        }
        return sb.toString();
    }
}

