/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.common.publish.widget.fieldtype;

import com.trs.components.common.publish.widget.fieldtype.IFieldTypesCreator;
import com.trs.infra.common.WCMException;
import com.trs.infra.discover.IDiscovery;
import com.trs.infra.util.WCMDiscoveryFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class FieldTypesCreatorFactory {
    private static Logger logger = Logger.getLogger(FieldTypesCreatorFactory.class);
    private static Map mFieldTypeMapping = new HashMap();
    private static boolean mIsLoaded = false;

    private static void load() throws WCMException {
        if (mIsLoaded) {
            return;
        }
        mIsLoaded = true;
        IDiscovery discovery = WCMDiscoveryFactory.getDiscovery();
        Iterator itr = discovery.getImplementors(IFieldTypesCreator.class.getName());
        while (itr.hasNext()) {
            String sClassName = (String)itr.next();
            try {
                Class<?> objClass = Class.forName(sClassName);
                IFieldTypesCreator instance = (IFieldTypesCreator)objClass.newInstance();
                int nFieldType = instance.getTypeId();
                FieldTypesCreatorFactory.register(nFieldType, objClass);
            }
            catch (Exception e) {
                logger.error((Object)"\u52a0\u8f7dIFieldTypesCreator\u51fa\u73b0\u9519\u8bef\u3002", (Throwable)e);
            }
        }
    }

    public static void register(int nFieldType, Class objClass) throws WCMException {
        if (mFieldTypeMapping.get(new Integer(nFieldType)) != null) {
            throw new WCMException("\u5b57\u6bb5\u7c7b\u578b\u3010Id=" + nFieldType + "\u3011\u5df2\u7ecf\u88ab\u4f7f\u7528\u4e86\uff0c\u8bf7\u4f7f\u75281000\u4ee5\u4e0a\u7684\u6570\u5b57\u3002");
        }
        mFieldTypeMapping.put(new Integer(nFieldType), objClass);
    }

    public static IFieldTypesCreator getTypeCreator(int nFieldType) throws WCMException {
        FieldTypesCreatorFactory.load();
        Class objClass = (Class)mFieldTypeMapping.get(new Integer(nFieldType));
        try {
            return (IFieldTypesCreator)objClass.newInstance();
        }
        catch (Exception e) {
            logger.debug((Object)("\u521b\u5efaIFieldTypesCreator\u51fa\u73b0\u9519\u8bef[" + objClass + "]"), (Throwable)e);
            return null;
        }
    }

    public static List getFieldTypes() throws WCMException {
        FieldTypesCreatorFactory.load();
        ArrayList<IFieldTypesCreator> lsFieldTypes = new ArrayList<IFieldTypesCreator>();
        for (Object itKey : mFieldTypeMapping.keySet()) {
            Class objClass = (Class)mFieldTypeMapping.get(itKey);
            try {
                IFieldTypesCreator oFieldType = (IFieldTypesCreator)objClass.newInstance();
                lsFieldTypes.add(oFieldType);
            }
            catch (Exception e) {
                logger.error((Object)"\u5c06\u5b57\u6bb5\u7c7b\u578b\u7531map\u7ed3\u6784\u8f6c\u6210list\u7ed3\u6784\u51fa\u9519\u3002", (Throwable)e);
            }
        }
        Collections.sort(lsFieldTypes, new Comparator(){

            public int compare(Object o1, Object o2) {
                try {
                    IFieldTypesCreator IO1 = (IFieldTypesCreator)o1;
                    int nOrder1 = IO1.getTypeOrder();
                    IFieldTypesCreator IO2 = (IFieldTypesCreator)o2;
                    int nOrder2 = IO2.getTypeOrder();
                    return nOrder1 - nOrder2;
                }
                catch (Exception e) {
                    logger.error((Object)"\u6267\u884c\u6392\u5e8f\u8fc7\u7a0b\u51fa\u73b0\u9519\u8bef\u3002", (Throwable)e);
                    return 0;
                }
            }
        });
        return lsFieldTypes;
    }
}

