/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.common.publish.domain.distribute;

import com.trs.components.common.publish.domain.distribute.DistributionChangeListener;
import com.trs.components.common.publish.domain.distribute.IFileDistristributor;
import com.trs.components.common.publish.persistent.distribute.PublishDistribution;
import java.util.ArrayList;

public class FileDistributorImpUnion
implements IFileDistristributor,
DistributionChangeListener {
    private boolean m_zConfigChanged = false;
    private IFileDistristributor[] m_oDistristributors;

    FileDistributorImpUnion(IFileDistristributor[] list) {
        this.m_oDistristributors = list;
    }

    public int size() {
        IFileDistristributor[] distristributors = this.m_oDistristributors;
        return distristributors != null ? distristributors.length : 0;
    }

    @Override
    public int getConfigID() {
        return 0;
    }

    @Override
    public void setTargetRoot(PublishDistribution _distribution) throws Exception {
    }

    @Override
    public void distributeFile(String _sLocal, String _sPath, boolean _bCheckDstFileExits) throws Exception {
        if (this.m_zConfigChanged) {
            throw new IllegalStateException("PublishDistribution changed.");
        }
        IFileDistristributor[] distristributors = this.m_oDistristributors;
        if (distristributors == null || distristributors.length <= 0) {
            return;
        }
        for (int i = distristributors.length - 1; i >= 0; --i) {
            distristributors[i].distributeFile(_sLocal, _sPath, _bCheckDstFileExits);
        }
    }

    @Override
    public boolean withdrawFile(String _sFile, String _sPath) throws Exception {
        if (this.m_zConfigChanged) {
            throw new IllegalStateException("PublishDistribution changed.");
        }
        IFileDistristributor[] distristributors = this.m_oDistristributors;
        if (distristributors == null || distristributors.length <= 0) {
            return false;
        }
        ArrayList<Exception> lstExceptions = new ArrayList<Exception>();
        for (int i = distristributors.length - 1; i >= 0; --i) {
            try {
                distristributors[i].withdrawFile(_sFile, _sPath);
                continue;
            }
            catch (Exception ex) {
                lstExceptions.add(ex);
            }
        }
        if (lstExceptions.size() > 0) {
            throw (Exception)lstExceptions.get(0);
        }
        return true;
    }

    @Override
    public boolean withdrawPath(String _sPath) throws Exception {
        if (this.m_zConfigChanged) {
            throw new IllegalStateException("PublishDistribution changed.");
        }
        IFileDistristributor[] distristributors = this.m_oDistristributors;
        if (distristributors == null || distristributors.length <= 0) {
            return false;
        }
        ArrayList<Exception> lstExceptions = new ArrayList<Exception>();
        for (int i = distristributors.length - 1; i >= 0; --i) {
            try {
                distristributors[i].withdrawPath(_sPath);
                continue;
            }
            catch (Exception ex) {
                lstExceptions.add(ex);
            }
        }
        if (lstExceptions.size() > 0) {
            throw (Exception)lstExceptions.get(0);
        }
        return true;
    }

    @Override
    public void onChange(int iDistributionID) {
        this.m_zConfigChanged = true;
    }

    @Override
    public synchronized void onDelete(int iDistributionID) {
        if (this.m_oDistristributors == null || this.m_oDistristributors.length <= 0) {
            return;
        }
        IFileDistristributor[] oldlist = this.m_oDistristributors;
        int iOldLength = oldlist.length;
        boolean zFound = false;
        for (int i = 0; i < iOldLength; ++i) {
            IFileDistristributor aDsbt = oldlist[i];
            if (aDsbt.getConfigID() != iDistributionID) continue;
            zFound = true;
            break;
        }
        if (zFound) {
            IFileDistristributor[] newlist = null;
            if (iOldLength > 1) {
                newlist = new IFileDistristributor[iOldLength - 1];
                int j = 0;
                for (int i = 0; i < iOldLength; ++i) {
                    IFileDistristributor aDsbt = oldlist[i];
                    if (aDsbt.getConfigID() == iDistributionID) continue;
                    newlist[j++] = aDsbt;
                }
            }
            this.m_oDistristributors = newlist;
        }
    }

    @Override
    public boolean renameFile(String _sSourceFile, String _sTargetFile, String _sFullDataPath) throws Exception {
        if (this.m_zConfigChanged) {
            throw new IllegalStateException("PublishDistribution changed.");
        }
        IFileDistristributor[] distristributors = this.m_oDistristributors;
        if (distristributors == null || distristributors.length <= 0) {
            return false;
        }
        for (int i = distristributors.length - 1; i >= 0; --i) {
            distristributors[i].renameFile(_sSourceFile, _sTargetFile, _sFullDataPath);
        }
        return true;
    }
}

