/*
 * Decompiled with CFR 0.152.
 */
package com.trs.ajaxservice;

import com.trs.DreamFactory;
import com.trs.ajaxservice.ICategoryServiceProvider;
import com.trs.ajaxservice.WCMAJAXServiceHelper;
import com.trs.cms.ContextHelper;
import com.trs.cms.auth.persistent.User;
import com.trs.components.wcm.util.Category;
import com.trs.components.wcm.util.Categorys;
import com.trs.components.wcm.util.ICategoryMgr;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.util.CMyString;
import com.trs.webframework.context.MethodContext;
import java.util.HashMap;
import java.util.Map;

public class CategoryServiceProvider
implements ICategoryServiceProvider {
    private static final int SELECT_NODE = 0;
    private static final int ONLY_SELECT_LEAF = 1;
    private ICategoryMgr m_oCategoryMgr = (ICategoryMgr)DreamFactory.createObjectById("ICategoryMgr");

    @Override
    public void delete(MethodContext _context) throws WCMException {
        User loginUser = ContextHelper.getLoginUser();
        int nObjectId = _context.getObjectId();
        if (nObjectId > 0) {
            Category category = Category.findById(nObjectId);
            this.m_oCategoryMgr.deleteCategory(loginUser, category);
        } else {
            String sObjectIds = _context.getObjectIds();
            Categorys categorys = Categorys.findByIds(loginUser, sObjectIds);
            int nSize = categorys.size();
            for (int i = 0; i < nSize; ++i) {
                Category category = (Category)categorys.getAt(i);
                if (category == null) continue;
                this.m_oCategoryMgr.deleteCategory(loginUser, category);
            }
        }
    }

    @Override
    public Object findById(MethodContext _context) throws WCMException {
        int nObjectId = _context.getObjectId();
        Category category = null;
        category = nObjectId == 0 ? Category.createNewInstance() : Category.findById(nObjectId);
        return category;
    }

    @Override
    public Object query(MethodContext _context) throws WCMException {
        WCMFilter filter = _context.getExtraWCMFilter();
        return Categorys.openWCMObjs(ContextHelper.getLoginUser(), filter);
    }

    @Override
    public Category saveCategory(MethodContext _context) throws WCMException {
        User loginUser = ContextHelper.getLoginUser();
        int nParentId = _context.getValue("ParentId", 0);
        Category parent = null;
        if (nParentId > 0 && (parent = Category.findById(nParentId)) == null) {
            throw new WCMException("\u6307\u5b9a\u7684\u7236\u8282\u70b9[Id=" + nParentId + "]\u4e0d\u5b58\u5728\uff01");
        }
        int nObjectId = _context.getValue("objectId", 0);
        Category category = null;
        if (nObjectId > 0) {
            category = Category.findById(nObjectId);
            if (category == null) {
                throw new WCMException("\u6307\u5b9a\u7684\u5206\u7c7b\u8282\u70b9[ID=" + nObjectId + "]\u6ca1\u6709\u627e\u5230\uff01");
            }
        } else {
            category = Category.createNewInstance();
            category.setParentId(nParentId);
            if (parent != null) {
                category.setRootId(category.isRoot() ? category.getId() : category.getRootId());
            } else {
                category.setRootId(0);
            }
        }
        WCMAJAXServiceHelper.setWCMObjectProperties(loginUser, _context, category, new String[]{"objectId"});
        category.save(loginUser);
        return category;
    }

    @Override
    public String createCategoryTreeHTML(MethodContext _methodContext) throws Throwable {
        User loginUser = ContextHelper.getLoginUser();
        int nParentId = _methodContext.getValue("ParentId", 0);
        Category parent = Category.findById(nParentId);
        if (parent == null) {
            throw new WCMException("\u6307\u5b9a\u7684\u7236\u8282\u70b9[Id=" + nParentId + "]\u4e0d\u5b58\u5728\uff01");
        }
        Categorys categorys = this.m_oCategoryMgr.queryChildren(loginUser, parent, null);
        int nTreeType = _methodContext.getValue("SelectType", 0);
        StringBuffer sbResult = new StringBuffer(51200);
        this.makeCategoryHTML(sbResult, categorys, nTreeType);
        return sbResult.toString();
    }

    @Override
    public String createCategoryTreeHTMLOfIds(MethodContext _methodContext) throws Throwable {
        User loginUser = ContextHelper.getLoginUser();
        String sObjectIds = _methodContext.getValue("objectIds");
        int nTreeType = _methodContext.getValue("SelectType", 0);
        StringBuffer sbResult = new StringBuffer(4096);
        if (_methodContext.getValue("type", 0) == 0) {
            int[] aObjectIds = CMyString.splitToInt(sObjectIds, ",");
            this.createCategoryTreeHTMLOfIds(sbResult, aObjectIds, nTreeType, 0);
        } else {
            sObjectIds = this.m_oCategoryMgr.getPath(Categorys.findByIds(loginUser, sObjectIds));
            int[] aObjectIds = CMyString.splitToInt(sObjectIds, ",");
            HashMap oUsedMap = new HashMap(aObjectIds.length);
            this.createCategoryTreeHTMLOfIds(sbResult, aObjectIds, oUsedMap, nTreeType, 0);
        }
        return sbResult.toString();
    }

    private void createCategoryTreeHTMLOfIds(StringBuffer _sbResult, int[] aCategoryIds, int nTreeType, int nIndex) throws WCMException {
        if (nIndex == aCategoryIds.length) {
            return;
        }
        Category category = Category.findById(aCategoryIds[nIndex]);
        if (category == null) {
            return;
        }
        User loginUser = ContextHelper.getLoginUser();
        Categorys categorys = this.m_oCategoryMgr.queryChildren(loginUser, category, null);
        if (categorys.size() <= 0) {
            return;
        }
        ++nIndex;
        int nSize = categorys.size();
        for (int i = 0; i < nSize; ++i) {
            Category _category = (Category)categorys.getAt(i);
            if (_category == null) continue;
            if (nIndex + 1 < aCategoryIds.length && _category.getId() == aCategoryIds[nIndex]) {
                this.appendCategoryHTML(_sbResult, _category, nTreeType);
                _sbResult.append("<ul>");
                this.createCategoryTreeHTMLOfIds(_sbResult, aCategoryIds, nTreeType, nIndex);
                _sbResult.append("</ul>");
                continue;
            }
            this.makeCategoryHTML(_sbResult, _category, nTreeType);
        }
    }

    private void createCategoryTreeHTMLOfIds(StringBuffer _sbResult, int[] aCategoryIds, Map oUsedMap, int nTreeType, int index) throws WCMException {
        if (index >= aCategoryIds.length) {
            return;
        }
        if (oUsedMap.get(new Integer(aCategoryIds[index])) == Boolean.TRUE) {
            this.createCategoryTreeHTMLOfIds(_sbResult, aCategoryIds, oUsedMap, nTreeType, index + 1);
            return;
        }
        oUsedMap.put(new Integer(aCategoryIds[index]), Boolean.TRUE);
        Category category = Category.findById(aCategoryIds[index]);
        if (category == null) {
            this.createCategoryTreeHTMLOfIds(_sbResult, aCategoryIds, oUsedMap, nTreeType, index + 1);
            return;
        }
        User loginUser = ContextHelper.getLoginUser();
        this.appendCategoryHTML(_sbResult, category, nTreeType);
        Categorys categorys = this.m_oCategoryMgr.queryChildren(loginUser, category, null);
        if (categorys.size() <= 0) {
            return;
        }
        _sbResult.append("<ul>");
        ++index;
        int nSize = categorys.size();
        for (int i = 0; i < nSize; ++i) {
            Category _category = (Category)categorys.getAt(i);
            if (_category == null) continue;
            if (index < aCategoryIds.length && this.isContain(aCategoryIds, _category.getId())) {
                this.createCategoryTreeHTMLOfIds(_sbResult, aCategoryIds, oUsedMap, nTreeType, index);
                continue;
            }
            this.makeCategoryHTML(_sbResult, _category, nTreeType);
        }
        _sbResult.append("</ul>");
        this.createCategoryTreeHTMLOfIds(_sbResult, aCategoryIds, oUsedMap, nTreeType, index + 1);
    }

    private boolean isContain(int[] array, int key) {
        for (int i = 0; i < array.length; ++i) {
            if (array[i] != key) continue;
            return true;
        }
        return false;
    }

    private void makeCategoryHTML(StringBuffer _sbResult, Categorys categorys, int nTreeType) throws WCMException {
        int nSize = categorys.size();
        for (int i = 0; i < nSize; ++i) {
            this.makeCategoryHTML(_sbResult, (Category)categorys.getAt(i), nTreeType);
        }
    }

    private void makeCategoryHTML(StringBuffer _sbResult, Category category, int nTreeType) throws WCMException {
        this.appendCategoryHTML(_sbResult, category, nTreeType);
        if (!category.isLeaf()) {
            _sbResult.append("<ul></ul>\n");
        }
    }

    private void appendCategoryHTML(StringBuffer _sbResult, Category category, int nTreeType) throws WCMException {
        if (category == null) {
            return;
        }
        boolean bIsLeaf = category.isLeaf();
        _sbResult.append("<div objectId=");
        _sbResult.append("'");
        _sbResult.append(category.getId());
        _sbResult.append("'");
        _sbResult.append(" id=");
        _sbResult.append("'");
        _sbResult.append("node_");
        _sbResult.append(category.getId());
        _sbResult.append("'");
        if (nTreeType == 1 && !bIsLeaf) {
            _sbResult.append(" onlyNode='true'");
        }
        _sbResult.append(" cDesc=");
        _sbResult.append("'");
        _sbResult.append(CMyString.filterForHTMLValue(category.getCDesc()));
        _sbResult.append("'");
        _sbResult.append(" title=");
        _sbResult.append("'");
        _sbResult.append("ID:");
        _sbResult.append(category.getId());
        _sbResult.append("'");
        _sbResult.append(">");
        _sbResult.append("<a href=#>");
        _sbResult.append(CMyString.transDisplay(category.getCName()));
        _sbResult.append("</a></div>");
    }

    @Override
    public String getPath(MethodContext _methodContext) throws WCMException {
        int nObjectId = _methodContext.getValue("objectId", 0);
        if (nObjectId == 0) {
            throw new WCMException("\u6ca1\u6709\u6307\u5b9a\u5206\u7c7bID");
        }
        Category category = Category.findById(nObjectId);
        if (category == null) {
            throw new WCMException(200006, "\u6307\u5b9a\u7684\u5206\u7c7b\u4e0d\u5b58\u5728\uff01[ID=" + nObjectId + "]");
        }
        return this.m_oCategoryMgr.getPath(category);
    }

    @Override
    public Object findByIds(MethodContext context) throws Throwable {
        return null;
    }

    @Override
    public int save(MethodContext _context) throws WCMException {
        return this.saveCategory(_context).getId();
    }
}

