/*
 * Decompiled with CFR 0.152.
 */
package com.trs.dev4.jdk16.wordfilter;

import com.trs.dev4.jdk16.wordfilter.Word;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class MatchResult {
    private String wordSep;
    private List<Word> matchedFilterWords;
    private String markedContent;
    private String matchedContentList;

    public MatchResult() {
    }

    public MatchResult(List<Word> matchedFilterWords, String markedContent, String matchedContentList, String wordSep) {
        this.matchedFilterWords = matchedFilterWords;
        this.markedContent = markedContent;
        this.matchedContentList = matchedContentList;
        this.wordSep = wordSep;
    }

    public Map<Word, Integer> getGroupedMatchedFilterWords() {
        HashMap<Word, Integer> count = new HashMap<Word, Integer>();
        for (Word obj : this.matchedFilterWords) {
            Integer c = (Integer)count.get(obj);
            if (c == null) {
                count.put(obj, new Integer(1));
                continue;
            }
            count.put(obj, new Integer(c + 1));
        }
        return count;
    }

    public int getHighestLevel() {
        int level = 0;
        for (Word element : this.matchedFilterWords) {
            int iLevel = element.getLevel();
            if (iLevel <= level) continue;
            level = iLevel;
        }
        return level;
    }

    public boolean canPass(int level) {
        return this.getHighestLevel() < level;
    }

    public String getMarkedContent() {
        return this.markedContent;
    }

    public void setMarkedContent(String markedContent) {
        this.markedContent = markedContent;
    }

    public List<Word> getMatchedFilterWords() {
        return this.matchedFilterWords;
    }

    public void setMatchedFilterWords(List<Word> matchedWords) {
        this.matchedFilterWords = matchedWords;
    }

    public String getMatchedContentList() {
        return this.matchedContentList;
    }

    public String getMatchedContentList(int maxLength) {
        if (this.matchedContentList == null || this.matchedContentList.length() <= maxLength) {
            return this.matchedContentList;
        }
        Map<Word, Integer> words = this.getGroupedMatchedFilterWords();
        Iterator<Word> i = words.keySet().iterator();
        StringBuffer sb = new StringBuffer(maxLength + 100);
        boolean meet = false;
        while (i.hasNext()) {
            if (meet) {
                sb.append(this.wordSep);
            } else {
                meet = true;
            }
            sb.append(i.next().getWord());
        }
        if (sb.length() > maxLength) {
            sb.setLength(maxLength);
        }
        return sb.toString();
    }

    public void setMatchedContentList(String wordsListString) {
        this.matchedContentList = wordsListString;
    }

    public String getWordSep() {
        return this.wordSep;
    }

    public void setWordSep(String wordSep) {
        this.wordSep = wordSep;
    }
}

