/*
 * Decompiled with CFR 0.152.
 */
package com.trs.dev4.jdk16.thread;

import com.trs.dev4.jdk16.thread.IThreadWorkload;
import com.trs.dev4.jdk16.tunning.PerformanceTimer;
import com.trs.dev4.jdk16.utils.DateUtil;
import org.apache.log4j.Logger;

public class DaemonThreadControllor {
    private static final Logger logger = Logger.getLogger(DaemonThreadControllor.class);
    private static final long DEF_MAX_WAIT_MS = 5000L;
    private Thread backgroudThread;
    private int duration;
    private long delay;
    private boolean running;
    private int executedCount;
    private String threadName;
    private IThreadWorkload workload;

    public void start(String name, int duration, IThreadWorkload workload) {
        this.start(name, duration, 0L, workload);
    }

    public void startDaily(String name, IThreadWorkload workload) {
        this.start(name, 86400, DateUtil.getTodayRemainAsSecond(), workload);
    }

    public void startHourly(String name, IThreadWorkload workload) {
        this.start(name, 3600, DateUtil.getCurrentHourRemainAsSecond(), workload);
    }

    public void start(String name, int duration, long delay, IThreadWorkload workload) {
        this.workload = workload;
        this.duration = duration;
        this.delay = delay;
        this.running = true;
        this.backgroudThread = new Thread(new BackgroudDaemonThread());
        this.backgroudThread.setDaemon(true);
        this.threadName = "TRS." + name.toUpperCase();
        this.backgroudThread.setName(this.threadName);
        this.backgroudThread.start();
        logger.debug((Object)("BackgroudDaemonThread(" + this.backgroudThread.getName() + ") started with IThreadWorkload =" + workload));
    }

    public void stop() {
        this.stop(5000L);
    }

    public void stop(long maxWaitMillis) {
        this.running = false;
        try {
            this.backgroudThread.join(maxWaitMillis);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.backgroudThread.interrupt();
    }

    void execute() {
        try {
            this.workload.onExecute();
        }
        catch (Exception ex) {
            logger.error((Object)ex.getMessage(), (Throwable)ex);
        }
    }

    class BackgroudDaemonThread
    implements Runnable {
        BackgroudDaemonThread() {
        }

        @Override
        public void run() {
            try {
                Thread.sleep(DaemonThreadControllor.this.delay * 1000L);
            }
            catch (InterruptedException interruptedException) {}
            while (DaemonThreadControllor.this.running) {
                DaemonThreadControllor daemonThreadControllor = DaemonThreadControllor.this;
                daemonThreadControllor.executedCount = daemonThreadControllor.executedCount + 1;
                PerformanceTimer pTimer = new PerformanceTimer("workload");
                DaemonThreadControllor.this.execute();
                pTimer.stop();
                logger.debug((Object)("Thread (" + DaemonThreadControllor.this.threadName + ") with IThreadWorkload(" + DaemonThreadControllor.this.workload + ") elapsed (" + pTimer.getDuration() + ") ms for (" + DaemonThreadControllor.this.executedCount + ") execution. "));
                try {
                    Thread.sleep((long)DaemonThreadControllor.this.duration * 1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }
}

