/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.data.xy;

import java.io.Serializable;
import org.jfree.util.ObjectUtils;

public class XYDataItem
implements Cloneable,
Comparable,
Serializable {
    private Number x;
    private Number y;

    public XYDataItem(Number x, Number y) {
        if (x == null) {
            throw new IllegalArgumentException("Null 'x' argument.");
        }
        this.x = x;
        this.y = y;
    }

    public XYDataItem(double x, double y) {
        this(new Double(x), new Double(y));
    }

    public Number getX() {
        return this.x;
    }

    public Number getY() {
        return this.y;
    }

    public void setY(Number y) {
        this.y = y;
    }

    public int compareTo(Object o1) {
        int result;
        if (o1 instanceof XYDataItem) {
            XYDataItem dataItem = (XYDataItem)o1;
            double compare = this.x.doubleValue() - dataItem.getX().doubleValue();
            result = compare > 0.0 ? 1 : (compare < 0.0 ? -1 : 0);
        } else {
            result = 1;
        }
        return result;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o == this) {
            return true;
        }
        if (o instanceof XYDataItem) {
            XYDataItem item = (XYDataItem)o;
            if (!this.x.equals(item.x)) {
                return false;
            }
            return ObjectUtils.equal((Object)this.y, (Object)item.y);
        }
        return false;
    }

    public int hashCode() {
        int result = this.x.hashCode();
        result = 29 * result + (this.y != null ? this.y.hashCode() : 0);
        return result;
    }
}

