/*
 * Decompiled with CFR 0.152.
 */
package com.trs.autodeploy.util;

import com.trs.common.CMyException;
import com.trs.util.CMyFile;
import com.trs.util.CMyString;
import java.io.File;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CMyNameLength4DB2File {
    public static void main(String[] args) throws Exception {
        CMyNameLength4DB2File.nameLength(args[0], args[1]);
    }

    public static void nameLength(String _sDB2FilePath, String _sResultFilePath) throws Exception {
        if (!CMyFile.fileExists(_sDB2FilePath)) {
            throw new CMyException(26, "\u6587\u4ef6\u8def\u5f84 [" + _sDB2FilePath + "]\u4e0d\u5b58\u5728!");
        }
        CMyNameLength4DB2File.writenameOverlength(_sDB2FilePath, _sResultFilePath);
    }

    public static void nameLength(File _oDB2FileFile, String _sResultFilePath) throws Exception {
        if (!_oDB2FileFile.exists()) {
            throw new CMyException(26, "\u6587\u4ef6 [" + _oDB2FileFile + "]\u4e0d\u5b58\u5728!");
        }
        String _sDB2FilePath = _oDB2FileFile.getPath();
        CMyNameLength4DB2File.writenameOverlength(_sDB2FilePath, _sResultFilePath);
    }

    private static void writenameOverlength(String _sDB2FilePath, String _sResultFilePath) throws Exception {
        String sFileContent = CMyFile.readFile(_sDB2FilePath, CMyString.ENCODING_DEFAULT);
        String sFileLog = CMyNameLength4DB2File.detectTriggerNameLength(sFileContent);
        try {
            CMyFile.writeFile(_sResultFilePath, sFileLog, CMyString.ENCODING_DEFAULT);
        }
        catch (Exception e) {
            throw new CMyException(25, "\u5904\u7406\u5c06\u89e6\u53d1\u5668\u540d\u79f0\u6807\u793a\u7b26\u957f\u5ea6\u8d85\u8fc718\u7684\u5185\u5bb9\u5199\u5165\u7ed3\u679c\u6587\u4ef6\u4e2d\u65f6\u51fa\u73b0\u5f02\u5e38", (Throwable)e);
        }
    }

    public static String detectTriggerNameLength(String _sFileContent) throws Exception {
        Pattern p = Pattern.compile("(?im)(\\s*)(trigger)(\\s*)(\\b\\w*\\b)");
        Matcher m = p.matcher(_sFileContent);
        int nIndex = 0;
        String sFileLog = "";
        boolean bFound = false;
        while (m.find()) {
            ++nIndex;
            if (m.group(4).length() <= 18) continue;
            sFileLog = String.valueOf(sFileLog) + "\n" + nIndex + " " + m.group(4) + "\n";
            bFound = true;
        }
        if (bFound) {
            sFileLog = "\n\u4ee5\u4e0b\u662f\u68c0\u6d4b\u51fa\u7684\u89e6\u53d1\u5668\u540d\u79f0\u6807\u793a\u7b26\u957f\u5ea6\u8d85\u8fc718\u7684\u89e6\u53d1\u5668\u540d\u79f0\uff1a\n" + sFileLog + "\n-----------\u89e6\u53d1\u5668\u540d\u79f0\u6807\u793a\u7b26\u957f\u5ea6\u8d85\u8fc718\u7684\u8bb0\u5f55\u7ed3\u675f-----------\n";
        }
        return sFileLog;
    }
}

