/*
 * Decompiled with CFR 0.152.
 */
package com.trs.jni;

import java.io.File;
import java.util.Vector;

public class JNIPath {
    private static String m_sRealLibNamePrefix = "";
    private static String m_sRealLibNameExt = "";
    private static boolean m_bLibNameRight = true;

    private static String[] split(String strSrcValue, String strSeparator) {
        String _strRemain;
        if (strSrcValue == null || strSeparator == null) {
            return null;
        }
        int _iEnd = 0;
        Vector<String> _vTemp = new Vector<String>();
        int _iStart = strSrcValue.indexOf(strSeparator);
        while (_iStart != -1) {
            String _strSplitValue = strSrcValue.substring(_iEnd, _iStart);
            if (_strSplitValue.length() != 0) {
                _vTemp.add(_strSplitValue);
            }
            _iEnd = _iStart + strSeparator.length();
            _iStart = strSrcValue.indexOf(strSeparator, _iEnd);
        }
        if (_iEnd != 0 && (_strRemain = strSrcValue.substring(_iEnd)) != null && _strRemain.length() != 0) {
            _vTemp.add(_strRemain);
        }
        if (_vTemp.size() > 0) {
            Object[] _saWords = new String[_vTemp.size()];
            _vTemp.copyInto(_saWords);
            _vTemp.clear();
            return _saWords;
        }
        String[] _saSingle = new String[]{strSrcValue};
        return _saSingle;
    }

    public static final String getJARPath() {
        String[] ExtPaths = JNIPath.split(System.getProperty("java.ext.dirs"), String.valueOf(File.pathSeparatorChar));
        if (ExtPaths == null || ExtPaths.length == 0) {
            return null;
        }
        return ExtPaths[0];
    }

    public static final String getDLLPath() {
        String sJavaName = System.mapLibraryName("java");
        if (sJavaName == null) {
            return null;
        }
        String[] pLibPaths = JNIPath.split(String.valueOf(System.getProperty("java.home")) + File.separatorChar + "bin" + File.pathSeparatorChar + System.getProperty("java.library.path"), String.valueOf(File.pathSeparatorChar));
        if (pLibPaths == null) {
            return null;
        }
        String sLibPath = JNIPath.findFilePath(sJavaName, pLibPaths);
        if (sLibPath != null) {
            return sLibPath;
        }
        m_bLibNameRight = false;
        String[] pJavaLibFile = new String[]{"libjava.so", "libjava.a", "libjava.sl", "java.dll"};
        String sFileName = pJavaLibFile[0];
        int i = 0;
        while (i < pJavaLibFile.length) {
            sFileName = pJavaLibFile[i];
            if (!sFileName.equalsIgnoreCase(sJavaName) && (sLibPath = JNIPath.findFilePath(sFileName, pLibPaths)) != null) break;
            ++i;
        }
        if (sLibPath == null) {
            System.out.println("--------the libjava.so's path is empty--------");
            System.out.println("--------JNI\u81ea\u52a8\u90e8\u7f72\u65f6\uff0c\u83b7\u53d6\u5230\u7684java\u5e93\u6587\u4ef6\u6240\u5728\u7684\u8def\u5f84\u4e3a\u7a7a--------");
            return null;
        }
        if (sFileName.indexOf("lib") > -1) {
            m_sRealLibNamePrefix = "lib";
        }
        m_sRealLibNameExt = sFileName.substring(sFileName.indexOf("."));
        return sLibPath;
    }

    private static String findFilePath(String sFileName, String[] pLibPaths) {
        if (pLibPaths.length == 0) {
            return null;
        }
        try {
            int i = 0;
            while (i < pLibPaths.length) {
                File DLLFile;
                String sLibPath = pLibPaths[i];
                if (sLibPath != null && sLibPath.length() != 0 && (DLLFile = new File(String.valueOf(sLibPath = new File(sLibPath).getCanonicalPath()) + File.separatorChar + sFileName)).exists()) {
                    return pLibPaths[i];
                }
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public static String getOSName() {
        String OSName = System.getProperty("os.name");
        if (OSName == null) {
            return null;
        }
        if ((OSName = OSName.toLowerCase()).startsWith("windows")) {
            OSName = "windows";
        } else if (OSName.startsWith("linux")) {
            OSName = "linux";
        } else if (OSName.startsWith("solaris") || OSName.startsWith("sun")) {
            OSName = "solaris";
        } else if (OSName.startsWith("hp-ux") || OSName.startsWith("hpux")) {
            OSName = "hpux";
        } else if (OSName.startsWith("aix")) {
            OSName = "aix";
        } else if (OSName.startsWith("mac")) {
            OSName = "mac";
        } else if (OSName.indexOf("bsd") != -1) {
            OSName = "bsd";
        } else if (OSName.indexOf("netware") != -1) {
            OSName = "netware";
        }
        return OSName;
    }

    public static String getOSArch() {
        String OSArch = System.getProperty("os.arch");
        if (OSArch == null) {
            return null;
        }
        if ((OSArch = OSArch.toLowerCase()).equalsIgnoreCase("x86") || OSArch.startsWith("i386") || OSArch.startsWith("i686") || OSArch.equalsIgnoreCase("ia32")) {
            OSArch = "i386";
        } else if (OSArch.equalsIgnoreCase("x86_64") || OSArch.equalsIgnoreCase("x64") || OSArch.equalsIgnoreCase("amd64")) {
            OSArch = "amd64";
        } else if (OSArch.equalsIgnoreCase("sparc")) {
            OSArch = "sparc32";
        } else if (OSArch.equalsIgnoreCase("sparc64")) {
            OSArch = "sparc64";
        } else if (OSArch.equalsIgnoreCase("ppc") || OSArch.equalsIgnoreCase("powerpc") || OSArch.equalsIgnoreCase("power") || OSArch.startsWith("power_")) {
            OSArch = "ppc32";
        } else if (OSArch.equalsIgnoreCase("ppc64")) {
            OSArch = "ppc64";
        } else if (OSArch.equalsIgnoreCase("pa_risc") || OSArch.equalsIgnoreCase("pa_risc2.0")) {
            OSArch = "pa32";
        } else if (OSArch.equalsIgnoreCase("pa_risc2.0w")) {
            OSArch = "pa64";
        } else if (OSArch.equalsIgnoreCase("ia64n") || OSArch.indexOf("itanium") != -1 && OSArch.indexOf("32") != -1) {
            OSArch = "ia32";
        } else if (OSArch.equalsIgnoreCase("ia64") || OSArch.equalsIgnoreCase("ia64w") || OSArch.indexOf("itanium") != -1 && OSArch.indexOf("64") != -1) {
            OSArch = "ia64";
        }
        return OSArch;
    }

    public static String getPlatform() {
        return String.valueOf(JNIPath.getOSName()) + File.separatorChar + JNIPath.getOSArch();
    }

    public static String getDestDLLFile(String jniName) {
        String sDstFilePath = JNIPath.getDLLPath();
        String sDstFileName = System.mapLibraryName(jniName);
        if (!m_bLibNameRight) {
            sDstFileName = String.valueOf(m_sRealLibNamePrefix) + jniName + m_sRealLibNameExt;
        }
        String dstdllfile = String.valueOf(sDstFilePath) + File.separatorChar + sDstFileName;
        return dstdllfile;
    }

    public static String getDestJarFile(String jniName) {
        String dstJarFile = String.valueOf(JNIPath.getJARPath()) + File.separator + jniName + ".jar";
        return dstJarFile;
    }

    public static String getSrcDLLFile(String jniName) {
        String sSrcFileName = System.mapLibraryName(jniName);
        if (!m_bLibNameRight) {
            sSrcFileName = String.valueOf(m_sRealLibNamePrefix) + jniName + m_sRealLibNameExt;
        }
        String srcdllfile = String.valueOf(JNIPath.getOSName()) + "/" + JNIPath.getOSArch() + "/" + sSrcFileName;
        return srcdllfile;
    }

    public static String getSrcJarFile(String jniName) {
        String srcJarFile = String.valueOf(jniName) + ".jar";
        return srcJarFile;
    }

    public static void main(String[] args) {
        String sFileName = "trscrypt";
        System.out.println(JNIPath.getPlatform());
        System.out.println("dll path " + JNIPath.getDestDLLFile(sFileName));
        System.out.println("jar path : " + JNIPath.getDestJarFile(sFileName));
        System.out.println(System.getProperty("java.home"));
        System.out.println(System.getProperty("java.ext.dirs"));
        System.out.println(JNIPath.getSrcDLLFile(sFileName));
    }
}

