/*
 * Decompiled with CFR 0.152.
 */
package de.laures.cewolf;

import de.laures.cewolf.ChartImage;
import de.laures.cewolf.Configuration;
import de.laures.cewolf.Storage;
import de.laures.cewolf.WebConstants;
import de.laures.cewolf.util.RenderingHelper;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Enumeration;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class CewolfRenderer
extends HttpServlet
implements WebConstants {
    public static final String INIT_CONFIG = "CewolfRenderer_Init_Config";
    private static final String STATE = "state";
    private boolean debugged = false;
    private int requestCount = 0;
    private Configuration config = null;

    public void init(ServletConfig servletCfg) throws ServletException {
        super.init(servletCfg);
        servletCfg.getServletContext().setAttribute(INIT_CONFIG, (Object)servletCfg);
        this.config = Configuration.getInstance(servletCfg.getServletContext());
        this.debugged = this.config != null ? this.config.isDebugged() : false;
    }

    public synchronized void printParameters(HttpServletRequest request) {
        Enumeration enumeration = request.getParameterNames();
        while (enumeration.hasMoreElements()) {
            String cur = (String)enumeration.nextElement();
            String obj = request.getParameter(cur);
            this.log("Request Parameter -> " + cur + " Value -> " + obj.toString());
        }
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String imgKey;
        if (this.debugged) {
            this.logRequest(request);
        }
        this.addHeaders(response);
        if (request.getParameter(STATE) != null || !request.getParameterNames().hasMoreElements()) {
            this.requestState(response);
            return;
        }
        ++this.requestCount;
        int width = 400;
        int height = 400;
        if (request.getParameter("width") != null) {
            width = Integer.parseInt(request.getParameter("width"));
        }
        if (request.getParameter("height") != null) {
            height = Integer.parseInt(request.getParameter("height"));
        }
        if ((imgKey = request.getParameter("img")) == null) {
            this.logAndRenderException((Throwable)new ServletException("no 'img' parameter provided for Cewolf servlet."), response, width, height);
            return;
        }
        Storage storage = this.config.getStorage();
        ChartImage chartImage = storage.getChartImage(imgKey, request);
        if (chartImage == null) {
            this.renderImageExpiry(response, width, height);
            return;
        }
        try {
            long start = System.currentTimeMillis();
            int size = chartImage.getSize();
            response.setContentType(chartImage.getMimeType());
            response.setContentLength(size);
            response.setBufferSize(size);
            response.setStatus(200);
            response.getOutputStream().write(chartImage.getBytes());
            long last = System.currentTimeMillis() - start;
            if (this.debugged) {
                this.log("creation time for chart " + imgKey + ": " + last + "ms.");
            }
        }
        catch (Throwable t) {
            this.logAndRenderException(t, response, width, height);
        }
    }

    private void addHeaders(HttpServletResponse response) {
        response.setDateHeader("Expires", System.currentTimeMillis());
    }

    private void requestState(HttpServletResponse response) throws IOException {
        PrintWriter writer = response.getWriter();
        ((Writer)writer).write("<HTML><BODY>");
        ((Writer)writer).write("<b>Cewolf servlet up and running.</b><br>");
        ((Writer)writer).write("Requests served so far: " + this.requestCount);
        ((Writer)writer).write("</HTML></BODY>");
        ((Writer)writer).close();
    }

    private void logAndRenderException(Throwable ex, HttpServletResponse response, int width, int height) throws IOException {
        this.log(ex.getMessage(), ex);
        response.setContentType("image/jpg");
        ServletOutputStream out = response.getOutputStream();
        RenderingHelper.renderException(ex, width, height, (OutputStream)out);
        out.close();
    }

    private void renderImageExpiry(HttpServletResponse response, int width, int height) throws IOException {
        response.setContentType("image/jpg");
        ServletOutputStream out = response.getOutputStream();
        RenderingHelper.renderMessage("This chart has expired. Please reload.", width, height, (OutputStream)out);
        out.close();
    }

    private void logRequest(HttpServletRequest request) throws IOException {
        this.log("Cewolf request:");
        this.log("Actual Request values:");
        this.printParameters(request);
        Enumeration headerNames = request.getHeaderNames();
        while (headerNames.hasMoreElements()) {
            String name = (String)headerNames.nextElement();
            Enumeration values = request.getHeaders(name);
            StringBuffer value = new StringBuffer();
            while (values.hasMoreElements()) {
                value.append((String)values.nextElement() + ",");
            }
            if (value.length() > 0) {
                value.setLength(value.length() - 1);
            }
            this.log(name + ": " + value);
        }
    }
}

