/*
 * Decompiled with CFR 0.152.
 */
package com.trs.dev4.jdk16.utils;

import com.trs.dev4.jdk16.exception.WrappedException;
import com.trs.dev4.jdk16.utils.AssertUtil;
import java.io.File;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.io.SAXReader;

public class XmlReader {
    private Document document;

    public XmlReader(File xmlFile) {
        try {
            this.document = new SAXReader().read(xmlFile);
        }
        catch (DocumentException e) {
            throw new WrappedException(e);
        }
    }

    public XmlReader(URL url) {
        try {
            this.document = new SAXReader().read(url);
        }
        catch (DocumentException e) {
            throw new WrappedException(e);
        }
    }

    public XmlReader(String xmlString) {
        AssertUtil.notNullOrEmpty(xmlString, "xmlString is empty!");
        StringReader reader = new StringReader(xmlString);
        try {
            this.document = new SAXReader().read((Reader)reader);
        }
        catch (DocumentException e) {
            throw new WrappedException(e);
        }
    }

    public String getStringByXPath(String xpathExpression) {
        return this.document.valueOf(xpathExpression);
    }

    public String getEncoding() {
        return this.document.getXMLEncoding();
    }
}

