/*
 * Decompiled with CFR 0.152.
 */
package com.trs.dev4.jdk16.model;

import com.trs.dev4.jdk16.actionlog.IActionlogExtendable;
import com.trs.dev4.jdk16.model.IEntity;
import com.trs.dev4.jdk16.utils.DateUtil;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.MappedSuperclass;
import org.hibernate.annotations.AccessType;

@MappedSuperclass
public abstract class BaseEntity
implements IEntity,
IActionlogExtendable {
    @Id
    @GeneratedValue(generator="idStrategy")
    @Column(name="`ID`")
    protected int id = 0;
    @Column(name="`CREATEDTIME`", updatable=false)
    @AccessType(value="com.trs.idm.util.hb.SafeDirectPropertyAccessor")
    protected long createdTime;
    @Column(name="`CREATEDUSER`")
    protected String createdUser;
    @Column(name="`CREATEDUSERID`")
    @AccessType(value="com.trs.idm.util.hb.SafeDirectPropertyAccessor")
    protected int createdUserId;
    @Column(name="`LASTMODIFIEDTIME`")
    @AccessType(value="com.trs.idm.util.hb.SafeDirectPropertyAccessor")
    protected long lastModifiedTime;
    @Column(name="`LASTMODIFIEDUSER`")
    protected String lastModifiedUser;
    @Column(name="`LASTMODIFIEDUSERID`")
    @AccessType(value="com.trs.idm.util.hb.SafeDirectPropertyAccessor")
    protected int lastModifiedUserId;

    @Override
    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public boolean isNew() {
        return this.id == 0;
    }

    public boolean isOwner(int userId) {
        return this.createdUserId == userId;
    }

    @Override
    public long getCreatedTime() {
        return this.createdTime;
    }

    public Date getCreatedTimeAsDate() {
        return new Date(this.getCreatedTime());
    }

    public void setCreatedTime(long createdTime) {
        this.createdTime = createdTime;
    }

    @Override
    public String getCreatedUser() {
        return this.createdUser;
    }

    public void setCreatedUser(String createdUser) {
        this.createdUser = createdUser;
    }

    @Override
    public long getLastModifiedTime() {
        return this.lastModifiedTime;
    }

    public Date getLastModifiedTimeAsDate() {
        return new Date(this.getLastModifiedTime());
    }

    public void setLastModifiedTime(long lastModifiedTime) {
        this.lastModifiedTime = lastModifiedTime;
    }

    @Override
    public String getLastModifiedUser() {
        return this.lastModifiedUser;
    }

    public void setLastModifiedUser(String lastModifiedUser) {
        this.lastModifiedUser = lastModifiedUser;
    }

    public int getLastModifiedUserId() {
        return this.lastModifiedUserId;
    }

    public void setLastModifiedUserId(int lastModifiedUserId) {
        this.lastModifiedUserId = lastModifiedUserId;
    }

    public int getCreatedUserId() {
        return this.createdUserId;
    }

    public void setCreatedUserId(int createdUserId) {
        this.createdUserId = createdUserId;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("[").append(this.getClass().getSimpleName()).append("@").append(this.hashCode());
        builder.append(", id=").append(this.getId());
        if (this.hasModified()) {
            builder.append(", lastModified on ").append(DateUtil.formatMillis(this.getLastModifiedTime()));
            builder.append(", by (").append(this.lastModifiedUserId).append(")").append(this.lastModifiedUser);
        } else {
            builder.append(", created on ").append(DateUtil.formatMillis(this.getCreatedTime()));
            builder.append(", by (").append(this.createdUserId).append(")").append(this.createdUser);
        }
        builder.append("]");
        return builder.toString();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof BaseEntity)) {
            return false;
        }
        if (!this.getClass().equals(obj.getClass())) {
            return false;
        }
        BaseEntity another = (BaseEntity)obj;
        return this.getId() == another.getId();
    }

    private boolean hasModified() {
        return this.lastModifiedTime > this.createdTime;
    }

    public String getDescription() {
        return String.valueOf(this.getClass().getSimpleName().toLowerCase()) + "_" + this.id;
    }

    @Override
    public String getExtend1() {
        return "";
    }

    @Override
    public String getExtend2() {
        return "";
    }

    @Override
    public String getExtend3() {
        return "";
    }
}

