/*
 * Decompiled with CFR 0.152.
 */
package com.trs.dev4.jdk16.cacheserver.impl;

import com.trs.dev4.jdk16.cacheserver.ICacheServer;
import com.trs.dev4.jdk16.cacheserver.memcached.IMemcachedClient;
import com.trs.dev4.jdk16.utils.StringHelper;
import org.apache.log4j.Logger;

public class MemcachedCacheServer
implements ICacheServer {
    protected static Logger logger = Logger.getLogger(MemcachedCacheServer.class);
    IMemcachedClient memcachedClient;
    String appKey = "trs:";
    int maxExpire = 1200;

    public void setMaxExpire(int maxExpire) {
        this.maxExpire = maxExpire;
    }

    public int getExpire(int expire) {
        return expire <= 0 || expire > this.maxExpire ? this.maxExpire : expire;
    }

    public void setMemcachedClient(IMemcachedClient client) {
        this.memcachedClient = client;
    }

    public IMemcachedClient getMemcachedClient() {
        return this.memcachedClient;
    }

    public void setAppKey(String appKey) {
        this.appKey = String.valueOf(appKey) + ":";
    }

    @Override
    public String getAppKey() {
        return this.appKey;
    }

    public String buildKey(String key) {
        return key;
    }

    @Override
    public void add(String key, int expr, Object value) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("add cache:" + StringHelper.join(new Object[]{key, expr, value})));
        }
        this.memcachedClient.add(this.buildKey(key), this.getExpire(expr), value);
    }

    @Override
    public void delete(String key) {
        this.memcachedClient.delete(this.buildKey(key));
    }

    @Override
    public Object get(String key) {
        return this.memcachedClient.get(this.buildKey(key));
    }

    @Override
    public void replace(String key, int expr, Object value) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("replace cache:" + StringHelper.join(new Object[]{key, expr, value})));
        }
        this.memcachedClient.replace(this.buildKey(key), this.getExpire(expr), value);
    }

    @Override
    public void set(String key, int expr, Object value) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("set cache:" + StringHelper.join(new Object[]{key, expr, value})));
        }
        this.memcachedClient.set(this.buildKey(key), this.getExpire(expr), value);
    }
}

