/*
 * Decompiled with CFR 0.152.
 */
package com.trs.infra.util.upgrade.dbcompare;

import com.trs.infra.util.upgrade.dbcompare.Column;
import com.trs.infra.util.upgrade.dbcompare.MetaDataLoader;
import com.trs.infra.util.upgrade.dbcompare.Table;
import com.trs.infra.util.upgrade.dbcompare.TableDiff;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class SchemaCompare {
    private MetaDataLoader source;
    private MetaDataLoader dest;
    private List diff4Source;
    private List diff4Dest;

    public SchemaCompare(MetaDataLoader source, MetaDataLoader dest) {
        this.source = source;
        this.dest = dest;
    }

    public List getDiff4Source() throws SQLException {
        if (this.diff4Source == null) {
            List r = this.compare(false);
            this.diff4Source = new ArrayList(r.size());
            this.diff4Source.addAll(r);
            r.clear();
        }
        return this.diff4Source;
    }

    public List getDiff4Dest() throws SQLException {
        if (this.diff4Dest == null) {
            List r = this.compare(true);
            this.diff4Dest = new ArrayList(r.size());
            this.diff4Dest.addAll(r);
            r.clear();
        }
        return this.diff4Dest;
    }

    public List compare(boolean reverse) throws SQLException {
        this.source.load();
        this.dest.load();
        Map sourceTables = this.source.getTables();
        Map destTables = this.dest.getTables();
        if (reverse) {
            return this.compare0(sourceTables, destTables);
        }
        return this.compare0(destTables, sourceTables);
    }

    private List compare0(Map sourceTables, Map destTables) {
        Iterator itr = sourceTables.entrySet().iterator();
        ArrayList<TableDiff> result = new ArrayList<TableDiff>(10);
        while (itr.hasNext()) {
            Map.Entry tableEntry = itr.next();
            Table sourceTable = (Table)tableEntry.getValue();
            Table destTable = (Table)destTables.get(tableEntry.getKey());
            if (destTable == null) {
                result.add(new TableDiff(sourceTable));
                continue;
            }
            result.add(this.compareColumns(sourceTable, destTable));
        }
        return result;
    }

    private TableDiff compareColumns(Table source, Table dest) {
        TableDiff diff = new TableDiff(source.getTableName());
        Map sourceColumns = source.getColumns();
        Map destColumns = dest.getColumns();
        Iterator itr = sourceColumns.entrySet().iterator();
        HashMap delCols = new HashMap(destColumns);
        while (itr.hasNext()) {
            Map.Entry columnEntry = itr.next();
            Column sourceColumn = (Column)columnEntry.getValue();
            Column destColumn = (Column)destColumns.get(columnEntry.getKey());
            delCols.remove(columnEntry.getKey());
            if (destColumn == null) {
                diff.addColumn(sourceColumn, 0);
                continue;
            }
            if (sourceColumn.equals(destColumn)) continue;
            diff.addColumn(sourceColumn, 1);
        }
        if (delCols.size() > 0) {
            diff.setDelcols(Arrays.asList(delCols.values().toArray()));
        }
        return diff;
    }
}

