/*
 * Decompiled with CFR 0.152.
 */
package com.trs.infra.util.upgrade.dataprocess;

import com.trs.infra.util.upgrade.DbConfig;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.HashSet;
import java.util.Properties;

public class WcmIdFieldInit {
    private String dbconf;
    private static final String TAB_CONF = "/table_idfield.properties";

    public WcmIdFieldInit(String dbconf) {
        this.dbconf = dbconf;
    }

    public void doAction() throws Exception {
        DbConfig config = new DbConfig();
        config.load(this.dbconf);
        Class.forName(config.getJdbcDriver());
        Class<?> clazz = this.getClass();
        InputStream ins = clazz.getResourceAsStream(TAB_CONF);
        if (ins == null) {
            ins = clazz.getResourceAsStream(TAB_CONF.substring(1));
        }
        Properties props = new Properties();
        if (ins != null) {
            try {
                props.load(ins);
                ins.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        Connection conn = DriverManager.getConnection(config.getOldUrl(), config.getOldUser(), config.getOldPasswd());
        String sql = "select tablename,idfieldname from wcmid";
        Statement stmt = conn.createStatement();
        ResultSet rs = stmt.executeQuery(sql);
        int size = props.isEmpty() ? 100 : props.size();
        HashSet<String> tabs = new HashSet<String>(size, 0.5f);
        while (rs.next()) {
            String id = rs.getString(2);
            if (id != null && id.trim().length() != 0) continue;
            tabs.add(rs.getString(1));
        }
        rs.close();
        DatabaseMetaData meta = conn.getMetaData();
        sql = "update wcmid set idfieldname=? where tablename=?";
        PreparedStatement pstmt = conn.prepareStatement(sql);
        for (String tabname : tabs) {
            String id = props.getProperty(tabname.toUpperCase());
            if (id == null) {
                rs = meta.getPrimaryKeys(null, config.getOldSchema(), tabname);
                if (rs.next()) {
                    id = rs.getString("COLUMN_NAME");
                }
                if (rs.next()) {
                    System.out.println(tabname + " has a pk with mul-columns");
                    rs.close();
                    continue;
                }
                rs.close();
            }
            if (id == null) {
                System.out.println(tabname + " without pk.");
                continue;
            }
            pstmt.setString(1, id);
            pstmt.setString(2, tabname);
            pstmt.executeUpdate();
        }
        pstmt.close();
        conn.close();
    }

    public static void main(String[] args) throws Exception {
        String dbconf = null;
        if (args.length > 0) {
            dbconf = args[0];
        }
        WcmIdFieldInit init = new WcmIdFieldInit(dbconf);
        init.doAction();
    }
}

