/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.wechat.service;

import com.trs.DreamFactory;
import com.trs.cms.ContextHelper;
import com.trs.cms.auth.domain.AuthServer;
import com.trs.cms.auth.persistent.Right;
import com.trs.cms.auth.persistent.RightValue;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.content.CMSObj;
import com.trs.components.common.publish.domain.PublishServer;
import com.trs.components.common.publish.persistent.element.IPublishContent;
import com.trs.components.common.publish.persistent.element.IPublishFolder;
import com.trs.components.common.publish.persistent.element.PublishElementFactory;
import com.trs.components.common.publish.persistent.publisher.FolderPublishConfig;
import com.trs.components.metadata.center.MetaViewData;
import com.trs.components.metadata.center.MetaViewDatas;
import com.trs.components.metadata.definition.MetaView;
import com.trs.components.metadata.service.MetaDataCenterServiceProvider;
import com.trs.components.wcm.content.domain.ChannelImporter;
import com.trs.components.wcm.content.persistent.BaseChannel;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.components.wcm.content.persistent.Document;
import com.trs.components.wcm.content.persistent.WebSite;
import com.trs.components.wcm.util.INameGenerator;
import com.trs.components.wechat.IWeChatMgr;
import com.trs.components.wechat.persistent.WXAccount;
import com.trs.components.wechat.service.WXLoadConfig;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.support.config.ConfigServer;
import com.trs.infra.support.file.FilesMan;
import com.trs.infra.util.CMyException;
import com.trs.infra.util.CMyFile;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.Report;
import com.trs.infra.util.Reports;
import com.trs.infra.util.store.FileService;
import com.trs.webframework.context.MethodContext;
import com.trs.webframework.controler.JSPRequestProcessor;
import com.trs.webframework.provider.IQueryServiceProvider;
import com.trs.webframework.provider.ISelfDefinedServiceProvider;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.json.JSONArray;
import org.apache.log4j.Logger;

public class WXAcountServiceProvider
implements ISelfDefinedServiceProvider,
IQueryServiceProvider {
    private static Logger logger = Logger.getLogger(WXAcountServiceProvider.class);
    private IWeChatMgr m_WeChatMgr = (IWeChatMgr)DreamFactory.createObjectById("IWeChatMgr");

    private User getLoginUser() {
        User loginUser = ContextHelper.getLoginUser();
        return loginUser;
    }

    private Channel createWXAccountChannel(String sWXAccountName, String sWXId, int nSiteId, Channel oHost) throws WCMException {
        User loginUser = this.getLoginUser();
        Channel oChannel = new Channel();
        INameGenerator m_oNameGenerator = (INameGenerator)DreamFactory.createObjectById("INameGenerator");
        int siteId = this.m_WeChatMgr.getWXSite().getId();
        Channel tempChannel = Channel.findByName(siteId, sWXId);
        if (tempChannel != null) {
            throw new WCMException("\u540d\u79f0\u4e3a[" + sWXId + "]\u5df2\u7ecf\u5b58\u5728!");
        }
        oChannel.setName(sWXId);
        oChannel.setDesc(sWXAccountName);
        oChannel.setCanPub(true);
        oChannel.setAttribute("ISWXCHNL", "1");
        if (oHost == null) {
            oChannel.setSite(WebSite.findById(nSiteId));
            oChannel.setParent(0);
        } else if (oHost.getSiteId() == nSiteId && this.isGroupChannel(oHost.getId())) {
            oChannel.setParent(oHost);
            oChannel.setSite(WebSite.findById(nSiteId));
        } else {
            throw new WCMException("\u6240\u9009\u680f\u76ee\u4e0d\u662f\u5fae\u4fe1\u7ad9\u70b9\u4e0b\u7684\u5206\u7ec4\u680f\u76ee");
        }
        oChannel.save(loginUser);
        FolderPublishConfig pubConfig = FolderPublishConfig.createNewInstance();
        WCMFilter filter = new WCMFilter("", "FolderType=? and FolderId in(select ChannelId from WCMChannel where SiteId=?)", "");
        filter.addSearchValues(101);
        filter.addSearchValues(nSiteId);
        String sDataPath = m_oNameGenerator.generate(pubConfig, "DataPath", sWXId, filter);
        pubConfig.setFolder(101, oChannel.getId());
        pubConfig.setDataPath(sDataPath);
        pubConfig.save(loginUser);
        return oChannel;
    }

    private int[] importWXChildChannels(Channel oChannel) throws WCMException {
        URL oUrl = this.getClass().getResource("/wechat/WX-CHANNELS.zip");
        if (oUrl == null) {
            logger.error((Object)"the file[/WeChat/WX-CHANNELS.zip] is not found in class path.");
            return null;
        }
        ChannelImporter oImporter = (ChannelImporter)DreamFactory.createObjectById("ChannelImporter");
        Reports reports = oImporter.importFromFile(oUrl.getPath(), null, oChannel);
        List fails = reports.getFailedReporter();
        if (fails != null && fails.size() > 0) {
            logger.error((Object)("\u521b\u5efa\u516c\u4f17\u53f7\u5b50\u680f\u76ee\u65f6\u51fa\u73b0\u5f02\u5e38\uff0c\u9519\u8bef\u4fe1\u606f\u4e3a\uff1a" + ((Report)fails.get(0)).getRportDetail()));
            return null;
        }
        return reports.getResultIds();
    }

    private void setMetaViewAndTemplate(Channel oRootChannel, Channel oChannel, User currUser) throws WCMException {
        Map oWXChannelMetaViewMapping;
        String sMetaViewName;
        int nWXSiteId = Integer.parseInt(ConfigServer.getServer().getSysConfigValue("WX_SITE_ID", ""));
        JSPRequestProcessor processsor = new JSPRequestProcessor();
        String sChnlDesc = oChannel.getDesc();
        if (oRootChannel == oChannel) {
            sChnlDesc = "$$";
        }
        if (!CMyString.isEmpty(sMetaViewName = (String)(oWXChannelMetaViewMapping = WXLoadConfig.getMetaViewMaping()).get(sChnlDesc)) && this.m_WeChatMgr.getMetaView(sMetaViewName) == null) {
            HashMap<String, String> param = new HashMap<String, String>();
            URL oUrl = this.getClass().getResource("/wechat/view.xml");
            param.put("IMPORTFILE", oUrl.getPath());
            processsor.excute("wcm61_metaview", "importviewsfromxml", param);
        }
        if (!CMyString.isEmpty(sMetaViewName)) {
            this.m_WeChatMgr.setMetaView(oChannel, sMetaViewName);
        }
        Map oWXChannelOutlineTemplateMapping = WXLoadConfig.getOutLineTemplateMaping();
        String sOutlineTemplateName = (String)oWXChannelOutlineTemplateMapping.get(sChnlDesc);
        Map oWXChannelDetailTemplateMapping = WXLoadConfig.getDetailTemplateMaping();
        String sDetailTemplateName = (String)oWXChannelDetailTemplateMapping.get(sChnlDesc);
        if (!CMyString.isEmpty(sOutlineTemplateName) && this.m_WeChatMgr.getTemplate(sOutlineTemplateName) == null || !CMyString.isEmpty(sDetailTemplateName) && this.m_WeChatMgr.getTemplate(sDetailTemplateName) == null) {
            HashMap<String, Object> param = new HashMap<String, Object>();
            param.put("HostType", 103);
            param.put("HostId", nWXSiteId);
            URL oUrl = this.getClass().getResource("/wechat/template.zip");
            FilesMan aFilesMan = FilesMan.getFilesMan();
            String sSaveFile = aFilesMan.getNextFilePathName("U0", "zip");
            FileService file = new FileService(sSaveFile);
            try {
                CMyFile.copyFile(oUrl.getFile(), sSaveFile);
            }
            catch (CMyException e1) {
                throw new WCMException("\u6a21\u7248\u6587\u4ef6\u62f7\u8d1d\u51fa\u9519\uff01", e1);
            }
            param.put("IMPORTFILE", file.getName());
            param.put("SrcFileName", "template.zip");
            processsor.excute("wcm6_template", "importTemplates", param);
        }
        if (!CMyString.isEmpty(sOutlineTemplateName)) {
            this.m_WeChatMgr.setTemplate(oChannel, sOutlineTemplateName);
        }
        if (!CMyString.isEmpty(sDetailTemplateName)) {
            this.m_WeChatMgr.setTemplate(oChannel, sDetailTemplateName);
        }
        this.setWXCustomMenuRight(oChannel, currUser);
        List<Channel> oChannels = oChannel.getAllChildren(this.getLoginUser());
        int length = oChannels.size();
        for (int i = 0; i < length; ++i) {
            Channel oTmpChannel = oChannels.get(i);
            this.setMetaViewAndTemplate(oRootChannel, oTmpChannel, currUser);
        }
    }

    private void setWXCustomMenuRight(Channel oChannel, User currUser) throws WCMException {
        if (!this.m_WeChatMgr.isWXCustomMenu(oChannel)) {
            return;
        }
        Right oRight = Right.findBy(101, oChannel.getId(), 204, currUser.getId());
        RightValue oOldRightValue = null;
        if (oRight == null) {
            oRight = new Right();
            oRight.setOperator(currUser);
            oRight.setObject(oChannel);
        } else {
            oOldRightValue = oRight.getValue();
        }
        RightValue oRightValue = new RightValue("0100001100000000000000001111111111000000000001000000100100000000");
        if (oOldRightValue != null) {
            oRightValue.or(oOldRightValue.getValue());
        }
        oRight.setValue(oRightValue);
        oRight.save(this.getLoginUser());
    }

    private boolean isGroupChannel(int channelId) throws WCMException {
        int id = channelId;
        String isWXChnl = Channel.findById(channelId).getAttributeValue("ISWXCHNL");
        while (isWXChnl == null) {
            isWXChnl = Channel.findById(id).getAttributeValue("ISWXCHNL");
            if ((id = Channel.findById(id).getParentId()) != 0 || isWXChnl != null) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int bindAccount(MethodContext context) throws Throwable {
        User admin = User.findByName("admin");
        User oldUser = this.getLoginUser();
        try {
            Channel oHost;
            ContextHelper.initContext(admin);
            String sWXAccountName = context.getValue("name");
            String sWXId = context.getValue("wxid");
            String sHostId = context.getValue("groupId");
            String wxSiteIds = ConfigServer.getServer().getSysConfigValue("WX_SITE_ID", "");
            int nWXSiteId = 0;
            nWXSiteId = CMyString.isEmpty(wxSiteIds) ? this.m_WeChatMgr.importWXWebSite() : Integer.parseInt(wxSiteIds);
            BaseChannel oHost4Right = oHost = Channel.findById(Integer.parseInt(sHostId));
            if (oHost == null) {
                oHost4Right = WebSite.findById(nWXSiteId);
            }
            if (!this.m_WeChatMgr.isWXManager(oldUser) && !AuthServer.hasRight(oldUser, (CMSObj)oHost4Right, 11)) {
                throw new WCMException("\u60a8[" + oldUser + "\u6ca1\u6709\u6743\u9650\u5728\u5bf9\u8c61[" + oHost4Right + "]\u4e0a\u7ed1\u5b9a\u516c\u4f17\u53f7");
            }
            Channel oChannel = this.createWXAccountChannel(sWXAccountName, sWXId, nWXSiteId, oHost);
            this.importWXChildChannels(oChannel);
            this.setMetaViewAndTemplate(oChannel, oChannel, oldUser);
            context.setValue("OBJECTID", 0);
            context.setValue("CHANNELID", oChannel.getId());
            MetaDataCenterServiceProvider oMetaDataCenterSP = new MetaDataCenterServiceProvider();
            MetaViewData oViewData = oMetaDataCenterSP.saveMetaViewData(context);
            if (oViewData != null) {
                IPublishContent oPublishContent = (IPublishContent)PublishElementFactory.lookupElement(605, oViewData.getId());
                IPublishFolder oPublishFolder = (IPublishFolder)PublishElementFactory.makeElementFrom(oViewData.getChannel());
                oPublishContent.setFolder(oPublishFolder);
                PublishServer.getInstance().publishContent(oPublishContent, 10);
            }
            int n = oChannel.getId();
            return n;
        }
        finally {
            ContextHelper.initContext(oldUser);
        }
    }

    public void removeAccount(MethodContext _methodContext) throws Throwable {
        try {
            Document oDocument = Document.findById(Integer.parseInt(_methodContext.getValue("wxAccountId")));
            int channelId = oDocument.getChannelId();
            HashMap<String, Object> param = new HashMap<String, Object>();
            param.put("ObjectIds", channelId);
            param.put("Drop", "false");
            JSPRequestProcessor processsor = new JSPRequestProcessor();
            processsor.excute("wcm6_channel", "delete", param);
            param.put("Drop", "true");
            processsor.excute("wcm6_channel", "delete", param);
        }
        catch (Throwable e) {
            throw new WCMException("\u5220\u9664\u516c\u4f17\u53f7\u5931\u8d25\uff01", e);
        }
    }

    public void updateAccount(MethodContext _methodContext) throws Throwable {
        try {
            Document oDocument = Document.findById(Integer.parseInt(_methodContext.getValue("wxAccountId")));
            Channel ochannel = oDocument.getChannel();
            User loginUser = ContextHelper.getLoginUser();
            if (!this.m_WeChatMgr.isWXManager(loginUser) && !AuthServer.hasRight(loginUser, (CMSObj)ochannel, 13)) {
                throw new WCMException("\u60a8[" + loginUser + "\u6ca1\u6709\u6743\u9650\u4fee\u6539\u516c\u4f17\u53f7[" + ochannel + "]");
            }
            if (_methodContext.getValue("name") != null) {
                ochannel.setDesc(_methodContext.getValue("name"));
            }
            if (_methodContext.getValue("groupId") != null) {
                ochannel.setParent(Integer.parseInt(_methodContext.getValue("groupId")));
            }
            if (_methodContext.getValue("wxid") != null) {
                ochannel.setName(_methodContext.getValue("wxid"));
            }
            ochannel.save();
            JSPRequestProcessor processsor = new JSPRequestProcessor();
            HashMap<String, String> param = new HashMap<String, String>();
            param.put("ObjectId", _methodContext.getValue("wxAccountId"));
            param.put("name", _methodContext.getValue("name"));
            param.put("wxid", _methodContext.getValue("wxid"));
            param.put("AppId", _methodContext.getValue("AppId"));
            param.put("AppSecret", _methodContext.getValue("AppSecret"));
            param.put("description", _methodContext.getValue("description"));
            param.put("wxType", _methodContext.getValue("wxType"));
            param.put("wxHeadImg", _methodContext.getValue("wxHeadImg"));
            param.put("groupId", _methodContext.getValue("groupId"));
            processsor.excute("wcm61_metaviewdata", "saveMetaViewData", param);
        }
        catch (Throwable e) {
            throw new WCMException("\u66f4\u65b0\u516c\u4f17\u53f7\u5931\u8d25\uff01", e);
        }
    }

    @Override
    public String query(MethodContext _methodContext) throws Throwable {
        int channelId = _methodContext.getValue("channelId", -1);
        JSPRequestProcessor processsor = new JSPRequestProcessor();
        Map oWXChannelMetaViewMapping = WXLoadConfig.getMetaViewMaping();
        String sMetaViewName = (String)oWXChannelMetaViewMapping.get("$$");
        MetaView view = this.m_WeChatMgr.getMetaView(sMetaViewName);
        if (view == null) {
            HashMap<String, String> param = new HashMap<String, String>();
            URL oUrl = this.getClass().getResource("/wechat/view.xml");
            System.out.println("\u6587\u4ef6\u8def\u5f84\uff1a" + oUrl.getPath());
            param.put("IMPORTFILE", oUrl.getPath());
            processsor.excute("wcm61_metaview", "importviewsfromxml", param);
            System.out.println("\u5bfc\u5165\u2026\u2026");
        }
        MetaView metaView = this.m_WeChatMgr.getMetaView(sMetaViewName);
        int viewid = metaView.getId();
        ArrayList<WXAccount> accountList = new ArrayList<WXAccount>();
        if (this.m_WeChatMgr.isWXAccountChannel(Channel.findById(channelId))) {
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("ChannelId", channelId + "");
            MetaViewDatas viewDatas = (MetaViewDatas)processsor.excute("wcm61_metaviewdata", "queryViewDatas", params);
            WXAccount account = new WXAccount();
            MetaViewData viewData = MetaViewData.findById(viewDatas.getAt(0).getId());
            account.setId(viewData.getId());
            account.setChannelId(viewData.getChannelId());
            if (viewData.getPropertyAsString("name") != null) {
                account.setName(viewData.getPropertyAsString("name"));
            }
            if (viewData.getPropertyAsString("wxid") != null) {
                account.setWxid(viewData.getPropertyAsString("wxid"));
            }
            if (viewData.getPropertyAsString("AppId") != null) {
                account.setAppId(viewData.getPropertyAsString("AppId"));
            }
            if (viewData.getPropertyAsString("AppSecret") != null) {
                account.setAppSecret(viewData.getPropertyAsString("AppSecret"));
            }
            if (viewData.getPropertyAsString("description") != null) {
                account.setDescription(viewData.getPropertyAsString("description"));
            }
            if (viewData.getPropertyAsInt("wxType", 0) != 0) {
                account.setWxType(viewData.getPropertyAsInt("wxType", 0));
            }
            if (viewData.getPropertyAsString("wxHeadImg") != null) {
                account.setWxHeadImg(viewData.getPropertyAsString("wxHeadImg"));
            }
            account.setGroupId(Channel.findById(channelId).getParentId());
            account.setLoginUserName(this.getLoginUser().getName());
            accountList.add(account);
            JSONArray arry = JSONArray.fromObject(accountList);
            String callBack = _methodContext.getValue("callback");
            if (!CMyString.isEmpty(callBack)) {
                return callBack + "(" + arry.toString() + ")";
            }
            return arry.toString();
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("ViewId", viewid);
        params.put("_sqlWhere_", "ChnlId in(select channelid from WCMChannel where parentid=" + channelId + " )");
        MetaViewDatas viewDatas = (MetaViewDatas)processsor.excute("wcm61_metaviewdata", "queryViewDatas", params);
        for (int i = 0; i < viewDatas.size(); ++i) {
            WXAccount account = new WXAccount();
            MetaViewData viewData = MetaViewData.findById(viewDatas.getAt(i).getId());
            account.setId(viewData.getId());
            account.setChannelId(viewData.getChannelId());
            if (viewData.getPropertyAsString("name") != null) {
                account.setName(viewData.getPropertyAsString("name"));
            }
            if (viewData.getPropertyAsString("wxid") != null) {
                account.setWxid(viewData.getPropertyAsString("wxid"));
            }
            if (viewData.getPropertyAsString("AppId") != null) {
                account.setAppId(viewData.getPropertyAsString("AppId"));
            }
            if (viewData.getPropertyAsString("AppSecret") != null) {
                account.setAppSecret(viewData.getPropertyAsString("AppSecret"));
            }
            if (viewData.getPropertyAsString("description") != null) {
                account.setDescription(viewData.getPropertyAsString("description"));
            }
            if (viewData.getPropertyAsInt("wxType", 0) != 0) {
                account.setWxType(viewData.getPropertyAsInt("wxType", 0));
            }
            if (viewData.getPropertyAsString("wxHeadImg") != null) {
                account.setWxHeadImg(viewData.getPropertyAsString("wxHeadImg"));
            }
            if (viewData.getPropertyAsInt("groupId", 0) != 0) {
                account.setGroupId(viewData.getPropertyAsInt("groupId", 0));
            }
            accountList.add(account);
        }
        JSONArray arry = JSONArray.fromObject(accountList);
        String callBack = _methodContext.getValue("callback");
        if (!CMyString.isEmpty(callBack)) {
            return callBack + "(" + arry.toString() + ")";
        }
        return arry.toString();
    }

    public String getAppTree(MethodContext context) throws Throwable {
        User currUser = this.getLoginUser();
        int nWXChannelId = context.getValue("WXChannelId", 0);
        List<Channel> childrenList = Channel.findById(nWXChannelId).getChildren(currUser);
        int customMenuId = 0;
        int hudongId = 0;
        int wxNewsId = 0;
        for (int i = 0; i < childrenList.size(); ++i) {
            Channel channel = childrenList.get(i);
            if (this.m_WeChatMgr.isWXCustomMenu(channel)) {
                customMenuId = channel.getId();
                continue;
            }
            if (this.m_WeChatMgr.isWXHudong(channel)) {
                hudongId = channel.getId();
                continue;
            }
            if (!this.m_WeChatMgr.isNewsChannel(channel)) continue;
            wxNewsId = channel.getId();
        }
        JSPRequestProcessor processsor = new JSPRequestProcessor();
        HashMap<String, Integer> param = new HashMap<String, Integer>();
        param.put("menuId", customMenuId);
        String cusMenuTree = (String)processsor.excute("wcm61_wxmenu", "query", param);
        param = new HashMap();
        param.put("nodeId", hudongId);
        String hudong = (String)processsor.excute("wcm61_wxinteraction", "query", param);
        String reg = "\\{\"root\":\\[(.*)\\]\\}";
        Pattern pattern = Pattern.compile(reg);
        Matcher matcher = pattern.matcher(cusMenuTree);
        String wxMenu = "";
        if (matcher.find()) {
            wxMenu = matcher.group(1);
        }
        String wxHudong = "";
        matcher = pattern.matcher(hudong);
        if (matcher.find()) {
            wxHudong = matcher.group(1);
        }
        String[] nodeName = new String[]{"\u5fae\u4e92\u52a8", "\u5fae\u83dc\u5355", "\u5fae\u7fa4\u53d1", "\u5fae\u7c89\u4e1d", "\u5fae\u6d88\u606f", "\u5fae\u5e94\u7528", "\u5fae\u7edf\u8ba1", "\u5de5\u5177\u7bb1"};
        StringBuffer bJson = new StringBuffer();
        bJson.append("{\"root\":[");
        for (int i = 0; i < nodeName.length; ++i) {
            if (nodeName[i].equals("\u5fae\u83dc\u5355")) {
                bJson.append("{\"data-nodeName\": \"").append(nodeName[i]).append("\" ,\"nodeId\": \"").append(customMenuId).append("\",\"childNodes\":[").append(wxMenu).append("]},");
                continue;
            }
            if (nodeName[i].equals("\u5fae\u4e92\u52a8")) {
                bJson.append("{\"data-nodeName\": \"").append(nodeName[i]).append("\" ,\"nodeId\": \"").append(hudongId).append("\",\"childNodes\":[").append(wxHudong).append("]},");
                continue;
            }
            if (nodeName[i].equals("\u5de5\u5177\u7bb1")) {
                bJson.append("{\"data-nodeName\": \"").append(nodeName[i]).append("\" ,\"nodeId\": \"").append("gjx").append("\",\"childNodes\":[").append("{\"data-nodeName\": \"").append("\u56fe\u6587\u6392\u7248").append("\" ,\"nodeId\": \"").append(-1).append("\"}").append("]},");
                continue;
            }
            bJson.append("{\"data-nodeName\": \"").append(nodeName[i]).append("\" ,\"nodeId\": \"-1\"").append("},");
        }
        String wechatURL = ConfigServer.getServer().getSysConfigValue("WECHAT_URL", "");
        bJson.deleteCharAt(bJson.length() - 1);
        bJson.append("],\"wxNewsId\":\"" + wxNewsId + "\",");
        bJson.append("\"wechatURL\":\"" + wechatURL + "\"}");
        return bJson.toString();
    }
}

