/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.wcm.content.domain;

import com.trs.DreamFactory;
import com.trs.components.wcm.content.domain.AppendixMgr;
import com.trs.components.wcm.content.domain.DocBakMgr;
import com.trs.components.wcm.content.persistent.Appendix;
import com.trs.components.wcm.content.persistent.Appendixes;
import com.trs.components.wcm.content.persistent.DocBak;
import com.trs.components.wcm.content.persistent.Document;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.persistent.listener.IObjectLCListenerOnDel;
import com.trs.infra.persistent.listener.IObjectLCListenerOnModify;
import org.apache.log4j.Logger;

public class ApdHostLCListener
implements IObjectLCListenerOnDel,
IObjectLCListenerOnModify {
    private static Logger s_logger = Logger.getLogger(ApdHostLCListener.class);

    @Override
    public void notifyOnDelObj(BaseObj _oObjDeleted, int _nEventType) throws WCMException {
        int nObjType = _oObjDeleted.getWCMType();
        if (nObjType == 611) {
            s_logger.debug((Object)I18NMessage.get(ApdHostLCListener.class, "ApdHostLCListener.label1", "\u9644\u4ef6\u76d1\u63a7\u5230\u6240\u9700\u7684\u6587\u6863\u5907\u4efd\u540c\u6b65\uff1a\u5f7b\u5e95\u5220\u9664\u6587\u6863\u5907\u4efd\u65f6\uff0c\u9700\u8981\u5904\u7406\u9644\u4ef6\u4e2d\u7684\u76f8\u5173\u5173\u7cfb\u3002"));
            DocBak currDocBak = (DocBak)_oObjDeleted;
            Appendixes delApds = this.getAppMgr().getAppendixes((Document)currDocBak, -1);
            for (int i = 0; i < delApds.size(); ++i) {
                this.getAppMgr().deleteAppendixFromDocument(currDocBak, (Appendix)delApds.getAt(i));
            }
            delApds.clear();
            return;
        }
        Appendixes delAppendixes = Appendixes.findAppendixesByObj(_oObjDeleted);
        delAppendixes.removeAll();
    }

    @Override
    public void notifyOnModifyObj(BaseObj _oObjModified, int _nEventType) throws WCMException {
        s_logger.debug((Object)I18NMessage.get(ApdHostLCListener.class, "ApdHostLCListener.label2", "\u6587\u6863\u7684\u4fee\u6539\u89e6\u53d1\u4e86\u9644\u4ef6\u7684\u76f8\u5173\u64cd\u4f5c\u3002"));
        Document currDocument = (Document)_oObjModified;
        if (currDocument.isChangeProperty("DOCFROMVERSION")) {
            Appendixes oldAppendixes = this.getAppMgr().getAppendixes(currDocument, -1);
            for (int i = 0; i < oldAppendixes.size(); ++i) {
                this.getAppMgr().deleteAppendixFromDocument(currDocument, (Appendix)oldAppendixes.getAt(i));
            }
            DocBakMgr currDocBakMgr = (DocBakMgr)DreamFactory.createObjectById("DocBakMgr");
            DocBak currDocBak = currDocBakMgr.getDocBak(currDocument, currDocument.getNewPropertyAsInt("DOCFROMVERSION", 0));
            Appendixes newAppendixes = this.getAppMgr().getAppendixes((Document)currDocBak, -1);
            for (int i = 0; i < newAppendixes.size(); ++i) {
                this.getAppMgr().saveAppendix(currDocument, (Appendix)newAppendixes.getAt(i));
            }
        }
        if (currDocument.isChangeProperty("DOCVERSION")) {
            Appendixes newAppendixes = this.getAppMgr().getAppendixes(currDocument, -1);
            for (int i = 0; i < newAppendixes.size(); ++i) {
                this.getAppMgr().saveAppendix(currDocument, (Appendix)newAppendixes.getAt(i));
            }
        }
    }

    private AppendixMgr getAppMgr() {
        return (AppendixMgr)DreamFactory.createObjectById("AppendixMgr");
    }
}

