/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.common.publish.domain.taskdispatch;

import com.trs.components.common.publish.domain.taskdispatch.IPublishProgressMonitor;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;

public class ProgressMonitorImpl
implements IPublishProgressMonitor {
    private static final int BUFFER_LIMIT = 20;
    private Rec[] m_oInfoArray;
    private int m_iInfoIndex = 0;
    private String m_sThreadName;
    private DateFormat m_oDateFormat = new SimpleDateFormat("yy-MM-dd HH:mm:ss");

    public ProgressMonitorImpl() {
        this.m_oInfoArray = new Rec[20];
    }

    @Override
    public String getId() {
        return this.m_sThreadName;
    }

    @Override
    public Iterator buffer() {
        Iterator itr = new Iterator(){
            private int m_iCount = 0;
            private int m_iIndex = ProgressMonitorImpl.access$100(ProgressMonitorImpl.this);
            private Rec m_objRec = null;

            @Override
            public boolean hasNext() {
                return this.m_objRec != null || this.findNext();
            }

            public Object next() {
                if (this.m_objRec != null || this.findNext()) {
                    String s = this.m_objRec.getMessage();
                    this.m_objRec = null;
                    return s;
                }
                return null;
            }

            private boolean findNext() {
                while (this.m_iCount < 20) {
                    ++this.m_iCount;
                    this.m_objRec = ProgressMonitorImpl.this.m_oInfoArray[this.m_iIndex++];
                    if (this.m_iIndex >= 20) {
                        this.m_iIndex = 0;
                    }
                    if (this.m_objRec == null) continue;
                    return true;
                }
                return false;
            }

            @Override
            public void remove() {
            }
        };
        return itr;
    }

    @Override
    public void info(String msg) {
        Rec rec;
        if (this.m_sThreadName == null) {
            this.m_sThreadName = Thread.currentThread().getName();
        }
        if ((rec = this.m_oInfoArray[this.m_iInfoIndex]) == null) {
            this.m_oInfoArray[this.m_iInfoIndex] = rec = new Rec();
        }
        rec.setInfo(msg);
        if (++this.m_iInfoIndex >= 20) {
            this.m_iInfoIndex = 0;
        }
    }

    public void clear() {
        for (int i = 0; i < 20; ++i) {
            this.m_oInfoArray[i] = null;
        }
    }

    static /* synthetic */ int access$100(ProgressMonitorImpl x0) {
        return x0.m_iInfoIndex;
    }

    private class Rec {
        private long m_tTime;
        private String m_sInfo;
        private String m_sMssg;

        private Rec() {
        }

        private void setInfo(String info) {
            this.m_tTime = System.currentTimeMillis();
            this.m_sInfo = info;
            this.m_sMssg = null;
        }

        private String getMessage() {
            if (this.m_sMssg == null) {
                StringBuffer sb = new StringBuffer();
                sb.append(ProgressMonitorImpl.this.m_oDateFormat.format(new Date(this.m_tTime)));
                sb.append(' ');
                sb.append(this.m_sInfo);
                this.m_sMssg = sb.toString();
            }
            return this.m_sMssg;
        }
    }
}

