/*
 * Decompiled with CFR 0.152.
 */
package com.trs.cms.process.engine.handlers;

import com.trs.cms.auth.persistent.User;
import com.trs.cms.auth.persistent.Users;
import com.trs.cms.content.CMSObj;
import com.trs.cms.process.definition.FlowAction;
import com.trs.cms.process.engine.ExecuteContext;
import com.trs.cms.process.engine.FlowDoc;
import com.trs.cms.process.engine.FlowUserHelper;
import com.trs.cms.process.engine.IActionHandler;
import com.trs.cms.process.engine.handlers.ActionParametersAnalyser;
import com.trs.components.common.message.Message;
import com.trs.components.common.message.MessageServer;
import com.trs.components.infoview.mad.InfoViewDataHelper;
import com.trs.components.wcm.content.persistent.Document;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.util.CMyDateTime;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.DiscoveryFactoryBuddy;
import java.util.HashMap;
import java.util.Map;

public class MsgSendHandler
implements IActionHandler {
    private static final int VAR_RECEIVER_CRUSER = 1996496058;
    private static final int VAR_RECEIVER_DEPTMGR = -2022387309;
    private static final int VAR_RECEIVER_SPDEPTMGR = 268620950;
    private static final int VAR_RECEIVER_PREDEALER = 1434819164;
    private static final int VAR_RECEIVER_CURRDEALER = -641375541;
    private Map m_hVarValues = null;

    @Override
    public boolean execute(ExecuteContext _context, FlowAction _action) throws WCMException {
        FlowDoc flowDoc = _context.getCurrFlowDoc();
        if (flowDoc.getPropertyAsInt("isObjDeleted", 0) == 1) {
            return true;
        }
        ActionParametersAnalyser parameters = new ActionParametersAnalyser(_action.getParams());
        String sMsgTypes = parameters.getParameterValue("MsgTypes");
        if (CMyString.isEmpty(sMsgTypes)) {
            return true;
        }
        String sReceiver = parameters.getParameterValue("Receiver");
        if (sReceiver == null || (sReceiver = sReceiver.trim()).length() == 0) {
            return true;
        }
        Users users = null;
        switch (sReceiver.toUpperCase().hashCode()) {
            case 1996496058: {
                users = new Users(null, 1, 1);
                User crUser = _context.getFlowContent().getCrUser();
                if (crUser == null) break;
                users.addElement(crUser);
                break;
            }
            case -2022387309: {
                users = FlowUserHelper.getDeptMgrsOfUserx(_context.getPostUser());
                break;
            }
            case 268620950: {
                String sGroupName = _context.getFlowContent().getProperty(I18NMessage.get(MsgSendHandler.class, "MsgSendHandler.label1", "\u652f\u6301\u90e8\u95e8"));
                users = FlowUserHelper.getDeptMgrsByGrpName(sGroupName);
                break;
            }
            case 1434819164: {
                users = new Users(null, 1, 1);
                User predealer = _context.getCurrFlowDoc().getPostUser();
                if (predealer == null) break;
                users.addElement(predealer);
                break;
            }
            case -641375541: {
                users = new Users(null, 1, 1);
                User currdealer = _context.getCurrFlowDoc().getToUser();
                if (currdealer == null) break;
                users.addElement(currdealer);
                break;
            }
            default: {
                String[] pUserNames = sReceiver.split(",");
                users = new Users(null, pUserNames.length, 1);
                for (int i = 0; i < pUserNames.length; ++i) {
                    User user = User.findByName(pUserNames[i]);
                    if (user == null) continue;
                    users.addElement(user);
                }
            }
        }
        this.m_hVarValues = new HashMap(5);
        this.m_hVarValues.put("CONTENTTITLE".toUpperCase(), _context.getFlowContent().getDesc());
        this.m_hVarValues.put("CurrDateTime".toUpperCase(), CMyDateTime.now().toString());
        this.m_hVarValues.put("SenderName".toUpperCase(), _context.getPostUser().getName());
        int nSize = users.size();
        for (int i = 0; i < nSize; ++i) {
            User toUser = (User)users.getAt(i);
            if (toUser == null) continue;
            this.m_hVarValues.put("ReceiverName".toUpperCase(), toUser.getName());
            Message newMsg = new Message();
            newMsg.setCrUser(_context.getPostUser());
            newMsg.setTitle(this.doPageVariablesParse(parameters.getParameterValue("MsgTitle"), _context));
            newMsg.setBody(this.doPageVariablesParse(parameters.getParameterValue("MsgTemplate"), _context));
            newMsg.setReceivers(204, String.valueOf(toUser.getId()));
            newMsg.setSendTypes(sMsgTypes);
            newMsg.setProperty("MsgType", 1L);
            newMsg.save(_context.getPostUser());
            MessageServer.send(newMsg);
        }
        return true;
    }

    public static void main(String[] args) {
        String[] pValues = new String[]{"CrUser", "DeptMgr", "SpDeptMgr", "PreDealer", "CurrDealer"};
        for (int i = 0; i < pValues.length; ++i) {
            String value = pValues[i];
            System.out.println(value.toUpperCase());
            System.out.println(value.toUpperCase().hashCode());
        }
    }

    public String doPageVariablesParse(String _sContent, ExecuteContext _context) throws WCMException {
        if (_sContent == null) {
            return null;
        }
        StringBuffer buffResult = null;
        try {
            char[] chrArray = _sContent.toCharArray();
            int nLength = chrArray.length;
            int nPos = 0;
            buffResult = new StringBuffer();
            while (nPos < chrArray.length) {
                char aChar;
                if ((aChar = chrArray[nPos++]) == '$' && nPos < nLength && chrArray[nPos] == '{') {
                    StringBuffer buffVarName = new StringBuffer(16);
                    ++nPos;
                    int iCount = 0;
                    boolean zFound = false;
                    while (iCount++ < 20 && nPos < nLength) {
                        if ((aChar = chrArray[nPos++]) == '}') {
                            zFound = true;
                            break;
                        }
                        buffVarName.append(aChar);
                    }
                    Map hVarValues = this.getVarValues();
                    if (zFound) {
                        String sKey = buffVarName.toString().toUpperCase();
                        String sVal = (String)hVarValues.get(sKey);
                        if (sVal == null) {
                            sVal = this.getSubstanceProperty(sKey, _context);
                            hVarValues.put(sKey, sVal);
                        }
                        if (sVal != null) {
                            buffResult.append(sVal);
                            continue;
                        }
                        buffResult.append("${").append(buffVarName).append('}');
                        continue;
                    }
                    buffResult.append("${").append(buffVarName);
                    continue;
                }
                buffResult.append(aChar);
            }
            return buffResult.toString();
        }
        catch (Exception ex) {
            throw new WCMException(1100, I18NMessage.get(MsgSendHandler.class, "MsgSendHandler.label2", "\u89e3\u6790\u5185\u5bb9\u4e2d\u7684\u53d8\u91cf\u5931\u8d25!"), ex);
        }
    }

    public Map getVarValues() {
        if (this.m_hVarValues == null) {
            this.m_hVarValues = new HashMap(5);
        }
        return this.m_hVarValues;
    }

    private String getSubstanceProperty(String _sKey, ExecuteContext _context) throws WCMException {
        if (CMyString.isEmpty(_sKey)) {
            return null;
        }
        CMSObj content = _context.getFlowContent().getSubstance();
        if (content == null || !(content instanceof Document)) {
            return null;
        }
        Document doc = (Document)content;
        int nPos = -1;
        String sPrefix = null;
        String sFieldName = null;
        nPos = _sKey.indexOf(46);
        if (nPos > 0) {
            sPrefix = _sKey.substring(0, nPos).toUpperCase();
            sFieldName = _sKey.substring(nPos + 1);
        } else {
            sFieldName = _sKey.toUpperCase();
        }
        if (sPrefix == null || sPrefix.equalsIgnoreCase("document")) {
            return doc.getPropertyAsString(sFieldName);
        }
        if (sPrefix.equalsIgnoreCase("infoview")) {
            InfoViewDataHelper helper = (InfoViewDataHelper)DiscoveryFactoryBuddy.getImplementor(InfoViewDataHelper.class);
            if (helper == null) {
                return null;
            }
            return helper.getFieldValue(doc, sFieldName);
        }
        return null;
    }
}

