/*
 * Decompiled with CFR 0.152.
 */
package com.trs.idm.interact.agent;

import com.trs.idm.interact.agent.DummySSLSocketFactory;
import com.trs.idm.util.EnvUtil;
import com.trs.idm.util.PropertyUtil;
import com.trs.idm.util.ResourceUtil;
import java.io.IOException;
import java.net.Socket;
import javax.net.SocketFactory;
import javax.net.ssl.SSLSocketFactory;
import org.apache.log4j.Logger;

public class IDSSocketFactory {
    private static final Logger LOG = Logger.getLogger(IDSSocketFactory.class);
    private static final String JSSE_CERTS = "/idscacerts";

    static {
        LOG.info((Object)("default JSSE props: " + PropertyUtil.toString(System.getProperties(), "javax.net")));
    }

    public static Socket createSSLSocket(String host, int port, boolean dummy) throws IOException {
        String sslCertFile = ResourceUtil.getFullPath(IDSSocketFactory.class, JSSE_CERTS);
        LOG.info((Object)("JSSE_CERTS=/idscacerts, sslCertFile=" + sslCertFile));
        SocketFactory factory = null;
        if (sslCertFile == null || dummy || EnvUtil.isIBMJDK()) {
            factory = DummySSLSocketFactory.getDefault();
        } else {
            System.setProperty("javax.net.ssl.trustStore", sslCertFile);
            LOG.info((Object)("JSSE props: " + PropertyUtil.toString(System.getProperties(), "javax.net")));
            factory = SSLSocketFactory.getDefault();
        }
        LOG.info((Object)("socketFactory=" + factory));
        if (factory == null) {
            throw new IOException("socketFactory=null!");
        }
        try {
            return factory.createSocket(host, port);
        }
        catch (IOException e) {
            LOG.error((Object)("fail! factory=" + factory));
            throw e;
        }
    }

    IDSSocketFactory() {
    }
}

