/*
 * Decompiled with CFR 0.152.
 */
package com.trs.dev4.jdk16.utils;

import com.trs.dev4.jdk16.utils.Base64Util;
import com.trs.dev4.jdk16.utils.SortedProperties;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESKeySpec;
import org.apache.log4j.Logger;

public class EncryptedProperties
extends SortedProperties {
    private static final Logger LOG = Logger.getLogger(EncryptedProperties.class);
    private static final String keyData = "T3+GJY9SI8Q=";
    private Cipher encryptCipher;
    private Cipher decryptCipher;
    private boolean initialized = false;
    private static final String encryptAlgorithm = "DES";
    private static final String encryptPrefix = "{DES}";
    protected Properties encryptedProperties = new Properties();
    protected String[] encryptedNames;
    private static final long serialVersionUID = 1L;
    private Map modifiedProperties = new Hashtable();

    public EncryptedProperties() {
        this.init();
    }

    public EncryptedProperties(String[] encryptedNames) {
        this.encryptedNames = encryptedNames;
        this.init();
    }

    private void init() {
        try {
            DESKeySpec dks = new DESKeySpec(Base64Util.decodeBytes(keyData));
            SecretKeyFactory keyFactory = SecretKeyFactory.getInstance(encryptAlgorithm);
            SecretKey keyDES = keyFactory.generateSecret(dks);
            this.encryptCipher = Cipher.getInstance(encryptAlgorithm);
            this.encryptCipher.init(1, keyDES);
            this.decryptCipher = Cipher.getInstance(encryptAlgorithm);
            this.decryptCipher.init(2, keyDES);
        }
        catch (NoSuchAlgorithmException ex) {
            LOG.error((Object)ex.getMessage(), (Throwable)ex);
        }
        catch (NoSuchPaddingException ex) {
            LOG.error((Object)ex.getMessage(), (Throwable)ex);
        }
        catch (InvalidKeyException ex) {
            LOG.error((Object)ex.getMessage(), (Throwable)ex);
        }
        catch (InvalidKeySpecException ex) {
            LOG.error((Object)ex.getMessage(), (Throwable)ex);
        }
    }

    public EncryptedProperties(Properties defaults) {
        super(defaults);
        this.init();
    }

    @Override
    public String getProperty(String key, String defaultValue) {
        return super.getProperty(key, defaultValue);
    }

    @Override
    public String getProperty(String key) {
        return super.getProperty(key);
    }

    @Override
    public void list(PrintStream out) {
        super.list(out);
    }

    @Override
    public void list(PrintWriter out) {
        super.list(out);
    }

    @Override
    public synchronized void load(InputStream inStream) throws IOException {
        Properties originalProperties = new Properties();
        originalProperties.load(inStream);
        this.modifiedProperties.clear();
        this.encryptedProperties.clear();
        Enumeration<?> e = originalProperties.propertyNames();
        while (e.hasMoreElements()) {
            String propertyName = (String)e.nextElement();
            String propertyValue = originalProperties.getProperty(propertyName);
            this.put(propertyName, propertyValue);
        }
    }

    public boolean isEncrypted(String propertyValue) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("propertyValue:" + propertyValue));
        }
        if (propertyValue == null || propertyValue.length() < 5) {
            return false;
        }
        return encryptPrefix.equals(propertyValue.substring(0, encryptPrefix.length()));
    }

    public boolean isEncryptedProperty(String propertyName) {
        if (this.encryptedNames != null) {
            int i = 0;
            while (i < this.encryptedNames.length) {
                if (this.encryptedNames[i].equals(propertyName)) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public String getEncryptedProperty(String propertyName) {
        return this.encryptedProperties.getProperty(propertyName);
    }

    private String decrypt(String propertyValue) {
        if (!this.isEncrypted(propertyValue)) {
            return propertyValue;
        }
        if (propertyValue != null) {
            propertyValue = propertyValue.substring(5);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("propertyValue:" + propertyValue));
            }
            try {
                byte[] cipherBytes = this.decryptCipher.doFinal(Base64Util.decodeBytes(propertyValue));
                return new String(cipherBytes);
            }
            catch (BadPaddingException ex) {
                LOG.error((Object)ex.getMessage(), (Throwable)ex);
            }
            catch (IllegalBlockSizeException ex) {
                LOG.error((Object)ex.getMessage(), (Throwable)ex);
            }
        }
        return propertyValue;
    }

    public Enumeration propertyNames() {
        return super.propertyNames();
    }

    @Override
    public synchronized Object setProperty(String key, String value) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Property(Key,Value):" + key + "," + value));
        }
        return this.put(key, value);
    }

    private String encrypt(String propertyValue) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("propertyValue:" + propertyValue));
        }
        if (propertyValue != null) {
            try {
                byte[] cipherByte = this.encryptCipher.doFinal(propertyValue.getBytes());
                return encryptPrefix + Base64Util.encode(cipherByte);
            }
            catch (BadPaddingException ex) {
                LOG.error((Object)ex.getMessage(), (Throwable)ex);
            }
            catch (IllegalBlockSizeException ex) {
                LOG.error((Object)ex.getMessage(), (Throwable)ex);
            }
        }
        return propertyValue;
    }

    protected Properties getEncryptedProperties() {
        return this.encryptedProperties;
    }

    @Override
    public synchronized void putAll(Map t) {
        if (t instanceof Properties) {
            Enumeration<?> e = ((Properties)t).propertyNames();
            while (e.hasMoreElements()) {
                String propertyName = (String)e.nextElement();
                String propertyValue = ((Properties)t).getProperty(propertyName);
                this.put(propertyName, propertyValue);
            }
        } else {
            for (String propertyName : t.keySet()) {
                String propertyValue = (String)t.get(propertyName);
                this.put(propertyName, propertyValue);
            }
        }
    }

    @Override
    Object put(String propertyName, String propertyValue) {
        if (this.isEncrypted(propertyValue)) {
            this.encryptedProperties.setProperty(propertyName, propertyValue);
            String decryptedValue = this.decrypt(propertyValue);
            if (!this.isEncryptedProperty(propertyName)) {
                this.modifiedProperties.put(propertyName, decryptedValue);
            } else if (this.initialized && !decryptedValue.equals(this.get(propertyName))) {
                this.modifiedProperties.put(propertyName, propertyValue);
            }
            return super.setProperty(propertyName, decryptedValue);
        }
        String encryptedValue = this.encrypt(propertyValue);
        this.encryptedProperties.setProperty(propertyName, encryptedValue);
        if (this.isEncryptedProperty(propertyName)) {
            this.modifiedProperties.put(propertyName, encryptedValue);
        } else if (this.initialized && !propertyValue.equals(this.get(propertyName))) {
            this.modifiedProperties.put(propertyName, propertyValue);
        }
        return super.setProperty(propertyName, propertyValue);
    }

    public synchronized Map getModifiedProperties() {
        return Collections.unmodifiableMap(this.modifiedProperties);
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public void setInitialized(boolean initialized) {
        this.initialized = initialized;
    }
}

