/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.transaction.interceptor;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.transaction.interceptor.DefaultTransactionAttribute;
import org.springframework.transaction.interceptor.NoRollbackRuleAttribute;
import org.springframework.transaction.interceptor.RollbackRuleAttribute;

public class RuleBasedTransactionAttribute
extends DefaultTransactionAttribute {
    protected static final Log logger = LogFactory.getLog((Class)(class$org$springframework$transaction$interceptor$RuleBasedTransactionAttribute == null ? (class$org$springframework$transaction$interceptor$RuleBasedTransactionAttribute = RuleBasedTransactionAttribute.class$("org.springframework.transaction.interceptor.RuleBasedTransactionAttribute")) : class$org$springframework$transaction$interceptor$RuleBasedTransactionAttribute));
    private List rollbackRules;
    static /* synthetic */ Class class$org$springframework$transaction$interceptor$RuleBasedTransactionAttribute;

    public RuleBasedTransactionAttribute() {
        this.rollbackRules = new ArrayList();
    }

    public RuleBasedTransactionAttribute(int propagationBehavior, List rollbackRules) {
        super(propagationBehavior);
        this.rollbackRules = rollbackRules;
    }

    public void setRollbackRules(List rollbackRules) {
        this.rollbackRules = rollbackRules;
    }

    public List getRollbackRules() {
        return this.rollbackRules;
    }

    public boolean rollbackOn(Throwable t) {
        logger.debug((Object)("Applying rules to determine whether transaction should rollback on " + t));
        RollbackRuleAttribute winner = null;
        int deepest = Integer.MAX_VALUE;
        if (this.rollbackRules != null) {
            Iterator it = this.rollbackRules.iterator();
            while (it.hasNext()) {
                RollbackRuleAttribute rule = (RollbackRuleAttribute)it.next();
                int depth = rule.getDepth(t);
                if (depth < 0 || depth >= deepest) continue;
                deepest = depth;
                winner = rule;
            }
        }
        logger.debug((Object)("Winning rollback rule is: " + winner));
        if (winner == null) {
            logger.debug((Object)"No relevant rollback rule found: applying superclass default");
            return super.rollbackOn(t);
        }
        return !(winner instanceof NoRollbackRuleAttribute);
    }

    public String toString() {
        StringBuffer result = this.getDefinitionDescription();
        TreeSet<String> rules = new TreeSet<String>();
        Iterator it = this.rollbackRules.iterator();
        while (it.hasNext()) {
            RollbackRuleAttribute rule = (RollbackRuleAttribute)it.next();
            String sign = rule instanceof NoRollbackRuleAttribute ? "+" : "-";
            rules.add(sign + rule.getExceptionName());
        }
        it = rules.iterator();
        while (it.hasNext()) {
            result.append(',');
            result.append(it.next());
        }
        return result.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

