/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jdbc.core;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.jdbc.core.DisposableSqlTypeValue;
import org.springframework.jdbc.core.SqlParameter;
import org.springframework.jdbc.core.SqlTypeValue;

public class StatementCreatorUtils {
    private static final Log logger = LogFactory.getLog((Class)(class$org$springframework$jdbc$core$StatementCreatorUtils == null ? (class$org$springframework$jdbc$core$StatementCreatorUtils = StatementCreatorUtils.class$("org.springframework.jdbc.core.StatementCreatorUtils")) : class$org$springframework$jdbc$core$StatementCreatorUtils));
    static /* synthetic */ Class class$org$springframework$jdbc$core$StatementCreatorUtils;

    public static void setParameterValue(PreparedStatement ps, int paramIndex, SqlParameter declaredParam, Object inValue) throws SQLException {
        StatementCreatorUtils.setParameterValue(ps, paramIndex, declaredParam.getSqlType(), declaredParam.getTypeName(), inValue);
    }

    public static void setParameterValue(PreparedStatement ps, int paramIndex, int sqlType, String typeName, Object inValue) throws SQLException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Setting SQL statement parameter value; columnIndex=" + paramIndex + ", parameter value='" + inValue + "', valueClass=" + (inValue != null ? inValue.getClass().getName() : "null") + ", sqlType=" + sqlType));
        }
        if (inValue == null) {
            if (typeName != null) {
                ps.setNull(paramIndex, sqlType, typeName);
            } else if (sqlType == Integer.MIN_VALUE) {
                ps.setObject(paramIndex, inValue);
            } else {
                ps.setNull(paramIndex, sqlType);
            }
        } else if (inValue instanceof SqlTypeValue) {
            ((SqlTypeValue)inValue).setTypeValue(ps, paramIndex, sqlType, typeName);
        } else if (sqlType == 12) {
            ps.setString(paramIndex, inValue.toString());
        } else if (sqlType == 91) {
            if (inValue instanceof Date && !(inValue instanceof java.sql.Date)) {
                inValue = new java.sql.Date(((Date)inValue).getTime());
            }
            ps.setObject(paramIndex, inValue, 91);
        } else if (sqlType == 92) {
            if (inValue instanceof Date && !(inValue instanceof Time)) {
                inValue = new Time(((Date)inValue).getTime());
            }
            ps.setObject(paramIndex, inValue, 92);
        } else if (sqlType == 93) {
            if (inValue instanceof Date && !(inValue instanceof Timestamp)) {
                inValue = new Timestamp(((Date)inValue).getTime());
            }
            ps.setObject(paramIndex, inValue, 93);
        } else if (sqlType == Integer.MIN_VALUE) {
            ps.setObject(paramIndex, inValue);
        } else {
            ps.setObject(paramIndex, inValue, sqlType);
        }
    }

    public static void cleanupParameters(Object[] paramValues) {
        if (paramValues != null) {
            StatementCreatorUtils.cleanupParameters(Arrays.asList(paramValues));
        }
    }

    public static void cleanupParameters(Collection paramValues) {
        if (paramValues != null) {
            Iterator it = paramValues.iterator();
            while (it.hasNext()) {
                Object inValue = it.next();
                if (!(inValue instanceof DisposableSqlTypeValue)) continue;
                ((DisposableSqlTypeValue)inValue).cleanup();
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

