/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.aop.framework;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import org.springframework.aop.framework.Advised;
import org.springframework.aop.framework.AdvisedSupport;
import org.springframework.aop.framework.AdvisorChainFactory;
import org.springframework.aop.framework.AdvisorChainFactoryUtils;
import org.springframework.core.JdkVersion;

public final class HashMapCachingAdvisorChainFactory
implements AdvisorChainFactory {
    private final Map methodCache = this.createMap();

    private Map createMap() {
        if (JdkVersion.getMajorJavaVersion() >= 1) {
            return IdentityHashMapCreator.createIdentityHashMap();
        }
        return new HashMap();
    }

    public List getInterceptorsAndDynamicInterceptionAdvice(Advised config, Object proxy, Method method, Class targetClass) {
        List cached = (List)this.methodCache.get(method);
        if (cached == null) {
            cached = AdvisorChainFactoryUtils.calculateInterceptorsAndDynamicInterceptionAdvice(config, proxy, method, targetClass);
            this.methodCache.put(method, cached);
        }
        return cached;
    }

    public void activated(AdvisedSupport advisedSupport) {
    }

    public void adviceChanged(AdvisedSupport advisedSupport) {
        this.methodCache.clear();
    }

    private static abstract class IdentityHashMapCreator {
        private IdentityHashMapCreator() {
        }

        private static Map createIdentityHashMap() {
            return new IdentityHashMap();
        }
    }
}

