/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.jdbc2.jdbc;

import com.sybase.jdbc2.jdbc.Cursor;
import com.sybase.jdbc2.jdbc.ErrorMessage;
import com.sybase.jdbc2.jdbc.Escape;
import com.sybase.jdbc2.jdbc.EscapeTokenizer;
import com.sybase.jdbc2.jdbc.ParamManager;
import com.sybase.jdbc2.jdbc.Protocol;
import com.sybase.jdbc2.jdbc.ProtocolContext;
import com.sybase.jdbc2.jdbc.ProtocolResultSet;
import com.sybase.jdbc2.jdbc.ResultGetter;
import com.sybase.jdbc2.jdbc.SybBatchUpdateException;
import com.sybase.jdbc2.jdbc.SybConnection;
import com.sybase.jdbc2.jdbc.SybCursorResultSet;
import com.sybase.jdbc2.jdbc.SybDatabaseMetaData;
import com.sybase.jdbc2.jdbc.SybPreparedStatement;
import com.sybase.jdbc2.jdbc.SybResultSet;
import com.sybase.jdbc2.tds.TdsProtocolContext;
import com.sybase.jdbc2.utils.CacheManager;
import com.sybase.jdbcx.SybMessageHandler;
import java.io.IOException;
import java.io.StringWriter;
import java.sql.BatchUpdateException;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.Vector;

public class SybStatement
implements com.sybase.jdbcx.SybStatement {
    private SQLWarning _warning = null;
    protected int _rsType = 1003;
    protected int _rsConcur = -9;
    protected int _rsFetchDir = 1000;
    protected ProtocolContext _context;
    protected Protocol _protocol;
    protected CacheManager _statementManager;
    private int _fieldsize = 0;
    protected boolean _doEscapes = true;
    protected String _rpcName = null;
    protected boolean _hasReturn = false;
    protected boolean _allowsOutputParms = false;
    protected boolean _returnHasBeenRegistered = false;
    protected boolean _closing = false;
    protected SybResultSet _currentRS = null;
    protected ResultGetter _resultGetter;
    protected Cursor _cursor = null;
    protected int _state = 1;
    private int _rowcount = -1;
    private boolean _validRowcount = false;
    private int _currentResult;
    protected static final int NORESULTS = 1;
    protected static final int ONERESULT = 2;
    protected static final int MANYRESULTS = 3;
    protected int _currentQT = -1;
    protected static final String CALL_DELIMS = "(), \t\n\r";
    protected static final int OTHER = 0;
    protected static final int CALL = 1;
    protected static final int SELECT = 2;
    protected static final int DELETE = 4;
    protected static final int UPDATE = 8;
    protected static final int VALID = 4096;
    protected int _type;
    protected int _setStart;
    protected int _setEnd;
    protected String _table;
    protected Vector _batchCmds = null;
    protected int _batchCmdsCount = 0;
    protected boolean _doneinproc = false;
    protected SybDatabaseMetaData _dbmda = null;

    protected SybStatement(ProtocolContext protocolContext) {
        this._context = protocolContext;
        this._context._batch = false;
        this._protocol = protocolContext._protocol;
        this._statementManager = new CacheManager(protocolContext._is);
        this._statementManager.setSetable(false);
        this._resultGetter = new ResultGetter(this);
        this._resultGetter.setManager(this._statementManager);
        this._statementManager.register(this._resultGetter);
    }

    public void addBatch(String string) throws SQLException {
        this.checkBatch();
        if (this._batchCmds == null) {
            this._batchCmds = new Vector();
            this._batchCmdsCount = 0;
        }
        this._batchCmds.add(string);
        ++this._batchCmdsCount;
    }

    /*
     * Unable to fully structure code
     */
    protected int[] batchLoop(ParamManager var1_1) throws SQLException {
        block19: {
            var2_2 = 0;
            this._currentQT = 3;
            var4_3 = new int[this._batchCmdsCount];
            var5_4 = 0;
            while (var5_4 < var4_3.length) {
                var4_3[var5_4] = 0;
                ++var5_4;
            }
            var6_5 = 0;
            var7_6 = 5;
            try {
                while (true) {
                    if (var7_6 != 3) {
                        var7_6 = 5;
                        var2_2 = 0;
                    }
                    block11: while (true) {
                        var3_7 = this.nextResult(var1_1);
                        switch (var3_7) {
                            case 5: {
                                if (this._doneinproc) {
                                    var8_8 = (TdsProtocolContext)this._context;
                                    if (var8_8.isProcDone()) {
                                        var7_6 = 5;
                                        break block11;
                                    }
                                    var2_2 += this._rowcount;
                                    continue block11;
                                }
                                var2_2 += this._rowcount;
                                break block11;
                            }
                            case 0: {
                                var7_6 = 0;
                                break block11;
                            }
                            case 3: {
                                if (!this._doneinproc) continue block11;
                                var7_6 = 3;
                                break block11;
                            }
                            default: {
                                ErrorMessage.raiseError("JZ0P1");
                                continue block11;
                            }
                        }
                        break;
                    }
                    if (var7_6 == 3) continue;
                    if (var6_5 < var4_3.length) {
                        var4_3[var6_5++] = var2_2;
                    }
                    if (var7_6 == 0) break;
                }
                break block19;
            }
            catch (SQLException var8_9) {
                if ("JZ0F2".equals(var8_9.getSQLState())) {
                    this.doCancel(false, true);
                    throw var8_9;
                }
                try {
                    this.doCancel(false, false);
                }
                catch (SQLException var9_10) {
                    if (var9_10.getSQLState().equals("JZ0F2")) {
                        var9_10.setNextException(var8_9);
                    }
                    throw var9_10;
                }
                var9_11 = new int[var6_5];
                var10_12 = 0;
                ** while (var10_12 < var6_5)
            }
lbl-1000:
            // 1 sources

            {
                var9_11[var10_12] = var4_3[var10_12];
                ++var10_12;
                continue;
            }
lbl62:
            // 1 sources

            ErrorMessage.raiseBatchUpdateException(var8_9, var9_11);
        }
        return var4_3;
    }

    protected String batchToString() {
        int n = this._batchCmds.size() * (((String)this._batchCmds.elementAt(this._batchCmds.size() / 2)).length() + 1);
        StringWriter stringWriter = new StringWriter(n);
        stringWriter.write((String)this._batchCmds.elementAt(0));
        int n2 = 1;
        while (n2 < this._batchCmds.size()) {
            stringWriter.write(" ");
            stringWriter.write((String)this._batchCmds.elementAt(n2));
            ++n2;
        }
        String string = stringWriter.toString();
        return string;
    }

    public void cancel() throws SQLException {
        this.checkDead();
        this.doCancel(true, false);
    }

    protected boolean checkBatch() throws SQLException {
        try {
            if (this._dbmda == null) {
                this._dbmda = (SybDatabaseMetaData)this._context._conn.getMetaData();
            }
        }
        catch (SQLException sQLException) {
            return false;
        }
        if (this._dbmda._batchSupport != 1) {
            if (!this._dbmda.supportsBatchUpdates()) {
                this._dbmda._batchSupport = 0;
                ErrorMessage.raiseError("JZ0BS");
            }
            this._dbmda._batchSupport = 1;
        } else if (this._dbmda._execBatchInLoop == -1) {
            this._dbmda._execBatchInLoop = this._dbmda.execBatchUpdatesInLoop() ? 1 : 0;
        }
        return this._dbmda._execBatchInLoop == 1;
    }

    protected void checkCursor(boolean bl) throws SQLException {
        try {
            if (this._cursor == null) {
                this._cursor = this._protocol.getCursor(this._context, bl);
                this._cursor.setFetchSize(this._context._conn._props.getInteger(16));
                if (this instanceof SybPreparedStatement && ((SybPreparedStatement)this)._dynStmtName != null) {
                    this._cursor.setType(8);
                }
                if (this._rsConcur == -9) {
                    this._rsConcur = 1008;
                }
                this._cursor.setType(this._rsConcur);
            }
        }
        catch (SQLException sQLException) {
            this.handleSQLE(sQLException);
        }
    }

    protected void checkDead() throws SQLException {
        if (this._state == 4) {
            ErrorMessage.raiseError("JZ0S2");
        }
        this._context._conn.checkConnection();
    }

    protected void checkStatement(boolean bl) throws SQLException {
        this.checkDead();
        if (this._cursor != null && this._currentRS != null && this._currentRS._state == 2 && this._cursor.isLanguageCursor()) {
            ErrorMessage.raiseError("JZ00E");
        }
        if (this._closing) {
            return;
        }
        if (bl) {
            this.doCancel(false, false);
            this._state = 2;
        } else if (this._state != 2) {
            ErrorMessage.raiseError("JZ0S1");
        }
    }

    public void clearBatch() throws SQLException {
        this.checkBatch();
        this._batchCmds = null;
        this._batchCmdsCount = 0;
    }

    public void clearWarnings() throws SQLException {
        this.checkDead();
        this._warning = null;
    }

    public void close() throws SQLException {
        this.checkDead();
        this._closing = true;
        this.doCancel(true, false);
        try {
            this.deallocateDynamic();
            this._statementManager.clear();
            if (this._cursor != null) {
                this._cursor.close(true);
                this._cursor = null;
            }
        }
        catch (IOException iOException) {
            ErrorMessage.raiseErrorCheckDead(iOException);
        }
        this._statementManager = null;
        this._context.drop();
        this._state = 4;
    }

    protected void deallocateDynamic() throws SQLException {
    }

    private void doCancel(boolean bl, boolean bl2) throws SQLException {
        if (!bl2) {
            this._protocol.cancel(this._context, false);
        }
        if (this._cursor != null) {
            this._cursor.close(bl);
            if (bl) {
                this._cursor = null;
            }
        }
        if (this._currentRS != null) {
            this._currentRS.close(true);
            this._currentRS = null;
        }
        try {
            this._statementManager.clear();
        }
        catch (IOException iOException) {}
        this.resetRowCount();
        this._state = 1;
        this._currentQT = -1;
    }

    protected String doEscapeProcessing(String string) throws SQLException {
        if (string == null || string.length() == 0) {
            ErrorMessage.raiseError("JZ0S4");
        }
        if (this._doEscapes) {
            return this.processEscapes(string);
        }
        return string;
    }

    public boolean execute(String string) throws SQLException {
        string = this.doEscapeProcessing(string);
        return this.execute(string, (ParamManager)null);
    }

    protected boolean execute(String string, ParamManager paramManager) throws SQLException {
        this.checkStatement(true);
        this.sendQuery(string, paramManager);
        return this.executeLoop();
    }

    public int[] executeBatch() throws SQLException {
        return this.executeBatch(null, true);
    }

    protected int[] executeBatch(ParamManager paramManager) throws SQLException {
        return this.executeBatch(paramManager, true);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected int[] executeBatch(ParamManager paramManager, boolean bl) throws SQLException {
        int[] nArray;
        block14: {
            if (this._batchCmds == null) {
                return new int[0];
            }
            int[] nArray2 = new int[this._batchCmds.size()];
            String string = "";
            try {
                block15: {
                    try {
                        if (this.checkBatch()) {
                            if (paramManager != null) {
                                nArray = this.sendBatch((String)this._batchCmds.elementAt(0), paramManager);
                                Object var7_6 = null;
                                if (!bl) return nArray;
                                break block14;
                            }
                            int n = 0;
                            while (n < this._batchCmds.size()) {
                                try {
                                    int[] nArray3 = this.sendBatch((String)this._batchCmds.elementAt(n), paramManager);
                                    nArray2[n] = nArray3[0];
                                }
                                catch (SQLException sQLException) {
                                    this.handleBatchException(sQLException, nArray2, n);
                                }
                                ++n;
                            }
                            break block15;
                        }
                        nArray2 = this.sendBatch(this.batchToString(), paramManager);
                    }
                    catch (SQLException sQLException) {
                        if (!this.checkBatch()) {
                            this.clearBatch();
                        }
                        this._context._batch = false;
                        throw sQLException;
                    }
                }
                Object var7_7 = null;
                if (!bl) return nArray2;
            }
            catch (Throwable throwable) {
                Object var7_8 = null;
                if (!bl) throw throwable;
                if (!this.checkBatch()) {
                    this.clearBatch();
                }
                this._context._batch = false;
                throw throwable;
            }
            if (!this.checkBatch()) {
                this.clearBatch();
            }
            this._context._batch = false;
            return nArray2;
        }
        if (!this.checkBatch()) {
            this.clearBatch();
        }
        this._context._batch = false;
        return nArray;
    }

    protected boolean executeLoop() throws SQLException {
        this._currentQT = 3;
        int n = this.nextResult();
        switch (n) {
            default: {
                ErrorMessage.raiseError("JZ0P1");
            }
            case 0: 
            case 1: 
            case 3: 
            case 5: 
        }
        return this._currentRS != null;
    }

    public ResultSet executeQuery(String string) throws SQLException {
        string = this.doEscapeProcessing(string);
        return this.executeQuery(string, null);
    }

    protected ResultSet executeQuery(String string, ParamManager paramManager) throws SQLException {
        this.checkStatement(true);
        if (this._rsConcur == -9) {
            this._rsConcur = 1007;
        }
        if (this._cursor == null && this._rsConcur == 1008) {
            this.checkCursor(false);
        }
        if (this._cursor != null) {
            this._cursor.setTable(this._table);
            ProtocolResultSet protocolResultSet = null;
            protocolResultSet = this instanceof SybPreparedStatement && ((SybPreparedStatement)this)._dynStmtName != null ? this._cursor.open(((SybPreparedStatement)this)._dynStmtName, paramManager, false) : this._cursor.open(string, paramManager, false);
            if (protocolResultSet == null) {
                ErrorMessage.raiseError("JZ0R2");
            }
            protocolResultSet.setType(this._rsType);
            this._currentRS = new SybCursorResultSet(this, protocolResultSet);
            this._context._conn.addCursorResultSet(this._cursor.getName(), this._currentRS);
            this._state = 2;
        } else {
            this.sendQuery(string, paramManager);
            this.queryLoop();
        }
        return this._currentRS;
    }

    public int executeUpdate(String string) throws SQLException {
        string = this.doEscapeProcessing(string);
        return this.executeUpdate(string, (ParamManager)null);
    }

    protected int executeUpdate(String string, ParamManager paramManager) throws SQLException {
        this.checkStatement(true);
        if (this.sendQuery(string, paramManager)) {
            return 1;
        }
        return this.updateLoop();
    }

    public Connection getConnection() throws SQLException {
        return this._context._conn;
    }

    public int getFetchDirection() throws SQLException {
        return this._rsFetchDir;
    }

    public int getFetchSize() throws SQLException {
        if (this._cursor != null) {
            return this._cursor.getFetchSize();
        }
        return 0;
    }

    public int getMaxFieldSize() throws SQLException {
        this.checkDead();
        return this._context._maxFieldSize;
    }

    public int getMaxRows() throws SQLException {
        this.checkDead();
        return this._protocol.getIntOption(this._context, 4);
    }

    public SybMessageHandler getMessageHandler() {
        return this.getSybMessageHandler();
    }

    public boolean getMoreResults() throws SQLException {
        this.checkDead();
        if (this._state == 1) {
            this._validRowcount = true;
            return false;
        }
        int n = this.nextResult();
        switch (n) {
            case 1: {
                return true;
            }
        }
        return false;
    }

    public int getQueryTimeout() throws SQLException {
        this.checkDead();
        return this._context._timeout / 1000;
    }

    public ResultSet getResultSet() throws SQLException {
        this.checkDead();
        this.setRowCount(-1);
        if (this._context.getState() == 5) {
            ErrorMessage.raiseError("JZ0PA");
        }
        return this._currentRS;
    }

    public int getResultSetConcurrency() throws SQLException {
        if (this._currentRS != null) {
            return this._currentRS.getConcurrency();
        }
        if (this._rsConcur == -9) {
            return 1007;
        }
        return this._rsConcur;
    }

    public int getResultSetType() throws SQLException {
        if (this._currentRS != null) {
            return this._currentRS.getType();
        }
        return this._rsType;
    }

    public SybMessageHandler getSybMessageHandler() {
        return this._context.getMessageHandler();
    }

    public int getUpdateCount() throws SQLException {
        this.checkDead();
        if (this._context.getState() == 5) {
            ErrorMessage.raiseError("JZ0PA");
        }
        if (!this._validRowcount) {
            ErrorMessage.raiseError("JZ0CU");
        }
        int n = this._rowcount;
        this.resetRowCount();
        return n;
    }

    public SQLWarning getWarnings() throws SQLException {
        this.checkDead();
        return this._warning;
    }

    protected void handleBatchException(SQLException sQLException, int[] nArray, int n) throws SQLException {
        if (sQLException instanceof BatchUpdateException) {
            int[] nArray2 = ((BatchUpdateException)sQLException).getUpdateCounts();
            int n2 = 0;
            while (n2 < nArray2.length) {
                nArray[n] = nArray2[n2];
                ++n;
                ++n2;
            }
            int[] nArray3 = new int[n];
            System.arraycopy(nArray, 0, nArray3, 0, n);
            if (sQLException instanceof SybBatchUpdateException) {
                SQLException sQLException2 = ((SybBatchUpdateException)sQLException).getOrigSQE();
                ErrorMessage.raiseBatchUpdateException(sQLException2, nArray3);
            } else {
                ErrorMessage.raiseBatchUpdateException(sQLException, nArray3);
            }
        } else {
            throw sQLException;
        }
    }

    protected String handleCallBody(String string) throws SQLException {
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        String string2 = string;
        boolean bl = false;
        String string3 = null;
        this._allowsOutputParms = true;
        try {
            String string4;
            this._rpcName = stringTokenizer.nextToken(CALL_DELIMS);
            int n = this._rpcName.length();
            if (this._rpcName.toLowerCase().equals("exec")) {
                bl = true;
                this._rpcName = stringTokenizer.nextToken(CALL_DELIMS);
                int n2 = string.indexOf(this._rpcName);
                string3 = string.substring(0, n2);
                string2 = string.substring(n2);
                n += this._rpcName.length();
            }
            StringTokenizer stringTokenizer2 = new StringTokenizer(string.substring(string.indexOf(this._rpcName) + this._rpcName.length()));
            String string5 = stringTokenizer2.nextToken(" ");
            int n3 = string.lastIndexOf(41);
            if (string5.startsWith("(") && n3 > 0) {
                string2 = String.valueOf(this._rpcName) + " " + string.substring(string.indexOf(40) + 1, n3);
            }
            while ((string4 = stringTokenizer.nextToken(CALL_DELIMS)).charAt(0) == '?') {
            }
            this._rpcName = null;
        }
        catch (NoSuchElementException noSuchElementException) {}
        if (bl && !this._protocol.getBoolOption(this._context, 12)) {
            string2 = String.valueOf(string3) + string2;
        }
        return string2;
    }

    protected void handleParam(ParamManager paramManager) throws SQLException {
        this.nextResult();
    }

    protected void handleSQLE(SQLException sQLException) throws SQLException {
        boolean bl = SybConnection.thisChainHasAnException(sQLException);
        SQLWarning sQLWarning = null;
        sQLWarning = !bl ? (SQLWarning)sQLException : SybConnection.getAllTheWarnings(sQLException);
        if (sQLWarning != null) {
            if (this._warning == null) {
                this._warning = sQLWarning;
            } else {
                this._warning.setNextWarning(sQLWarning);
            }
        }
        if (bl) {
            throw sQLException;
        }
    }

    protected int nextResult() throws SQLException {
        return this.nextResult(null);
    }

    protected int nextResult(ParamManager paramManager) throws SQLException {
        this.resetRowCount();
        while (true) {
            try {
                this._currentResult = this._resultGetter.nextResult();
            }
            catch (SQLException sQLException) {
                this.handleSQLE(sQLException);
                continue;
            }
            break;
        }
        switch (this._currentResult) {
            case 1: {
                ProtocolResultSet protocolResultSet = this._protocol.resultSet(this._context);
                if (protocolResultSet != null) {
                    protocolResultSet.setType(this._rsType);
                }
                this._currentRS = new SybResultSet(this, protocolResultSet);
                try {
                    this._currentRS.setManager(this._statementManager);
                    this._statementManager.register(this._currentRS);
                    this._statementManager.open(this._currentRS);
                }
                catch (IOException iOException) {}
                break;
            }
            case 5: {
                this.setRowCount(this._protocol.count(this._context));
                break;
            }
            case 0: {
                this.setRowCount(-1);
                this._state = 1;
                break;
            }
            case 3: {
                if (this._rowcount == -1) {
                    this.setRowCount(0);
                }
                this.handleParam(paramManager);
                break;
            }
        }
        this._validRowcount = true;
        return this._currentResult;
    }

    protected String processEscapes(String string) throws SQLException {
        if (string.length() == 0) {
            return string;
        }
        EscapeTokenizer escapeTokenizer = new EscapeTokenizer(this, string);
        StringBuffer stringBuffer = new StringBuffer();
        Object object = escapeTokenizer.next();
        while (object != null) {
            if (object instanceof String) {
                stringBuffer.append((String)object);
            } else {
                Escape escape = (Escape)object;
                switch (escape.getType()) {
                    case 4: {
                        stringBuffer.append("'1970-1-1 ");
                        String string2 = escape.getBody();
                        stringBuffer.append(string2.substring(1, string2.length()));
                        break;
                    }
                    case 3: {
                        String string3 = escape.getBody();
                        stringBuffer.append(string3.substring(0, string3.length() - 1));
                        stringBuffer.append(" 00:00:00'");
                        break;
                    }
                    case 5: {
                        String string4 = escape.getBody();
                        int n = string4.indexOf(".");
                        if (n > 0 && string4.length() - n > 4) {
                            stringBuffer.append(String.valueOf(string4.substring(0, n + 4)) + "'");
                            break;
                        }
                        stringBuffer.append(string4);
                        break;
                    }
                    case 2: {
                        this._hasReturn = true;
                        stringBuffer = new StringBuffer(this.handleCallBody(escape.getBody()));
                        break;
                    }
                    case 1: {
                        this._hasReturn = false;
                        stringBuffer = new StringBuffer(this.handleCallBody(escape.getBody()));
                        break;
                    }
                    case 7: {
                        stringBuffer.append(" ESCAPE " + escape.getBody());
                        break;
                    }
                    case 6: {
                        String string5 = this._protocol.getStringOption(this._context, 10, escape.functionName());
                        if (string5 == null) {
                            ErrorMessage.raiseError("JZ0SI", escape.functionName());
                        }
                        stringBuffer.append(escape.doMap(string5));
                        break;
                    }
                    case 8: {
                        if (((SybDatabaseMetaData)this._context._conn.getMetaData()).supportsOuterJoinEscapeSyntax()) {
                            stringBuffer.append(escape.getBody());
                            break;
                        }
                        ErrorMessage.raiseError("JZ0SK");
                        break;
                    }
                }
            }
            object = escapeTokenizer.next();
        }
        return stringBuffer.toString();
    }

    protected ResultSet queryLoop() throws SQLException {
        this._currentQT = 2;
        boolean bl = true;
        try {
            block9: while (true) {
                int n = this.nextResult();
                switch (n) {
                    case 3: 
                    case 5: {
                        continue block9;
                    }
                    case 1: {
                        return this._currentRS;
                    }
                    case 0: {
                        bl = false;
                        ErrorMessage.raiseError("JZ0R2");
                        continue block9;
                    }
                }
                ErrorMessage.raiseError("JZ0P1");
            }
        }
        catch (SQLException sQLException) {
            block12: {
                if (!bl || "JZ0T4".equals(sQLException.getSQLState()) || this._context._conn.isDead()) break block12;
                try {
                    if ("JZ0F2".equals(sQLException.getSQLState())) {
                        this.doCancel(false, true);
                        break block12;
                    }
                    this.doCancel(false, false);
                }
                catch (SQLException sQLException2) {
                    if (sQLException2.getSQLState().equals("JZ0F2")) {
                        sQLException2.setNextException(sQLException);
                        throw sQLException2;
                    }
                    sQLException.setNextException(sQLException2);
                }
            }
            throw sQLException;
        }
    }

    private void resetRowCount() {
        this._validRowcount = false;
        this._rowcount = -1;
    }

    protected int[] sendBatch(String string, ParamManager paramManager) throws SQLException {
        String string2 = this.doEscapeProcessing(string);
        this._context._batch = true;
        this.checkStatement(true);
        this.sendQuery(string2, paramManager);
        return this.batchLoop(paramManager);
    }

    protected boolean sendQuery(String string, ParamManager paramManager) throws SQLException {
        if (this._type == 4100 || this._type == 4104) {
            string.trim();
            int n = string.lastIndexOf(32);
            String string2 = string.substring(n + 1);
            SybCursorResultSet sybCursorResultSet = (SybCursorResultSet)this._context._conn.getCursorResultSet(string2);
            if (sybCursorResultSet != null && !sybCursorResultSet._cursor.isLanguageCursor()) {
                sybCursorResultSet._cursor.setTable(this._table);
                if (this._type == 4100) {
                    sybCursorResultSet.deleteRow();
                } else {
                    sybCursorResultSet._cursor.update(sybCursorResultSet._prs, paramManager, string.substring(0, this._setEnd));
                }
                return true;
            }
            if (paramManager != null) {
                paramManager.literalizeAll();
            }
        }
        try {
            this._protocol.language(this._context, string, paramManager);
        }
        catch (SQLException sQLException) {
            this.handleSQLE(sQLException);
        }
        this._state = 2;
        return false;
    }

    public void setCursorName(String string) throws SQLException {
        this.checkDead();
        try {
            this.checkCursor(true);
            this._cursor.setName(string);
        }
        catch (SQLException sQLException) {
            this.handleSQLE(sQLException);
        }
    }

    public void setEscapeProcessing(boolean bl) throws SQLException {
        this.checkDead();
        this._doEscapes = bl;
    }

    public void setFetchDirection(int n) throws SQLException {
        switch (n) {
            case 1000: 
            case 1001: 
            case 1002: {
                this._rsFetchDir = n;
                break;
            }
            default: {
                ErrorMessage.raiseError("JZ0I3", String.valueOf(n), "setFetchDirection(int)");
            }
        }
    }

    public void setFetchSize(int n) throws SQLException {
        if (n == 0) {
            return;
        }
        int n2 = this.getMaxRows();
        if (n < 0 || n2 > 0 && n > n2) {
            ErrorMessage.raiseError("JZ0BI");
        }
        this.checkCursor(false);
        this._cursor.setFetchSize(n);
    }

    public void setMaxFieldSize(int n) throws SQLException {
        if (n < 0) {
            ErrorMessage.raiseError("JZ0SN");
        }
        this.checkStatement(true);
        this._context._maxFieldSize = n;
    }

    public void setMaxRows(int n) throws SQLException {
        if (n < 0) {
            ErrorMessage.raiseError("JZ0SR");
        }
        this.checkStatement(true);
        try {
            this._protocol.setOption(this._context, 4, n);
        }
        catch (SQLException sQLException) {
            this.handleSQLE(sQLException);
        }
    }

    public void setQueryTimeout(int n) throws SQLException {
        if (n < 0) {
            ErrorMessage.raiseError("JZ0SS");
        }
        this.checkDead();
        this._context._timeout = n * 1000;
    }

    protected void setResultSetParams(int n, int n2) throws SQLException {
        boolean bl = false;
        switch (n) {
            case 1005: {
                bl = true;
                n = 1004;
                break;
            }
            default: {
                ErrorMessage.raiseError("JZ0SP", String.valueOf(n));
            }
            case 1003: 
            case 1004: 
        }
        switch (n2) {
            case 1008: {
                if (n != 1004) break;
                n2 = 1007;
                bl = true;
                break;
            }
            default: {
                ErrorMessage.raiseError("JZ0SO", String.valueOf(n2));
            }
            case 1007: 
        }
        this._rsType = n;
        this._rsConcur = n2;
        if (bl) {
            this._context._conn.chainWarnings(ErrorMessage.createWarning("010RC"));
        }
    }

    protected void setRowCount(int n) {
        this._rowcount = n;
    }

    public void setSybMessageHandler(SybMessageHandler sybMessageHandler) {
        this._context.setMessageHandler(sybMessageHandler);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected int updateLoop() throws SQLException {
        int n = 0;
        this._currentQT = 1;
        try {
            block7: while (true) {
                int n2 = this.nextResult();
                switch (n2) {
                    case 5: {
                        n = this._rowcount;
                        continue block7;
                    }
                    case 3: {
                        if (!(this instanceof CallableStatement)) continue block7;
                        return n;
                    }
                    default: {
                        ErrorMessage.raiseError("JZ0P1");
                        continue block7;
                    }
                    case 0: {
                        return n;
                    }
                }
                break;
            }
        }
        catch (SQLException sQLException) {
            this.doCancel(false, false);
            throw sQLException;
        }
    }
}

