/*
 * Decompiled with CFR 0.152.
 */
package org.jCharts.test;

import java.awt.BasicStroke;
import java.awt.Paint;
import org.jCharts.chartData.ChartDataException;
import org.jCharts.chartData.PieChartDataSet;
import org.jCharts.nonAxisChart.PieChart2D;
import org.jCharts.properties.ChartProperties;
import org.jCharts.properties.LegendProperties;
import org.jCharts.properties.PieChart2DProperties;
import org.jCharts.test.ChartTestDriver;
import org.jCharts.test.HTMLGenerator;
import org.jCharts.test.TestDataGenerator;

abstract class PieTestDriver {
    PieTestDriver() {
    }

    static void test() throws Throwable {
        int n = 15;
        HTMLGenerator hTMLGenerator = new HTMLGenerator("./pieChart2dTest.html");
        int n2 = 0;
        while (n2 < n) {
            int n3 = (int)TestDataGenerator.getRandomNumber(1.0, 10.0);
            PieChartDataSet pieChartDataSet = PieTestDriver.getPieChartDataSet(n3, 1, 7);
            int n4 = (int)TestDataGenerator.getRandomNumber(100.0, 600.0);
            int n5 = (int)TestDataGenerator.getRandomNumber(100.0, 600.0);
            LegendProperties legendProperties = new LegendProperties();
            TestDataGenerator.randomizeLegend(legendProperties);
            legendProperties.setBorderStroke(new BasicStroke(2.0f));
            ChartProperties chartProperties = new ChartProperties();
            chartProperties.setBackgroundPaint(TestDataGenerator.getRandomPaint());
            chartProperties.setBorderStroke(new BasicStroke(1.0f));
            PieChart2D pieChart2D = new PieChart2D(pieChartDataSet, null, chartProperties, n4, n5);
            String string = "./pieChart2d" + n2 + ".jpeg";
            ChartTestDriver.exportImage(pieChart2D, string);
            hTMLGenerator.chartTableStart("PieChart2D", string);
            hTMLGenerator.propertiesTableRowStart();
            pieChartDataSet.toHTML(hTMLGenerator);
            hTMLGenerator.propertiesTableRowStart();
            pieChart2D.toHTML(hTMLGenerator, string);
            hTMLGenerator.addLineBreak();
            ++n2;
        }
        hTMLGenerator.saveFile();
    }

    private static PieChartDataSet getPieChartDataSet(int n, int n2, int n3) throws ChartDataException {
        PieChart2DProperties pieChart2DProperties = new PieChart2DProperties();
        pieChart2DProperties.setBorderPaint(TestDataGenerator.getRandomPaint());
        String[] stringArray = TestDataGenerator.getRandomStrings(n, (int)TestDataGenerator.getRandomNumber(3.0, 20.0), false);
        Paint[] paintArray = TestDataGenerator.getRandomPaints(n);
        return new PieChartDataSet("This is a test title", TestDataGenerator.getRandomNumbers(n, n2, n3), stringArray, paintArray, pieChart2DProperties);
    }
}

