/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.css.engine.value;

import org.apache.batik.css.engine.value.AbstractValue;
import org.apache.batik.css.engine.value.Value;
import org.w3c.dom.DOMException;

public class ListValue
extends AbstractValue {
    protected int length;
    protected Value[] items = new Value[5];
    protected char separator = (char)44;

    public ListValue() {
    }

    public ListValue(char c) {
        this.separator = c;
    }

    public char getSeparatorChar() {
        return this.separator;
    }

    public short getCssValueType() {
        return 2;
    }

    public String getCssText() {
        StringBuffer stringBuffer = new StringBuffer(this.length * 8);
        if (this.length > 0) {
            stringBuffer.append(this.items[0].getCssText());
        }
        for (int i = 1; i < this.length; ++i) {
            stringBuffer.append(this.separator);
            stringBuffer.append(this.items[i].getCssText());
        }
        return stringBuffer.toString();
    }

    public int getLength() throws DOMException {
        return this.length;
    }

    public Value item(int n) throws DOMException {
        return this.items[n];
    }

    public String toString() {
        return this.getCssText();
    }

    public void append(Value value) {
        if (this.length == this.items.length) {
            Value[] valueArray = new Value[this.length * 2];
            System.arraycopy(this.items, 0, valueArray, 0, this.length);
            this.items = valueArray;
        }
        this.items[this.length++] = value;
    }
}

