/*
 * Decompiled with CFR 0.152.
 */
package com.trs.ckm.soap;

import java.lang.reflect.Method;
import java.util.Vector;

class ObjectPool
implements Runnable {
    private Vector availableObjects;
    private Vector busyObjects;
    private String className;
    private String isClosedMethod;
    private String closeMethod;
    private int maxSize;
    private boolean objectPending;

    public ObjectPool() {
        this.objectPending = false;
    }

    public ObjectPool(String className, int initSize, int maxSize) throws Exception {
        this(className, initSize, maxSize, null, null);
    }

    public ObjectPool(String className, int initSize, int maxSize, String isClosedMethod, String closeMethod) throws Exception {
        if (initSize > maxSize) {
            initSize = maxSize;
        }
        this.maxSize = maxSize;
        this.className = className;
        this.isClosedMethod = isClosedMethod;
        this.closeMethod = closeMethod;
        this.availableObjects = new Vector(initSize);
        this.busyObjects = new Vector();
        this.objectPending = false;
        int i = 0;
        while (i < initSize) {
            this.availableObjects.addElement(this.MakeNewObject());
            ++i;
        }
        this.objectPending = false;
    }

    private Object MakeNewObject() throws Exception {
        this.objectPending = true;
        try {
            Class<?> c = Class.forName(this.className);
            Object obj = c.newInstance();
            return obj;
        }
        catch (ClassNotFoundException ex) {
            throw new ClassNotFoundException("Can't find class:" + this.className);
        }
    }

    public synchronized void CloseAllObjects() {
        this.CloseObjects(this.availableObjects);
        this.availableObjects.clear();
        this.CloseObjects(this.busyObjects);
        this.busyObjects.clear();
    }

    private void CloseObjects(Vector objects) {
        try {
            int i = 0;
            while (i < objects.size()) {
                Object obj = objects.elementAt(i);
                if (!this.isObjectClosed(obj)) {
                    this.CloseObject(obj);
                }
                ++i;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public synchronized void FreeObject(Object obj) {
        this.busyObjects.removeElement(obj);
        this.availableObjects.addElement(obj);
        this.notifyAll();
    }

    public synchronized Object GetObject() throws Exception {
        if (!this.availableObjects.isEmpty()) {
            Object existingObject = this.availableObjects.lastElement();
            int lastIndex = this.availableObjects.size() - 1;
            this.availableObjects.removeElementAt(lastIndex);
            if (this.isObjectClosed(existingObject)) {
                this.notifyAll();
                return this.GetObject();
            }
            this.busyObjects.addElement(existingObject);
            return existingObject;
        }
        if (this.GetObjectsCount() < this.maxSize && !this.objectPending) {
            this.MakeBackgroundObject();
        }
        try {
            this.wait();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return this.GetObject();
    }

    private boolean isObjectClosed(Object object) {
        if (this.isClosedMethod == null || this.isClosedMethod.length() <= 0) {
            return false;
        }
        try {
            Class<?> c = Class.forName(this.className);
            Method[] m = c.getMethods();
            int i = 0;
            while (i < m.length) {
                if (this.isClosedMethod.equals(m[i].getName())) {
                    m[i].invoke(object, null);
                    break;
                }
                ++i;
            }
        }
        catch (Exception ex) {
            return false;
        }
        return true;
    }

    private void CloseObject(Object object) {
        if (this.closeMethod == null || this.closeMethod.length() <= 0) {
            return;
        }
        try {
            Class<?> c = Class.forName(this.className);
            Method[] m = c.getMethods();
            int i = 0;
            while (i < m.length) {
                if (this.closeMethod.equals(m[i].getName())) {
                    m[i].invoke(object, null);
                    break;
                }
                ++i;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void MakeBackgroundObject() {
        this.objectPending = true;
        try {
            Thread objectThread = new Thread(this);
            objectThread.start();
        }
        catch (OutOfMemoryError outOfMemoryError) {
            // empty catch block
        }
    }

    public synchronized int GetObjectsCount() {
        return this.availableObjects.size() + this.busyObjects.size();
    }

    public synchronized int GetBusyObjectsCount() {
        return this.busyObjects.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            Object obj = this.MakeNewObject();
            ObjectPool objectPool = this;
            synchronized (objectPool) {
                this.availableObjects.addElement(obj);
                this.objectPending = false;
                this.notifyAll();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

