/*
 * Decompiled with CFR 0.152.
 */
package org.xmlmiddleware.schemas.dtds;

import java.io.IOException;
import java.io.Writer;
import java.util.Enumeration;
import java.util.Vector;
import org.xmlmiddleware.schemas.dtds.Attribute;
import org.xmlmiddleware.schemas.dtds.DTD;
import org.xmlmiddleware.schemas.dtds.DTDConst;
import org.xmlmiddleware.schemas.dtds.ElementType;
import org.xmlmiddleware.schemas.dtds.Entity;
import org.xmlmiddleware.schemas.dtds.Group;
import org.xmlmiddleware.schemas.dtds.Notation;
import org.xmlmiddleware.schemas.dtds.ParsedGeneralEntity;
import org.xmlmiddleware.schemas.dtds.Particle;
import org.xmlmiddleware.schemas.dtds.Reference;
import org.xmlmiddleware.schemas.dtds.UnparsedEntity;

public class DTDSerializer {
    private DTD dtd;
    private Writer writer;
    private boolean pretty = false;
    private int indent;
    private static String CHOICESEPARATOR = " | ";
    private static String COMMENTEND = " -->";
    private static String COMMENTSTART = "<!-- ";
    private static String DECLSTART = "<!";
    private static String SEQSEPARATOR = ", ";
    private static String QUOTENTITYREF = "&quot;";
    private static String RETURN = System.getProperty("line.separator");
    private static final int DECLEND = 62;
    private static final int GROUPEND = 41;
    private static final int GROUPSTART = 40;
    private static final int ONEORMORE = 43;
    private static final int OPTIONAL = 63;
    private static final int POUND = 35;
    private static final int SPACE = 32;
    private static final int ZEROORMORE = 42;
    private static final int DOUBLEQUOTE = 34;
    private static final int SINGLEQUOTE = 39;

    public void serialize(DTD dTD, Writer writer, boolean bl) throws IOException {
        this.dtd = dTD;
        this.writer = writer;
        this.pretty = bl;
        this.writeEntities();
        this.writeElementTypes();
        this.writeNotations();
    }

    private void writeElementTypes() throws IOException {
        Enumeration enumeration = this.dtd.elementTypes.elements();
        while (enumeration.hasMoreElements()) {
            this.writeElementType((ElementType)enumeration.nextElement());
        }
    }

    private void writeElementType(ElementType elementType) throws IOException {
        if (this.pretty) {
            this.writer.write(RETURN);
            this.writer.write(RETURN);
        }
        this.writer.write(DECLSTART);
        this.writer.write(DTDConst.KEYWD_ELEMENT);
        this.writer.write(32);
        this.writer.write(elementType.name.getQualifiedName());
        this.writer.write(32);
        switch (elementType.contentType) {
            case 1: {
                this.writer.write(DTDConst.KEYWD_EMPTY);
                break;
            }
            case 2: {
                this.writer.write(DTDConst.KEYWD_ANY);
                break;
            }
            case 3: {
                this.writer.write(40);
                this.writer.write(35);
                this.writer.write(DTDConst.KEYWD_PCDATA);
                this.writer.write(41);
                break;
            }
            case 4: {
                this.writer.write(40);
                this.writer.write(35);
                this.writer.write(DTDConst.KEYWD_PCDATA);
                Enumeration enumeration = elementType.children.elements();
                while (enumeration.hasMoreElements()) {
                    this.writer.write(CHOICESEPARATOR);
                    ElementType elementType2 = (ElementType)enumeration.nextElement();
                    this.writer.write(elementType2.name.getQualifiedName());
                }
                this.writer.write(41);
                this.writer.write(42);
                break;
            }
            case 5: {
                if (elementType.content.type == 1) {
                    this.writer.write(40);
                    this.writeParticle(elementType.content);
                    this.writer.write(41);
                    break;
                }
                this.writeParticle(elementType.content);
                break;
            }
        }
        this.writer.write(62);
        this.writeAttributes(elementType);
    }

    private void writeParticle(Particle particle) throws IOException {
        if (particle.type == 1) {
            this.writeRef((Reference)particle);
            return;
        }
        this.writeGroup((Group)particle);
    }

    private void writeRef(Reference reference) throws IOException {
        this.writer.write(reference.elementType.name.getQualifiedName());
        this.writeFrequency(reference);
    }

    private void writeGroup(Group group) throws IOException {
        String string = group.type == 2 ? CHOICESEPARATOR : SEQSEPARATOR;
        this.writer.write(40);
        this.writeParticle((Particle)group.members.elementAt(0));
        int n = 1;
        while (n < group.members.size()) {
            this.writer.write(string);
            this.writeParticle((Particle)group.members.elementAt(n));
            ++n;
        }
        this.writer.write(41);
        this.writeFrequency(group);
    }

    private void writeFrequency(Particle particle) throws IOException {
        if (particle.isRequired) {
            if (particle.isRepeatable) {
                this.writer.write(43);
                return;
            }
        } else {
            if (particle.isRepeatable) {
                this.writer.write(42);
                return;
            }
            this.writer.write(63);
        }
    }

    private void writeAttributes(ElementType elementType) throws IOException {
        if (elementType.attributes == null) {
            return;
        }
        if (elementType.attributes.size() == 0) {
            return;
        }
        if (this.pretty) {
            this.writer.write(RETURN);
        }
        this.writer.write(DECLSTART);
        this.writer.write(DTDConst.KEYWD_ATTLIST);
        this.writer.write(32);
        this.writer.write(elementType.name.getQualifiedName());
        this.writer.write(32);
        Enumeration enumeration = elementType.attributes.elements();
        this.indent += 10;
        while (enumeration.hasMoreElements()) {
            this.writeAttribute((Attribute)enumeration.nextElement());
        }
        this.indent -= 10;
        this.writer.write(62);
    }

    private void writeAttribute(Attribute attribute) throws IOException {
        if (this.pretty) {
            this.writer.write(RETURN);
            this.indent();
        }
        this.writer.write(attribute.name.getQualifiedName());
        this.writer.write(32);
        this.writeAttributeType(attribute);
        this.writeAttributeDefault(attribute);
    }

    private void writeAttributeType(Attribute attribute) throws IOException {
        switch (attribute.type) {
            case 1: {
                this.writer.write(DTDConst.KEYWD_CDATA);
                break;
            }
            case 2: {
                this.writer.write(DTDConst.KEYWD_ID);
                break;
            }
            case 3: {
                this.writer.write(DTDConst.KEYWD_IDREF);
                break;
            }
            case 4: {
                this.writer.write(DTDConst.KEYWD_IDREFS);
                break;
            }
            case 5: {
                this.writer.write(DTDConst.KEYWD_ENTITY);
                break;
            }
            case 6: {
                this.writer.write(DTDConst.KEYWD_ENTITIES);
                break;
            }
            case 7: {
                this.writer.write(DTDConst.KEYWD_NMTOKEN);
                break;
            }
            case 8: {
                this.writer.write(DTDConst.KEYWD_NMTOKENS);
                break;
            }
            case 10: {
                this.writeEnumeration(attribute.enums, true);
                break;
            }
            case 9: {
                this.writeEnumeration(attribute.enums, false);
                break;
            }
        }
        this.writer.write(32);
    }

    private void writeEnumeration(Vector vector, boolean bl) throws IOException {
        if (bl) {
            this.writer.write(DTDConst.KEYWD_NOTATION);
            this.writer.write(32);
        }
        this.writer.write(40);
        this.writer.write((String)vector.elementAt(0));
        int n = 1;
        while (n < vector.size()) {
            this.writer.write(CHOICESEPARATOR);
            this.writer.write((String)vector.elementAt(n));
            ++n;
        }
        this.writer.write(41);
    }

    private void writeAttributeDefault(Attribute attribute) throws IOException {
        switch (attribute.required) {
            case 1: {
                this.writer.write(35);
                this.writer.write(DTDConst.KEYWD_REQUIRED);
                return;
            }
            case 2: {
                this.writer.write(35);
                this.writer.write(DTDConst.KEYWD_IMPLIED);
                return;
            }
            case 3: {
                this.writer.write(35);
                this.writer.write(DTDConst.KEYWD_FIXED);
                this.writer.write(32);
            }
            case 4: {
                this.writer.write(34);
                this.writer.write(this.replaceDoubleQuotes(attribute.defaultValue));
                this.writer.write(34);
                return;
            }
        }
    }

    private void writeNotations() throws IOException {
        Enumeration enumeration = this.dtd.notations.elements();
        while (enumeration.hasMoreElements()) {
            this.writeNotation((Notation)enumeration.nextElement());
        }
    }

    private void writeNotation(Notation notation) throws IOException {
        if (this.pretty) {
            this.writer.write(RETURN);
            this.writer.write(RETURN);
        }
        this.writer.write(DECLSTART);
        this.writer.write(DTDConst.KEYWD_NOTATION);
        this.writer.write(32);
        this.writer.write(notation.name);
        this.writer.write(32);
        if (notation.publicID != null) {
            this.writer.write(DTDConst.KEYWD_PUBLIC);
            this.writer.write(32);
            this.writeQuotedValue(notation.publicID);
        } else {
            this.writer.write(DTDConst.KEYWD_SYSTEM);
        }
        this.writer.write(32);
        if (notation.systemID != null) {
            this.writeQuotedValue(notation.systemID);
            this.writer.write(32);
        }
        this.writer.write(62);
    }

    private void writeEntities() throws IOException {
        Enumeration enumeration = this.dtd.unparsedEntities.elements();
        while (enumeration.hasMoreElements()) {
            this.writeEntity((Entity)enumeration.nextElement());
        }
        enumeration = this.dtd.parsedGeneralEntities.elements();
        while (enumeration.hasMoreElements()) {
            this.writeEntity((Entity)enumeration.nextElement());
        }
    }

    private void writeEntity(Entity entity) throws IOException {
        if (this.pretty) {
            this.writer.write(RETURN);
            this.writer.write(RETURN);
        }
        this.writer.write(DECLSTART);
        this.writer.write(DTDConst.KEYWD_ENTITY);
        this.writer.write(32);
        this.writer.write(entity.name);
        this.writer.write(32);
        if (entity.systemID == null) {
            this.writeQuotedValue(((ParsedGeneralEntity)entity).value);
        } else {
            if (entity.publicID != null) {
                this.writer.write(DTDConst.KEYWD_PUBLIC);
                this.writer.write(32);
                this.writeQuotedValue(entity.publicID);
            } else {
                this.writer.write(DTDConst.KEYWD_SYSTEM);
            }
            this.writer.write(32);
            this.writeQuotedValue(entity.systemID);
            if (entity.type == 3) {
                this.writer.write(32);
                this.writer.write(DTDConst.KEYWD_NDATA);
                this.writer.write(32);
                this.writer.write(((UnparsedEntity)entity).notation);
            }
        }
        this.writer.write(32);
        this.writer.write(62);
    }

    private void writeQuotedValue(String string) throws IOException {
        int n = this.getQuote(string);
        this.writer.write(n);
        this.writer.write(string);
        this.writer.write(n);
    }

    private int getQuote(String string) {
        if (string.indexOf(34) != -1) {
            return 39;
        }
        return 34;
    }

    private String replaceDoubleQuotes(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        int n2 = 0;
        while (n2 != -1) {
            n2 = string.indexOf(34, n);
            if (n2 == -1) continue;
            stringBuffer.append(string.substring(n, n2));
            stringBuffer.append(QUOTENTITYREF);
            n = ++n2;
        }
        stringBuffer.append(string.substring(n, string.length()));
        return stringBuffer.toString();
    }

    private void indent() throws IOException {
        int n = 0;
        while (n < this.indent) {
            this.writer.write(32);
            ++n;
        }
    }
}

