/*
 * Decompiled with CFR 0.152.
 */
package com.trsupdate;

import com.trs.DreamFactory;
import com.trs.cms.auth.domain.RightCacheMgr;
import com.trs.cms.auth.persistent.Group;
import com.trs.cms.auth.persistent.Groups;
import com.trs.cms.auth.persistent.Right;
import com.trs.cms.auth.persistent.Role;
import com.trs.cms.auth.persistent.Roles;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.auth.persistent.Users;
import com.trs.cms.content.CMSObj;
import com.trs.components.wcm.content.persistent.BaseChannel;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.util.CMyBitsValue;
import com.trs.infra.util.DebugTimer;
import com.trsupdate.InheritInfo;
import com.trsupdate.RightUpdaterHelper;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class InheritResultAssertor {
    private RightCacheMgr rightCacheMgr = (RightCacheMgr)DreamFactory.createObjectById("RightCacheMgr");
    private static Logger logger = Logger.getLogger(InheritResultAssertor.class);
    private List m_listInheritInfo = null;
    public static boolean ALL_USER_IS_SAME_MODE = false;
    private Users m_oAdmins = null;

    public InheritResultAssertor(List _listInheritInfo) {
        this.m_listInheritInfo = _listInheritInfo;
    }

    public void assertResult() throws WCMException {
        this.m_oAdmins = Users.findAdministrators();
        Users allUsers = Users.openWCMObjs(null, null);
        int nAllUserCount = allUsers.size();
        DebugTimer timer = new DebugTimer();
        int nSize = this.m_listInheritInfo.size();
        for (int i = 0; i < nSize; ++i) {
            InheritInfo oInheritInfo = (InheritInfo)this.m_listInheritInfo.get(i);
            Users users = oInheritInfo.getUsers();
            boolean bAllUserMode = (double)(nAllUserCount / users.size()) <= 1.2;
            timer.start();
            logger.debug((Object)("dowith " + oInheritInfo.getChannel() + "....."));
            int nUserCount = users.size();
            for (int nUserIndex = 0; nUserIndex < nUserCount; ++nUserIndex) {
                Right right;
                User user = (User)users.getAt(nUserIndex);
                DebugTimer tempTimer = new DebugTimer();
                tempTimer.start();
                List arNewRights = this.makeInheritRights(user, oInheritInfo.getChannel());
                tempTimer.stop();
                tempTimer.start();
                if (arNewRights.size() == 1 && (right = (Right)arNewRights.get(0)).getOperatorType() == 204) continue;
                String sGroupIds = this.makeNewRightOpratorIds(arNewRights, 201);
                String sRoleIds = this.makeNewRightOpratorIds(arNewRights, 203);
                Users oUsersInSameGroupOrRole = null;
                oUsersInSameGroupOrRole = bAllUserMode ? allUsers : this.makeUsersInSameGroupOrRole(user, sGroupIds, sRoleIds);
                tempTimer.stop();
                tempTimer.start();
                int nSameUserCount = oUsersInSameGroupOrRole.size();
                for (int nSameUserIndex = 0; nSameUserIndex < nSameUserCount; ++nSameUserIndex) {
                    User oSameUser;
                    boolean bExpand;
                    int nSameUserId = oUsersInSameGroupOrRole.getIdAt(nSameUserIndex);
                    if (users.indexOf(nSameUserId) >= 0 || this.m_oAdmins.indexOf(nSameUserId) >= 0 || !(bExpand = this.assertEnlargeRightOfUser(oInheritInfo, oSameUser = (User)oUsersInSameGroupOrRole.getAt(nSameUserIndex), arNewRights))) continue;
                    logger.error((Object)("!!!!!!!!!!! The " + user + " enlarge the  " + oSameUser + "'s right on " + oInheritInfo.getChannel() + " !!!!!!!!!!! "));
                }
                tempTimer.stop();
                tempTimer.start();
            }
            timer.stop();
            logger.debug((Object)("dowith " + oInheritInfo.getChannel() + " us[" + timer.getTime() + "]ms!"));
        }
    }

    private String makeNewRightOpratorIds(List _oNewRights, int _nOpertorType) {
        StringBuffer sbOpertorIds = new StringBuffer(_oNewRights.size() * 4);
        int nRightSize = _oNewRights.size();
        for (int j = 0; j < nRightSize; ++j) {
            Right right = (Right)_oNewRights.get(j);
            if (right.getOperatorType() == _nOpertorType) continue;
            sbOpertorIds.append(right.getOperatorId());
            sbOpertorIds.append(",");
        }
        if (sbOpertorIds.length() > 0) {
            sbOpertorIds.setLength(sbOpertorIds.length() - 1);
        }
        return sbOpertorIds.toString();
    }

    private boolean assertEnlargeRightOfUser(InheritInfo oInheritInfo, User _oUserOnSameGroupOrRole, List _arNewRights) throws WCMException {
        long lTemp;
        DebugTimer timer = new DebugTimer();
        timer.start();
        Channel channel = oInheritInfo.getChannel();
        long lOldRightValue = this.makeRightValue(channel, _oUserOnSameGroupOrRole);
        if (lOldRightValue != -1L) {
            timer.stop();
            return false;
        }
        Groups groups = _oUserOnSameGroupOrRole.getGroups();
        Roles roles = _oUserOnSameGroupOrRole.getRoles();
        timer.stop();
        timer.start();
        lOldRightValue = 0L;
        int nGroupSize = groups.size();
        for (int nGroupIndex = 0; nGroupIndex < nGroupSize; ++nGroupIndex) {
            Group group = (Group)groups.getAt(nGroupIndex);
            lTemp = this.makeRightValue(channel, group);
            if (lTemp == -1L) continue;
            lOldRightValue |= lTemp;
        }
        timer.stop();
        timer.start();
        int nRoleSize = roles.size();
        for (int nRoleIndex = 0; nRoleIndex < nRoleSize; ++nRoleIndex) {
            Role role = (Role)roles.getAt(nRoleIndex);
            lTemp = this.makeRightValue(channel, role);
            if (lTemp == -1L) continue;
            lOldRightValue |= lTemp;
        }
        timer.stop();
        timer.start();
        if (lOldRightValue == 0L) {
            return false;
        }
        long lNewRightValue = 0L;
        int nRightSize = _arNewRights.size();
        block6: for (int j = 0; j < nRightSize; ++j) {
            Right right = (Right)_arNewRights.get(j);
            switch (right.getOperatorType()) {
                case 201: {
                    if (groups.indexOf(right.getOperatorId()) >= 0) break;
                    continue block6;
                }
                case 203: {
                    if (roles.indexOf(right.getOperatorId()) >= 0) break;
                    continue block6;
                }
                default: {
                    continue block6;
                }
            }
            lNewRightValue |= right.getValueAsLong();
        }
        timer.stop();
        timer.start();
        return !RightUpdaterHelper.containsValue(lOldRightValue, lNewRightValue);
    }

    private List makeInheritRights(User _currUser, Channel _currChannel) throws WCMException {
        ArrayList<Right> arRights = new ArrayList<Right>();
        Groups groups = _currUser.getGroups();
        Roles roles = _currUser.getRoles();
        for (BaseChannel parent = _currChannel.getHost(); parent != null; parent = parent.getHost()) {
            Right right;
            long lRightValue = this.makeRightValue(parent, _currUser);
            if (lRightValue != -1L) {
                Right right2 = new Right();
                right2.setValue(lRightValue);
                right2.setOperator(_currUser);
                arRights.add(right2);
                return arRights;
            }
            int nGroupSize = groups.size();
            for (int nGroupIndex = 0; nGroupIndex < nGroupSize; ++nGroupIndex) {
                Group group = (Group)groups.getAt(nGroupIndex);
                lRightValue = this.makeRightValue(parent, group);
                if (lRightValue == -1L) continue;
                right = new Right();
                right.setValue(lRightValue);
                right.setOperator(group);
                arRights.add(right);
            }
            int nRoleSize = roles.size();
            for (int nRoleIndex = 0; nRoleIndex < nRoleSize; ++nRoleIndex) {
                Role role = (Role)roles.getAt(nRoleIndex);
                if (role.getId() == 1 || (lRightValue = this.makeRightValue(parent, role)) == -1L) continue;
                right = new Right();
                right.setValue(lRightValue);
                right.setOperator(role);
                arRights.add(right);
            }
            if (arRights.isEmpty()) {
                continue;
            }
            return arRights;
        }
        throw new WCMException("\u8ba1\u7b97\u9519\u8bef\uff0c\u4e0d\u53ef\u80fd\u6ca1\u6709\u4efb\u4f55\u7ee7\u627f\u7684\u6743\u9650\uff01User=[" + _currUser + "] Channel=[" + _currChannel + "]");
    }

    private long makeRightValue(BaseChannel _parent, CMSObj _currOperator) throws WCMException {
        long lRightValue = this.rightCacheMgr.getRightValue(_parent.getWCMType(), _parent.getId(), _currOperator.getWCMType(), _currOperator.getId(), -1L);
        if (lRightValue == -1L) {
            return lRightValue;
        }
        CMyBitsValue oBitsValue = new CMyBitsValue(lRightValue);
        for (int i = 0; i < 11; ++i) {
            oBitsValue.setBit(i, false);
        }
        long lValue = oBitsValue.getValue();
        if (lValue == 0L) {
            return -1L;
        }
        return lValue;
    }

    private Users makeUsersInSameGroupOrRole(User _user, String _sGroupIds, String _sRoleIds) throws WCMException {
        String sSameGroupUserWhere = "exists(select 1 from WCMGrpUser b where b.UserId=WCMUser.UserId" + (_sGroupIds.length() > 0 ? " and b.GroupId in(" + _sGroupIds + ") " : "") + " and exists( select 1 from WCMGrpUser c where b.GroupId=c.GroupId and c.UserId=?))";
        String sSameRoleUserWhere = "exists(select 1 from WCMRoleUser b where b.UserId=WCMUser.UserId" + (_sRoleIds.length() > 0 ? " and b.RoleId in(" + _sRoleIds + ") " : "") + " and exists( select 1 from WCMRoleUser c where b.RoleId=c.RoleId and c.UserId=?))";
        WCMFilter filter = new WCMFilter("", sSameGroupUserWhere + " or " + sSameRoleUserWhere, "");
        filter.addSearchValues(_user.getId());
        filter.addSearchValues(_user.getId());
        return Users.openWCMObjs(null, filter);
    }
}

