/*
 * Decompiled with CFR 0.152.
 */
package com.trs.wcm.photo;

import com.trs.cms.auth.persistent.User;
import com.trs.cms.content.CMSObj;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.support.file.FilesMan;
import com.trs.infra.util.CMyFile;

public class Watermark
extends CMSObj {
    public static final int OBJ_TYPE = 1377689707;
    public static final String DB_TABLE_NAME = "XWCMWATERMARK";
    public static final String DB_ID_NAME = "WATERMARKID";

    @Override
    public String getDbTableName() {
        return DB_TABLE_NAME;
    }

    @Override
    public String getIdFieldName() {
        return DB_ID_NAME;
    }

    @Override
    public int getWCMType() {
        return 1377689707;
    }

    public String getWMName() {
        return this.getPropertyAsString("WMNAME");
    }

    public boolean setWMName(String _sWMName) throws WCMException {
        return this.setProperty("WMNAME", _sWMName);
    }

    public String getWMPicture() {
        return this.getPropertyAsString("WMPICTURE");
    }

    public boolean setWMPicture(String _sWMPicture) throws WCMException {
        return this.setProperty("WMPICTURE", _sWMPicture);
    }

    public int getLibId() {
        return this.getPropertyAsInt("LIBID", 0);
    }

    public boolean setLibId(int _nLibId) throws WCMException {
        return this.setProperty("LIBID", _nLibId);
    }

    @Override
    public boolean isValid() throws WCMException {
        if (this.isAddMode()) {
            if (this.getLibId() == 0) {
                throw new WCMException(1106, I18NMessage.get(Watermark.class, "Watermark.label1", "\u6c34\u5370\u6240\u5c5e\u56fe\u5e93Id\u6ca1\u6709\u8bbe\u7f6e"));
            }
        } else if (!this.isModified()) {
            throw new WCMException(1107, I18NMessage.get(Watermark.class, "Watermark.label2", "\u5bf9\u8c61\u5c5e\u6027\u6ca1\u6709\u66f4\u6539(Watermark.isValid)"));
        }
        return true;
    }

    @Override
    public void insert(User _currUser) throws WCMException {
        if (this.isAddMode() && this.isModified()) {
            super.insert(_currUser);
        }
    }

    public static final Watermark findById(int _nId) throws WCMException {
        if (_nId <= 0) {
            return null;
        }
        return (Watermark)BaseObj.findById(Watermark.class, _nId);
    }

    public static final Watermark createNewInstance() throws WCMException {
        return (Watermark)BaseObj.createNewInstance(Watermark.class);
    }

    public static final Watermark findByKey(Object _oKey) throws WCMException {
        return (Watermark)BaseObj.findByKey(Watermark.class, _oKey);
    }

    @Override
    public void save(User _currUser) throws WCMException {
        String strWMPicture = this.getWMPicture();
        String strNewPicture = this.getNewPropertyAsString("WMPICTURE");
        FilesMan oFilesMan = FilesMan.getFilesMan();
        if (strNewPicture != null && strNewPicture.length() > 0 && this.isChangeProperty("WMPICTURE")) {
            oFilesMan.deleteFile(strWMPicture);
            strWMPicture = strNewPicture;
        }
        if (!FilesMan.isValidFile(strWMPicture, "W0")) {
            strWMPicture = oFilesMan.moveWCMFile(strWMPicture, "W0", true);
            strWMPicture = CMyFile.extractFileName(strWMPicture);
            this.setWMPicture(strWMPicture);
        }
        if (this.isAddMode()) {
            this.insert(_currUser);
        } else {
            this.update(_currUser);
        }
    }

    @Override
    public String toString() {
        if (this.IS_ENGVERSION) {
            return this.getWMName();
        }
        return this.getWMName() + I18NMessage.get(Watermark.class, "Watermark.label3", "[\u6c34\u5370-") + this.getId() + "]";
    }

    @Override
    public int delete(User _currUser) throws WCMException {
        int nRet = super.delete(_currUser);
        final String fn = this.getWMPicture();
        new Thread(){

            @Override
            public void run() {
                try {
                    FilesMan.getFilesMan().deleteFile(fn);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }.start();
        return nRet;
    }
}

