/*
 * Decompiled with CFR 0.152.
 */
package com.trs.tools;

import com.trs.infra.util.CMyString;
import com.trs.infra.util.store.FileService;
import java.io.BufferedWriter;
import java.io.OutputStreamWriter;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.log4j.Logger;

public class SQLBuilder {
    private static String dateFrom = "2009-10-21 16:45:18";
    private static String wcm = "('TRS.WCM.V6.1', 'TRS.WCM.V6.1.MetaData', 'TRS.WCM.V6.1.Pic', 'TRS.WCM.V6.1.Video')";
    private static String plugins = "('TRS.WCM.V6.1.Comment', 'TRS.WCM.V6.1.Poll', 'TRS.WCM.V6.1.Ad', 'TRS.WCM.V6.1.Infogate')";
    private static Logger logger = Logger.getLogger(SQLBuilder.class);

    public static void main(String[] args) {
        Connection conn = SQLBuilder.getConnection();
        if (conn == null) {
            return;
        }
        String strSQL = SQLBuilder.getQuerySQL(args);
        String sContent = SQLBuilder.getUpdateSQLContent(conn, strSQL);
        sContent = SQLBuilder.filterForSQLContent(sContent);
        String sFileName = "update.sql";
        if (args.length > 1) {
            sFileName = args[1];
        }
        SQLBuilder.writeFile(sFileName, sContent);
        SQLBuilder.closeConnection(conn);
    }

    private static String filterForSQLContent(String sContent) {
        return sContent.replaceAll("(?i)\\bGo\\b", "");
    }

    private static String getQuerySQL(String[] args) {
        String strSQL = "select * from WCMDBUPDATELOG where ";
        String sWhere = "LogProductor in ";
        String sProductType = wcm;
        if (args.length > 0 && args[0].equalsIgnoreCase("plugins")) {
            sProductType = plugins;
        }
        sWhere = sWhere + sProductType;
        if (args.length > 2) {
            dateFrom = args[2];
        }
        sWhere = sWhere + " and CRTIME > '" + dateFrom + "'";
        strSQL = strSQL + CMyString.filterForSQL2(sWhere);
        strSQL = strSQL + " order by CRTIME";
        return strSQL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getUpdateSQLContent(Connection conn, String strSQL) {
        StringBuffer sb = new StringBuffer();
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            statement = conn.createStatement();
            resultSet = statement.executeQuery(strSQL);
            while (resultSet.next()) {
                String sTitle = resultSet.getString("LOGTITLE");
                String submitor = resultSet.getString("SUBMITOR");
                String sCrtime = resultSet.getString("CRTIME");
                String sSQLServerContent = resultSet.getString("SQLSERVER");
                sb.append("-- ");
                if (sTitle != null) {
                    sb.append(sTitle).append("-");
                }
                if (submitor != null) {
                    sb.append(submitor).append("-");
                }
                if (sCrtime != null) {
                    sb.append(sCrtime).append("-");
                }
                sb.append("\n").append(sSQLServerContent).append("\n\n");
            }
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (SQLException e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                }
            }
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
        sb.append(SQLBuilder.getUpdateAppend());
        return sb.toString();
    }

    private static String getUpdateAppend() {
        Date date = new Date(System.currentTimeMillis());
        String sFormatDate = SimpleDateFormat.getDateTimeInstance().format(date);
        String updateLog = "";
        updateLog = updateLog + "INSERT INTO WCMDBUPDATE (updversion, updinfo, upduser, updtime) \nVALUES (1030, 'WCM52\u7684\u6570\u636e\u5e93\u811a\u672c\u5b8c\u5168\u66f4\u65b0', 'WCM Team', '" + sFormatDate + "');\n";
        updateLog = updateLog + "GO\n";
        return updateLog;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeFile(String sFileName, String sContent) {
        BufferedWriter os = null;
        try {
            os = new BufferedWriter(new OutputStreamWriter(new FileService(sFileName).getOutputStream()));
            os.write(sContent);
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
        finally {
            if (os != null) {
                try {
                    os.close();
                }
                catch (Exception e) {
                    e.printStackTrace(System.err);
                }
            }
        }
    }

    private static Connection getConnection() {
        try {
            Class.forName("net.sourceforge.jtds.jdbc.Driver");
        }
        catch (ClassNotFoundException e) {
            System.out.println("\u52a0\u8f7d\u9a71\u52a8\u76f8\u5173\u7c7b[net.sourceforge.jtds.jdbc.Driver]\u5931\u8d25!");
            e.printStackTrace(System.err);
        }
        try {
            return DriverManager.getConnection("jdbc:jtds:sqlserver://192.9.200.145:1433/TRSWCM52_Developer", "trswcm", "trs");
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            return null;
        }
    }

    private static void closeConnection(Connection conn) {
        if (conn != null) {
            try {
                conn.close();
            }
            catch (SQLException e) {
                e.printStackTrace(System.err);
            }
        }
    }
}

