/*
 * Decompiled with CFR 0.152.
 */
package com.trs.service.impl;

import com.trs.cms.ContextHelper;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.content.CMSBaseObjs;
import com.trs.components.wcm.content.ViewDocument;
import com.trs.components.wcm.content.ViewDocuments;
import com.trs.components.wcm.content.persistent.Channels;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.util.CMyString;
import com.trs.service.ISearcherService;
import com.trs.service.impl.IndexService;
import com.trs.service.impl.SearcherTool;
import com.trs.webframework.context.MethodContext;
import java.util.ArrayList;
import org.apache.log4j.Logger;

public class SearchByLuceneService
implements ISearcherService {
    private static Logger m_oLogger = Logger.getLogger(SearchByLuceneService.class);

    @Override
    public ViewDocuments search(MethodContext _methContext) throws WCMException {
        User loginUser = ContextHelper.getLoginUser();
        boolean bInChannelsHost = _methContext.getValue("bInChannelsHost", false);
        CMSBaseObjs objects = (CMSBaseObjs)_methContext.getObjectValue("objects");
        Channels oQueryChannels = (Channels)_methContext.getObjectValue("oQueryChannels");
        long startTime = System.currentTimeMillis();
        ViewDocuments viewDocuments = new ViewDocuments(loginUser, 1, 1);
        IndexService indexService = new IndexService();
        String docInfos = indexService.findDocIds(_methContext);
        long endTime = System.currentTimeMillis();
        m_oLogger.debug((Object)(docInfos + " lucene\u67e5\u8be2\u8017\u65f6\uff1a" + (endTime - startTime)));
        if (CMyString.isEmpty(docInfos)) {
            return viewDocuments;
        }
        String[] docInfoArr = docInfos.split(":");
        int pageNum = Integer.parseInt(docInfoArr[1]);
        WCMFilter filter = new WCMFilter();
        filter.setWhere("WCMCHNLDOC.RECID IN(" + docInfoArr[0] + ")");
        filter.setFrom("WCMCHNLDOC");
        try {
            int size;
            WCMFilter extendFilter = SearcherTool.getFilterForCopyOnly(_methContext);
            filter.mergeWith(extendFilter);
            SearcherTool.filterForUser(_methContext, loginUser, extendFilter, oQueryChannels);
            if (oQueryChannels == null) {
                return null;
            }
            String sChannelId = _methContext.getValue("ChannelId");
            String sDBFields = "";
            if (!CMyString.isEmpty(sChannelId)) {
                sDBFields = SearcherTool.makeSelectFields(_methContext);
            }
            if (CMyString.isEmpty(sDBFields)) {
                viewDocuments.setSelectFields(_methContext.getValue("ChnlDocSelectFields"), _methContext.getValue("DocumentSelectFields"));
            } else {
                ArrayList<String> aChnldocList = new ArrayList<String>();
                ArrayList<String> aDocList = new ArrayList<String>();
                String[] sFields = sDBFields.split(",");
                for (int i = 0; i < sFields.length; ++i) {
                    if (sFields[i].toUpperCase().indexOf("WCMCHNLDOC.") > -1) {
                        aChnldocList.add(sFields[i]);
                        continue;
                    }
                    if (sFields[i].toUpperCase().indexOf("WCMDOCUMENT.") <= -1) continue;
                    aDocList.add(sFields[i]);
                }
                String sChnlDocFields = aChnldocList.toString();
                sChnlDocFields = sChnlDocFields.substring(1, sChnlDocFields.length() - 1);
                String sDocFields = aDocList.toString();
                sDocFields = sDocFields.substring(1, sDocFields.length() - 1);
                viewDocuments.setSelectFields(sChnlDocFields, sDocFields);
            }
            viewDocuments.setCurrPage(1);
            viewDocuments.setPageSize(_methContext.getPageSize());
            viewDocuments.setRightIndex(64);
            viewDocuments.setNeedWithAuthFilter(loginUser, true);
            if (bInChannelsHost) {
                viewDocuments.open(oQueryChannels, filter);
            } else if (loginUser.isAdministrator()) {
                viewDocuments.open(objects, filter);
            } else {
                viewDocuments.open(oQueryChannels, filter);
            }
            String[] recIds = docInfoArr[0].split(",");
            ViewDocument[] viewDocumentArr = new ViewDocument[recIds.length];
            String key = _methContext.getValue("DOCTITLE");
            if (!CMyString.isEmpty(key)) {
                block4: for (int i = 0; i < viewDocuments.size(); ++i) {
                    ViewDocument viewDocument = (ViewDocument)viewDocuments.getAt(i);
                    int recId = viewDocument.getChnlDoc().getPropertyAsInt("RECID", 0);
                    String title = viewDocument.getDocument().getTitle();
                    if (title.length() > 32) {
                        title = title.substring(0, 32) + ". . .";
                    }
                    title = title.replaceAll("[\\[\\]]", " ").replaceAll("[\"]", "\u201c");
                    String high = indexService.getLighter("DOCTITLE", title, key);
                    viewDocument.setProperty("HIGHTITLE", high);
                    for (int j = 0; j < recIds.length; ++j) {
                        if (!recIds[j].equals(recId + "")) continue;
                        viewDocumentArr[j] = viewDocument;
                        continue block4;
                    }
                }
                _methContext.setValue("HIGHLITER", viewDocumentArr);
            }
            if ((size = viewDocuments.size()) == 0) {
                pageNum = 0;
            }
            _methContext.setValue("RECCOUNT", size);
            _methContext.setValue("SEARCH", "LUCENE");
            viewDocuments.setCurrPage(_methContext.getPageIndex());
            viewDocuments.setRecCount(pageNum);
            return viewDocuments;
        }
        catch (NumberFormatException e) {
            throw new NumberFormatException("NumberFormatException\uff0c\u6570\u5b57\u7c7b\u578b\u8f6c\u5316\u9519\u8bef" + e.getMessage());
        }
        catch (WCMException e) {
            throw new WCMException("viewDocuments\uff0c\u5f00\u96c6\u5408\u5f02\u5e38", e);
        }
    }
}

