/*
 * Decompiled with CFR 0.152.
 */
package com.trs.scm.sdk.impl;

import com.tencent.weibo.api.StatusesAPI;
import com.tencent.weibo.api.TAPI;
import com.tencent.weibo.beans.OAuth;
import com.tencent.weibo.oauthv2.OAuthV2;
import com.tencent.weibo.oauthv2.OAuthV2Request;
import com.tencent.weibo.utils.QArrayList;
import com.trs.infra.common.WCMException;
import com.trs.infra.util.CMyDateTime;
import com.trs.infra.util.CMyException;
import com.trs.scm.sdk.impl.AbstractMicroContentMgr;
import com.trs.scm.sdk.model.Count;
import com.trs.scm.sdk.model.ExtraParams;
import com.trs.scm.sdk.model.MicroContent;
import com.trs.scm.sdk.model.MicroContentWrapper;
import com.trs.scm.sdk.util.CMyContentTranslate;
import com.trs.scm.sdk.util.TencentObjectUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.json.JSONObject;
import org.apache.http.NameValuePair;
import org.apache.http.message.BasicNameValuePair;

public class TencentMicroContentMgr
extends AbstractMicroContentMgr {
    private final int HOME_TIMELINE = 1;
    private final int CURRUSER_TIME_LINE = 2;
    private final int METIONS_TIMELINE = 3;
    private TAPI m_oTAPI = new TAPI("2.a");
    private StatusesAPI m_oStatusesAPI = new StatusesAPI("2.a");
    private OAuthV2 m_oTencentOAuth = new OAuthV2();
    private static Map<String, MicroContentWrapper> m_OAuthMicroContentMap = null;
    private static Map<String, CMyDateTime> m_oLastRefreshDate = null;
    private static final String UPLOAD_PIC_URL = "https://open.t.qq.com/api/t/upload_pic";
    private static final int MAX_UPLOAD_PICS_COUNTS_TENCENT = 9;

    public TencentMicroContentMgr(com.trs.scm.sdk.model.OAuth _oAuth) {
        super(_oAuth);
        this.m_oTencentOAuth.setAccessToken(_oAuth.getOAuth_token());
        this.m_oTencentOAuth.setOpenid(_oAuth.getOAuth_token_secret());
        this.m_oTencentOAuth.setClientId(_oAuth.getAppKey());
    }

    @Override
    public MicroContent createMicroContent(String content, ExtraParams extraParams) throws Exception {
        content = CMyContentTranslate.tencentTranslateFaceText(content);
        String sTempContent = CMyContentTranslate.microContentUrlShortLength(content);
        this.checkContentLength(sTempContent);
        String sIp = extraParams.getParamAsString("IP");
        String sLatitude = extraParams.getParamAsString("lat");
        String sLongitude = extraParams.getParamAsString("long");
        String sResponse = this.m_oTAPI.add((OAuth)this.m_oTencentOAuth, "json", content, sIp, sLongitude, sLatitude, "0");
        TencentObjectUtil.validResult(sResponse, "\u53d1\u8868\u4e00\u6761\u5fae\u535a");
        JSONObject oJsonObject = JSONObject.fromObject((Object)sResponse);
        oJsonObject = oJsonObject.getJSONObject("data");
        String sId = oJsonObject.getString("id");
        long lTimeStamp = oJsonObject.getLong("time");
        MicroContent microContent = new MicroContent();
        microContent.setId(sId);
        microContent.setContent(content);
        microContent.setCreateDate(new Date(lTimeStamp * 1000L));
        microContent.setCommentCount(0);
        microContent.setRepostCount(0);
        this.resetRefreshTime();
        return microContent;
    }

    @Override
    public MicroContent createMicroContent(String content, String picPaths, ExtraParams extraParams) throws Exception {
        content = CMyContentTranslate.tencentTranslateFaceText(content);
        String sTempContent = CMyContentTranslate.microContentUrlShortLength(content);
        this.checkContentLength(sTempContent);
        String[] sPicPathArray = picPaths.split(",");
        int length = sPicPathArray.length;
        for (int i = 0; i < length && i < 9; ++i) {
            this.isPicLegal(sPicPathArray[i]);
        }
        String sIp = extraParams.getParamAsString("IP");
        String sLatitude = extraParams.getParamAsString("lat");
        String sLongitude = extraParams.getParamAsString("long");
        StringBuffer sfImgUrl = new StringBuffer();
        int length2 = sPicPathArray.length;
        for (int i = 0; i < length2 && i < 9; ++i) {
            String sUploadPicJson = this.uploadPic((OAuth)this.m_oTencentOAuth, "json", "", sPicPathArray[i], "2");
            JSONObject oJsonObj = JSONObject.fromObject((Object)sUploadPicJson);
            JSONObject dataJsonObj = (JSONObject)oJsonObj.get("data");
            sfImgUrl = sfImgUrl.append(dataJsonObj.getString("imgurl"));
            if (sPicPathArray.length - 1 == i) continue;
            sfImgUrl.append(",");
        }
        String sResponse = this.m_oTAPI.addPic((OAuth)this.m_oTencentOAuth, "json", content, sIp, sLongitude, sLatitude, sfImgUrl.toString(), "");
        TencentObjectUtil.validResult(sResponse, "\u53d1\u8868\u4e00\u6761\u5fae\u535a");
        JSONObject oJsonObject = JSONObject.fromObject((Object)sResponse);
        oJsonObject = oJsonObject.getJSONObject("data");
        String sId = oJsonObject.getString("id");
        long lTimeStamp = oJsonObject.getLong("time");
        MicroContent microContent = new MicroContent();
        microContent.setId(sId);
        microContent.setContent(content);
        microContent.setCreateDate(new Date(lTimeStamp * 1000L));
        microContent.setCommentCount(0);
        microContent.setRepostCount(0);
        this.resetRefreshTime();
        return microContent;
    }

    @Override
    public boolean destroyMicroContent(String id) throws Exception {
        if (id == null || id.length() == 0) {
            throw new Exception("\u5fae\u535aId\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String sResponse = this.m_oTAPI.del((OAuth)this.m_oTencentOAuth, "json", id);
        TencentObjectUtil.validResult(sResponse, "\u5220\u9664\u5fae\u535a");
        this.resetRefreshTime();
        return true;
    }

    @Override
    public MicroContentWrapper getHomeTimeline(int pageIndex, int pageSize, ExtraParams extraParams) throws Exception {
        int nMaxPageSize = 70;
        int nMicroContentType = 1;
        int nType = 3;
        return this.getMicroContentsByType(nMicroContentType, nType, pageIndex, pageSize, nMaxPageSize);
    }

    @Override
    public MicroContentWrapper getUserTimeline(int pageIndex, int pageSize, ExtraParams extraParams) throws Exception {
        int nMaxPageSize = 200;
        int nMicroContentType = 2;
        int nType = 3;
        return this.getMicroContentsByType(nMicroContentType, nType, pageIndex, pageSize, nMaxPageSize);
    }

    @Override
    public MicroContentWrapper getUserTimelineByType(int type, int pageIndex, int pageSize, ExtraParams extraParams) throws Exception {
        int nMaxPageSize = 200;
        int nMicroContentType = 2;
        int nType = type;
        return this.getMicroContentsByType(nMicroContentType, nType, pageIndex, pageSize, nMaxPageSize);
    }

    @Override
    public MicroContent repostMicroContent(String content, String id, ExtraParams extraParams) throws Exception {
        String sTempContent = CMyContentTranslate.microContentUrlShortLength(content = CMyContentTranslate.tencentTranslateFaceText(content));
        if (sTempContent.length() > 280) {
            throw new WCMException("\u8f6c\u53d1\u7684\u5fae\u535a\u5185\u5bb9\u957f\u5ea6\u8d85\u8fc7140\u4e2a\u5b57\uff01\u5e73\u53f0\uff1a\u817e\u8baf");
        }
        if (id == null || id.length() == 0) {
            throw new Exception("\u8f6c\u53d1\u5fae\u535a\u7684Id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String sIp = extraParams.getParamAsString("IP");
        String sLatitude = extraParams.getParamAsString("lat");
        String sLongitude = extraParams.getParamAsString("long");
        String sResponse = this.m_oTAPI.reAdd((OAuth)this.m_oTencentOAuth, "json", content, sIp, sLongitude, sLatitude, id);
        TencentObjectUtil.validResult(sResponse, "\u8f6c\u53d1\u5fae\u535a");
        JSONObject oJsonObject = JSONObject.fromObject((Object)sResponse);
        oJsonObject = oJsonObject.getJSONObject("data");
        String sNewId = oJsonObject.getString("id");
        MicroContent oRepostMicroContent = new MicroContent();
        oRepostMicroContent.setId(sNewId);
        oRepostMicroContent.setContent(content);
        oRepostMicroContent.setRetweeted(true);
        MicroContent oMicroContent = new MicroContent();
        oMicroContent.setId(id);
        oRepostMicroContent.setRetweetedMicroContent(oMicroContent);
        this.resetRefreshTime();
        return oRepostMicroContent;
    }

    @Override
    public MicroContent findById(String id) throws Exception {
        if (id == null || id.length() == 0) {
            throw new Exception("\u5fae\u535aId\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String sResponse = this.m_oTAPI.show((OAuth)this.m_oTencentOAuth, "json", id);
        MicroContent oMicroContent = TencentObjectUtil.constructMicroContent(sResponse);
        return oMicroContent;
    }

    @Override
    public MicroContentWrapper getMentions(int pageIndex, int pageSize, ExtraParams extraParams) throws Exception {
        int nMaxPageSize = 70;
        int nMicroContentType = 3;
        int nType = 3;
        return this.getMicroContentsByType(nMicroContentType, nType, pageIndex, pageSize, nMaxPageSize);
    }

    @Override
    public Map<String, Count> getCount(String ids) throws Exception {
        if (ids == null || ids.length() < 1) {
            throw new NullPointerException("\u8f93\u5165\u7684\u5fae\u535aID\u5217\u8868\u4e3a\u7a7a\uff01");
        }
        if (ids.split(",").length > 30) {
            throw new ArrayIndexOutOfBoundsException("\u8f93\u5165\u7684\u5fae\u535aID\u5217\u8868\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc730\uff01");
        }
        String[] pIds = ids.split(",");
        String sResult = this.m_oTAPI.reCount((OAuth)this.m_oTencentOAuth, "json", ids, "2");
        JSONObject oJsonObject = JSONObject.fromObject((Object)sResult);
        oJsonObject = oJsonObject.getJSONObject("data");
        HashMap<String, Count> result = new HashMap<String, Count>();
        for (int i = 0; i < pIds.length; ++i) {
            JSONObject oJsonCountAndMcount = oJsonObject.getJSONObject(pIds[i]);
            long lCommentCount = oJsonCountAndMcount.getLong("mcount");
            long lRepostCount = oJsonCountAndMcount.getLong("count");
            Count count = new Count(pIds[i]);
            count.setCommentCount(lCommentCount);
            count.setRepostCount(lRepostCount);
            result.put(pIds[i], count);
        }
        return result;
    }

    private MicroContentWrapper getMicroContentsByType(int _nMicroContentType, int _nType, int _nPageIndex, int _nPageSize, int _nMaxPageSize) throws Exception {
        if (_nPageSize < 1 || _nPageSize > 70) {
            throw new Exception("\u9875\u9762\u5927\u5c0f\u5fc5\u987b\u57281-70\u4e4b\u95f4");
        }
        if (_nPageIndex < 1) {
            _nPageIndex = 1;
        }
        int nMaxPageSize = _nMaxPageSize;
        int nMicroContentType = _nMicroContentType;
        boolean bRefreshed = this.refreshIfNeed(nMicroContentType, _nType, _nPageIndex, _nPageSize, nMaxPageSize);
        String sAccessToken = this.m_oTencentOAuth.getAccessToken();
        String sKey = this.makeKey(nMicroContentType, sAccessToken);
        MicroContentWrapper oMicroContentWrapper = m_OAuthMicroContentMap.get(sKey);
        if (oMicroContentWrapper == null) {
            return null;
        }
        if (bRefreshed) {
            return this.constructResult(_nPageIndex, _nPageSize, oMicroContentWrapper);
        }
        int nFromIndex = _nPageIndex * _nPageSize - _nPageSize;
        int nToIndex = _nPageIndex * _nPageSize;
        long lTotalNum = oMicroContentWrapper.getTotalNumber();
        List<MicroContent> microContents = oMicroContentWrapper.getMicroContents();
        int nListSize = microContents.size();
        int nRequestNum = 0;
        if (lTotalNum == -1L) {
            int nHasNext = oMicroContentWrapper.getExtraAttributeAsInt("hasnext", 1);
            nRequestNum = nHasNext == 1 ? 0 : nToIndex - nListSize;
        } else {
            if (lTotalNum <= (long)nFromIndex) {
                return null;
            }
            nRequestNum = lTotalNum < (long)nToIndex ? (int)lTotalNum - nListSize : nToIndex - nListSize;
        }
        if (nRequestNum <= 0) {
            return this.constructResult(_nPageIndex, _nPageSize, oMicroContentWrapper);
        }
        oMicroContentWrapper = this.loadMicroContents(oMicroContentWrapper, nMicroContentType, _nType, nRequestNum, _nPageSize, nMaxPageSize);
        m_OAuthMicroContentMap.put(sKey, oMicroContentWrapper);
        return this.constructResult(_nPageIndex, _nPageSize, oMicroContentWrapper);
    }

    private String makeKey(int _nMicroContentType, String _sAccessToken) {
        return _nMicroContentType + "_" + _sAccessToken;
    }

    private boolean refreshIfNeed(int _nMicroContentType, int _nType, int _nPageIndex, int _nPageSize, int _nMaxPageSize) throws Exception {
        if (!this.needRefresh(_nMicroContentType)) {
            return false;
        }
        int nRequestNum = _nPageIndex * _nPageSize;
        MicroContentWrapper oMicroContentWrapper = this.loadMicroContents(null, _nMicroContentType, _nType, nRequestNum, _nPageSize, _nMaxPageSize);
        if (m_OAuthMicroContentMap == null) {
            m_OAuthMicroContentMap = new HashMap<String, MicroContentWrapper>();
        }
        if (m_oLastRefreshDate == null) {
            m_oLastRefreshDate = new HashMap<String, CMyDateTime>();
        }
        String sAccessToken = this.m_oTencentOAuth.getAccessToken();
        String sKey = this.makeKey(_nMicroContentType, sAccessToken);
        m_OAuthMicroContentMap.put(sKey, oMicroContentWrapper);
        m_oLastRefreshDate.put(sKey, CMyDateTime.now());
        return true;
    }

    private boolean needRefresh(int _nMicroContentType) {
        if (m_oLastRefreshDate == null) {
            return true;
        }
        String sKey = this.makeKey(_nMicroContentType, this.m_oTencentOAuth.getAccessToken());
        CMyDateTime oLastRefreshTime = m_oLastRefreshDate.get(sKey);
        if (oLastRefreshTime == null) {
            return true;
        }
        CMyDateTime now = CMyDateTime.now();
        return now.getTimeInMillis() - oLastRefreshTime.getTimeInMillis() > 120000L;
    }

    private MicroContentWrapper loadMicroContents(MicroContentWrapper _oMicroContentWrapper, int _nMicroContentType, int _nType, int _nRequestNum, int _nPageSize, int _nMaxPageSize) throws Exception {
        MicroContentWrapper tempMicroContentWrapper;
        List<MicroContent> microContents;
        int nListSize;
        int[] nPageParams = this.calculatePageParam(_nRequestNum, _nPageSize, _nMaxPageSize);
        int nPageNum = nPageParams[0];
        int nPageSize = nPageParams[1];
        String sReqnum = Integer.toString(nPageSize);
        String sLastId = "0";
        String sPageTime = "0";
        if (_oMicroContentWrapper != null && (nListSize = (microContents = _oMicroContentWrapper.getMicroContents()).size()) > 0) {
            MicroContent lastMicroContent = microContents.get(nListSize - 1);
            sLastId = lastMicroContent.getId();
            sPageTime = Long.toString(lastMicroContent.getCreateDate().getTime() / 1000L);
        }
        String sPageFlag = "1";
        MicroContentWrapper allMicroContentWrapper = _oMicroContentWrapper;
        for (int i = 1; i <= nPageNum && (tempMicroContentWrapper = this.loadMicroContentsByType(_nMicroContentType, _nType, sPageFlag, sReqnum, sPageTime, sLastId)) != null; ++i) {
            if (allMicroContentWrapper == null) {
                allMicroContentWrapper = tempMicroContentWrapper;
            } else {
                List<MicroContent> allMicroContents = allMicroContentWrapper.getMicroContents();
                List<MicroContent> tempMicroContents = tempMicroContentWrapper.getMicroContents();
                allMicroContents.addAll(tempMicroContents);
                allMicroContentWrapper.setMicroContents(allMicroContents);
                allMicroContentWrapper.setTotalNumber(tempMicroContentWrapper.getTotalNumber());
            }
            int nHasNext = tempMicroContentWrapper.getExtraAttributeAsInt("hasnext", 1);
            allMicroContentWrapper.setExtraAttribute("hasnext", nHasNext);
            sPageTime = tempMicroContentWrapper.getExtraAttributeAsString("timestamp");
            sLastId = tempMicroContentWrapper.getExtraAttributeAsString("lastId");
            if (nHasNext == 1) break;
        }
        return allMicroContentWrapper;
    }

    private MicroContentWrapper loadMicroContentsByType(int _nMicroContentType, int _nType, String _sPageFlag, String _sReqnum, String _sPageTime, String _sLastId) throws Exception {
        String sRequestType = Integer.toString(_nType);
        String sResponse = "";
        switch (_nMicroContentType) {
            case 1: {
                sResponse = this.m_oStatusesAPI.homeTimeline((OAuth)this.m_oTencentOAuth, "json", _sPageFlag, _sPageTime, _sReqnum, sRequestType, "0");
                break;
            }
            case 2: {
                sResponse = this.m_oStatusesAPI.broadcastTimeline((OAuth)this.m_oTencentOAuth, "json", _sPageFlag, _sPageTime, _sReqnum, _sLastId, sRequestType, "0");
                break;
            }
            case 3: {
                sResponse = this.m_oStatusesAPI.mentionsTimeline((OAuth)this.m_oTencentOAuth, "json", _sPageFlag, _sPageTime, _sReqnum, _sLastId, sRequestType, "0");
                break;
            }
        }
        MicroContentWrapper oMicroContentWrapper = TencentObjectUtil.constructMicroContents(sResponse);
        return oMicroContentWrapper;
    }

    private int[] calculatePageParam(int _nRequestNum, int _nPageSize, int _nMaxPageSize) {
        int nPageNum = 0;
        int nPageSize = _nPageSize;
        int nRequestNum = _nRequestNum;
        if (_nRequestNum <= _nMaxPageSize) {
            nPageNum = 1;
            nPageSize = nRequestNum;
        } else {
            nPageNum = nRequestNum / _nMaxPageSize;
            nPageSize = _nMaxPageSize;
            int nLastPageNum = nRequestNum % _nMaxPageSize;
            if (nLastPageNum > 0) {
                // empty if block
            }
        }
        int[] pageParam = new int[]{++nPageNum, nPageSize};
        return pageParam;
    }

    private MicroContentWrapper constructResult(int _nPageIndex, int _nPageSize, MicroContentWrapper _oMicroContentWrapper) {
        if (_oMicroContentWrapper == null) {
            return null;
        }
        List<MicroContent> oMicroContents = _oMicroContentWrapper.getMicroContents();
        int nNum = oMicroContents.size();
        int nFromIndex = _nPageIndex * _nPageSize - _nPageSize;
        if (oMicroContents == null || nNum == 0 || nNum <= nFromIndex) {
            return null;
        }
        int nToIndex = _nPageIndex * _nPageSize;
        if (nNum < nToIndex) {
            nToIndex = nNum;
        }
        ArrayList<MicroContent> oNewMicroContents = new ArrayList<MicroContent>();
        oNewMicroContents.addAll(oMicroContents);
        List<MicroContent> oResultMCs = oNewMicroContents.subList(nFromIndex, nToIndex);
        MicroContentWrapper oResultMCWrapper = new MicroContentWrapper(oResultMCs, _oMicroContentWrapper.getTotalNumber());
        oResultMCWrapper.setExtraAttributes(_oMicroContentWrapper.getExtraAttributes());
        return oResultMCWrapper;
    }

    private void resetRefreshTime() throws CMyException {
        String sAccessToken = this.m_oTencentOAuth.getAccessToken();
        CMyDateTime oLastRefreshedTime = null;
        oLastRefreshedTime = CMyDateTime.now().dateAdd(5, -2);
        if (m_oLastRefreshDate != null && m_OAuthMicroContentMap != null) {
            m_oLastRefreshDate.put(this.makeKey(2, sAccessToken), oLastRefreshedTime);
            m_OAuthMicroContentMap.put(this.makeKey(2, sAccessToken), null);
            m_oLastRefreshDate.put(this.makeKey(1, sAccessToken), oLastRefreshedTime);
            m_OAuthMicroContentMap.put(this.makeKey(1, sAccessToken), null);
            m_oLastRefreshDate.put(this.makeKey(3, sAccessToken), oLastRefreshedTime);
            m_OAuthMicroContentMap.put(this.makeKey(3, sAccessToken), null);
        }
    }

    public String uploadPic(OAuth oAuth, String format, String pic_url, String pic, String pic_type) throws Exception {
        QArrayList paramsList = new QArrayList();
        paramsList.add((NameValuePair)new BasicNameValuePair("format", format));
        paramsList.add((NameValuePair)new BasicNameValuePair("pic_type", pic_type));
        if ("1" == pic_type) {
            paramsList.add((NameValuePair)new BasicNameValuePair("pic_url", pic_url));
        } else if ("2".equals(pic_type)) {
            paramsList.add((NameValuePair)new BasicNameValuePair("pic", pic));
        }
        OAuthV2Request requestAPI = new OAuthV2Request();
        QArrayList picc = new QArrayList();
        picc.add((NameValuePair)new BasicNameValuePair("pic", pic));
        return requestAPI.postFile(UPLOAD_PIC_URL, (List)paramsList, (List)picc, oAuth);
    }
}

