/*
 * Decompiled with CFR 0.152.
 */
package com.trs.infra.util.upgrade.dbcompare;

import com.trs.infra.util.upgrade.dbcompare.Column;
import com.trs.infra.util.upgrade.dbcompare.Table;
import java.util.ArrayList;
import java.util.List;

public class TableDiff {
    public static final int TYPE_COLNEW = 0;
    public static final int TYPE_COLUPD = 1;
    public static final int TYPE_COLDEL = 2;
    private String tableName;
    private List newcols;
    private List updcols;
    private List delcols;
    private boolean newtable;
    private Table table;

    public TableDiff(String tableName) {
        this.tableName = tableName.toUpperCase();
        this.newcols = new ArrayList();
        this.updcols = new ArrayList();
        this.delcols = new ArrayList(5);
    }

    public TableDiff(Table table) {
        this.table = table;
        this.tableName = table.getTableName();
        this.newtable = true;
    }

    public List getNewcols() {
        return this.newcols;
    }

    public void setNewcols(List newcols) {
        this.newcols = newcols;
    }

    public List getUpdcols() {
        return this.updcols;
    }

    public void setUpdcols(List updcols) {
        this.updcols = updcols;
    }

    public List getDelcols() {
        return this.delcols;
    }

    public void setDelcols(List delcols) {
        this.delcols = delcols;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void addColumn(Column column, int type) {
        switch (type) {
            case 0: {
                this.newcols.add(column);
                break;
            }
            case 1: {
                this.updcols.add(column);
                break;
            }
            case 2: {
                this.delcols.add(column);
                break;
            }
        }
    }

    public boolean isNewtable() {
        return this.newtable;
    }

    public Table getTable() {
        return this.table;
    }

    public String toString() {
        int i;
        int size;
        if (this.table != null) {
            return this.table.toString();
        }
        if (this.newcols.isEmpty() && this.updcols.isEmpty() && this.delcols.isEmpty()) {
            return "";
        }
        StringBuffer buff = new StringBuffer(64);
        buff.append(this.tableName);
        buff.append(':');
        if (!this.newcols.isEmpty()) {
            buff.append("\nadd(");
            buff.append(this.newcols.get(0));
            size = this.newcols.size();
            for (i = 1; i < size; ++i) {
                buff.append(',');
                buff.append(this.newcols.get(i));
            }
            buff.append(')');
        }
        if (!this.updcols.isEmpty()) {
            buff.append("\nupd(");
            buff.append(this.updcols.get(0));
            size = this.updcols.size();
            for (i = 1; i < size; ++i) {
                buff.append(',');
                buff.append(this.updcols.get(i));
            }
            buff.append(')');
        }
        if (!this.delcols.isEmpty()) {
            buff.append("\ndel(");
            buff.append(this.delcols.get(0));
            size = this.delcols.size();
            for (i = 1; i < size; ++i) {
                buff.append(',');
                buff.append(this.delcols.get(i));
            }
            buff.append(')');
        }
        return buff.toString();
    }
}

