/*
 * Decompiled with CFR 0.152.
 */
package com.trs.infra.util.store.impl;

import com.trs.infra.util.store.RandomAccessFileStore;
import com.trs.infra.util.store.RandomAccessFileStoreException;
import com.trs.infra.util.store.SmbRandomAccessFileWrapper;
import jcifs.smb.SmbException;
import jcifs.smb.SmbRandomAccessFile;

public class SmbRandomAccessFileStore
implements RandomAccessFileStore {
    private SmbRandomAccessFileWrapper file;

    public SmbRandomAccessFileStore(String url, String mode) {
        try {
            this.file = new SmbRandomAccessFileWrapper(new SmbRandomAccessFile(url, mode, 7));
        }
        catch (Exception e) {
            throw new RandomAccessFileStoreException(e);
        }
    }

    public SmbRandomAccessFileStore(String url, String mode, int shareAccess) {
        try {
            this.file = new SmbRandomAccessFileWrapper(new SmbRandomAccessFile(url, mode, shareAccess));
        }
        catch (Exception e) {
            throw new RandomAccessFileStoreException(e);
        }
    }

    @Override
    public void readFully(byte[] b) {
        try {
            this.file.readFully(b);
        }
        catch (SmbException e) {
            throw new RandomAccessFileStoreException(e);
        }
    }

    @Override
    public void readFully(byte[] b, int off, int len) {
        try {
            this.file.readFully(b, off, len);
        }
        catch (SmbException e) {
            throw new RandomAccessFileStoreException(e);
        }
    }

    @Override
    public int skipBytes(int n) {
        try {
            return this.file.skipBytes(n);
        }
        catch (SmbException e) {
            throw new RandomAccessFileStoreException(e);
        }
    }

    @Override
    public void seek(long pos) {
        try {
            this.file.seek(pos);
        }
        catch (SmbException e) {
            throw new RandomAccessFileStoreException(e);
        }
    }

    @Override
    public long length() {
        try {
            return this.file.length();
        }
        catch (SmbException e) {
            throw new RandomAccessFileStoreException(e);
        }
    }

    @Override
    public void close() {
        try {
            this.file.close();
        }
        catch (SmbException e) {
            throw new RandomAccessFileStoreException(e);
        }
    }

    @Override
    public int readUnsignedByte() {
        try {
            return this.file.readUnsignedByte();
        }
        catch (SmbException e) {
            throw new RandomAccessFileStoreException(e);
        }
    }

    @Override
    public int read() {
        try {
            return this.file.read();
        }
        catch (SmbException e) {
            throw new RandomAccessFileStoreException(e);
        }
    }

    @Override
    public int read(byte[] b) {
        try {
            return this.file.read(b);
        }
        catch (SmbException e) {
            throw new RandomAccessFileStoreException(e);
        }
    }

    @Override
    public int read(byte[] b, int off, int len) {
        try {
            return this.file.read(b, off, len);
        }
        catch (SmbException e) {
            throw new RandomAccessFileStoreException(e);
        }
    }
}

