/*
 * Decompiled with CFR 0.152.
 */
package com.trs.infra.util.html;

import com.trs.infra.I18NMessage;
import com.trs.infra.util.CMyException;
import com.trs.infra.util.CMyFile;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.html.HTML;
import com.trs.infra.util.html.HtmlAttribute;
import com.trs.infra.util.html.HtmlComment;
import com.trs.infra.util.html.HtmlDocument;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class HtmlElement
implements Cloneable {
    public static final int CON_COMMENT = 1;
    public static final int CON_ELEMENT = 2;
    public static final int CON_TEXT = 3;
    public static final String TAGS_TOSKIP = "p,form,div,span";
    public static boolean ISDEBUG = false;
    protected static final int FORMAT_BLANKS = 2;
    protected static final int INITIAL_ARRAY_SIZE = 5;
    public static final String TAG_ALONE = " AREA BR HR INPUT LI IMG META PARAM UL ";
    public static final String TAG_SHORT = " BR LI ";
    public boolean ONLY_SEARCH_SELF = false;
    protected String name;
    protected Object parent = null;
    protected List attributes = null;
    protected List content = null;
    private boolean m_bEndSelf = false;

    public HtmlElement() {
    }

    public HtmlElement(String _name) {
        this.name = _name;
    }

    public static boolean isAloneTag(String _name) {
        if (_name == null) {
            return false;
        }
        return TAG_ALONE.indexOf(" " + _name.toUpperCase() + " ") >= 0;
    }

    public static boolean checkTagIn(String _sTagName, String _sNameList) {
        if (_sNameList == null || _sTagName == null || (_sTagName = _sTagName.trim()).length() == 0) {
            return false;
        }
        return (',' + _sNameList.toLowerCase() + ',').indexOf(',' + _sTagName.toLowerCase() + ',') >= 0;
    }

    public String getName() {
        return this.name;
    }

    public boolean nameIs(String _name) {
        return this.name.compareToIgnoreCase(_name) == 0;
    }

    public HtmlElement setName(String _name) {
        this.name = _name;
        return this;
    }

    public HTML.Tag getTag() {
        return HTML.getTag(this.name);
    }

    public HtmlDocument getDocument() {
        if (this.parent == null) {
            return null;
        }
        if (this.parent instanceof HtmlDocument) {
            return (HtmlDocument)this.parent;
        }
        if (this.parent instanceof HtmlElement) {
            return ((HtmlElement)this.parent).getDocument();
        }
        return null;
    }

    public HtmlElement setDocument(HtmlDocument _document) {
        this.parent = _document;
        return this;
    }

    public HtmlElement getParent() {
        if (this.parent instanceof HtmlElement) {
            return (HtmlElement)this.parent;
        }
        return null;
    }

    public HtmlElement setParent(HtmlElement _parent) {
        this.parent = _parent;
        return this;
    }

    public List getAttributes() {
        return this.attributes;
    }

    public List getContent() {
        return this.content;
    }

    public HtmlAttribute getAttribute(String _name) {
        if (this.attributes == null) {
            return null;
        }
        for (HtmlAttribute att : this.attributes) {
            if (att.getName().compareToIgnoreCase(_name) != 0) continue;
            return att;
        }
        return null;
    }

    public String getAttributeValue(String _name) {
        HtmlAttribute attribute = this.getAttribute(_name);
        return attribute == null ? null : attribute.getValue();
    }

    public HtmlElement setAttributes(List _attributes) {
        if (_attributes == null) {
            this.attributes = null;
            return this;
        }
        if (this.attributes == null) {
            this.attributes = new ArrayList(5);
        }
        for (HtmlAttribute att : _attributes) {
            if (att == null) continue;
            if (att.getParent() != this) {
                att.setParent(this);
            }
            this.attributes.add(att);
        }
        return this;
    }

    public HtmlElement setAttribute(String _name, String _value) {
        return this.setAttribute(new HtmlAttribute(_name, _value));
    }

    public HtmlElement setAttribute(String _name, String _value, char _quote) {
        return this.setAttribute(new HtmlAttribute(_name, _value, _quote));
    }

    public HtmlElement setAttribute(HtmlAttribute _attribute) {
        if (_attribute == null) {
            return this;
        }
        if (this.attributes == null) {
            this.attributes = new ArrayList(5);
            this.attributes.add(_attribute);
            return this;
        }
        for (HtmlAttribute att : this.attributes) {
            if (!att.nameIs(_attribute.getName())) continue;
            att.setValue(_attribute.getValue());
            return this;
        }
        this.attributes.add(_attribute);
        if (_attribute.getParent() != this) {
            _attribute.setParent(this);
        }
        return this;
    }

    public boolean removeAttribute(String _name) {
        if (this.attributes == null) {
            return false;
        }
        Iterator itr = this.attributes.iterator();
        while (itr.hasNext()) {
            HtmlAttribute att = (HtmlAttribute)itr.next();
            if (!att.nameIs(_name)) continue;
            itr.remove();
            att.setParent(null);
            return true;
        }
        return false;
    }

    public HtmlElement addContent(String _text) {
        Object obj;
        if (this.content == null) {
            this.content = new ArrayList(5);
        }
        _text = _text.trim();
        int size = this.content.size();
        if (size > 0 && (obj = this.content.get(size - 1)) instanceof String) {
            _text = (String)obj + _text;
            this.content.remove(size - 1);
        }
        this.content.add(_text);
        return this;
    }

    public HtmlElement addContent(HtmlElement _element) throws CMyException {
        if (_element == null) {
            return this;
        }
        if (_element.getParent() != null) {
            throw new CMyException(1, I18NMessage.get(HtmlElement.class, "HtmlElement.label1", "\u5143\u7d20\u5df2\u5b58\u5728Parent\uff08HtmlElement.addContent\uff09"));
        }
        if (_element == this) {
            throw new CMyException(1, I18NMessage.get(HtmlElement.class, "HtmlElement.label2", "\u5143\u7d20\u4e0d\u80fd\u6dfb\u52a0\u5230\u81ea\u8eab\uff08HtmlElement.addContent\uff09"));
        }
        if (_element.isAncestorOf(this)) {
            throw new CMyException(1, I18NMessage.get(HtmlElement.class, "HtmlElement.label3", "\u8981\u6dfb\u52a0\u7684\u5143\u7d20\u662f\u5f53\u524d\u5143\u7d20\u7684\u7956\u5148\uff08HtmlElement.addContent\uff09"));
        }
        if (this.content == null) {
            this.content = new ArrayList(5);
        }
        _element.setParent(this);
        this.content.add(_element);
        return this;
    }

    public HtmlElement addContent(HtmlComment _comment) throws CMyException {
        if (_comment.getParent() != null || _comment.getDocument() != null) {
            throw new CMyException(1, I18NMessage.get(HtmlElement.class, "HtmlElement.label1", "\u5143\u7d20\u5df2\u5b58\u5728Parent\uff08HtmlElement.addContent\uff09"));
        }
        if (this.content == null) {
            this.content = new ArrayList(5);
        }
        _comment.setParent(this);
        this.content.add(_comment);
        return this;
    }

    public boolean removeContent(HtmlComment _comment) {
        if (_comment == null || this.content == null) {
            return false;
        }
        if (this.content.remove(_comment)) {
            _comment.setParent(null);
            return true;
        }
        return false;
    }

    public boolean removeContent(HtmlElement _element) {
        if (_element == null || this.content == null) {
            return false;
        }
        if (this.content.remove(_element)) {
            _element.setParent(null);
            return true;
        }
        return false;
    }

    public boolean hasChildren() {
        if (this.content == null || this.content.size() == 0) {
            return false;
        }
        Iterator itr = this.content.iterator();
        while (itr.hasNext()) {
            if (!(itr.next() instanceof HtmlElement)) continue;
            return true;
        }
        return false;
    }

    public List getChildren() {
        return this.getChildren(null);
    }

    public List getChildren(String _name) {
        ArrayList children = null;
        if (this.content == null) {
            children = new ArrayList(1);
        } else {
            children = new ArrayList(this.content.size());
            for (Object obj : this.content) {
                if (!(obj instanceof HtmlElement) || _name != null && !((HtmlElement)obj).nameIs(_name)) continue;
                children.add(obj);
            }
        }
        return children;
    }

    public HtmlElement getChild(String _name) {
        if (this.content == null) {
            return null;
        }
        for (Object obj : this.content) {
            HtmlElement element;
            if (!(obj instanceof HtmlElement) || !(element = (HtmlElement)obj).nameIs(_name)) continue;
            return element;
        }
        return null;
    }

    public String getText() {
        if (this.content == null || this.content.size() < 1) {
            return "";
        }
        if (this.content.size() == 1 && this.content.get(0) instanceof String) {
            return (String)this.content.get(0);
        }
        StringBuffer textContent = new StringBuffer();
        boolean hasText = false;
        for (Object obj : this.content) {
            String sText;
            if (obj instanceof String) {
                textContent.append((String)obj);
                hasText = true;
                continue;
            }
            if (!(obj instanceof HtmlElement) || (sText = ((HtmlElement)obj).getText()).length() <= 0) continue;
            textContent.append(sText);
            hasText = true;
        }
        return hasText ? textContent.toString() : "";
    }

    public boolean isRootElement() {
        return this.parent instanceof HtmlDocument;
    }

    public int getLevel() {
        int nLevel = 0;
        Object p = this.parent;
        while (p != null && p instanceof HtmlElement) {
            ++nLevel;
            p = ((HtmlElement)p).getParent();
        }
        return nLevel;
    }

    public boolean isAncestorOf(HtmlElement _element) {
        if (_element == null) {
            return false;
        }
        HtmlElement p = _element.getParent();
        while (p instanceof HtmlElement) {
            if (p == this) {
                return true;
            }
            p = p.getParent();
        }
        return false;
    }

    public List getElementsByName(String _name) {
        ArrayList elements = null;
        if (this.content == null) {
            elements = new ArrayList(1);
        } else {
            elements = new ArrayList(5);
            _name = _name.trim();
            for (Object obj : this.content) {
                if (obj == null || !(obj instanceof HtmlElement)) continue;
                List grandChildren = ((HtmlElement)obj).getElementsByName(_name);
                if (_name == null || ((HtmlElement)obj).nameIs(_name)) {
                    elements.add(obj);
                }
                for (int i = 0; i < grandChildren.size(); ++i) {
                    elements.add(grandChildren.get(i));
                }
            }
        }
        return elements;
    }

    public String toString() {
        return this.toString(true, false);
    }

    public String toString(boolean _bIncludingTag, boolean _bFormat, String _sTagNamesSkipped) {
        StringBuffer textContent = new StringBuffer();
        String sBlanks = null;
        if (_bIncludingTag) {
            textContent.append("<").append(this.name);
            if (this.attributes != null && this.attributes.size() >= 1) {
                for (Object obj : this.attributes) {
                    if (obj == null || !(obj instanceof HtmlAttribute)) continue;
                    textContent.append(" ").append(((HtmlAttribute)obj).toString());
                }
            }
            if (this.m_bEndSelf || HtmlElement.isAloneTag(this.name)) {
                textContent.append(" /");
            }
            textContent.append(">");
        }
        if (this.content != null) {
            int nSize = this.content.size();
            if (nSize == 1 && this.content.get(0) instanceof String) {
                textContent.append((String)this.content.get(0));
            } else if (nSize >= 1) {
                for (Object obj : this.content) {
                    if (obj == null) continue;
                    if (obj instanceof String) {
                        textContent.append((String)obj);
                        continue;
                    }
                    if (obj instanceof HtmlComment) {
                        textContent.append(((HtmlComment)obj).toString());
                        continue;
                    }
                    if (!(obj instanceof HtmlElement)) continue;
                    HTML.Tag tag = ((HtmlElement)obj).getTag();
                    if (tag != null && tag.breakBeforeBegin()) {
                        textContent.append("\n");
                        if (_bFormat) {
                            if (sBlanks == null) {
                                sBlanks = CMyString.makeBlanks((this.getLevel() + 1) * 2);
                            }
                            textContent.append(sBlanks);
                        }
                    }
                    textContent.append(((HtmlElement)obj).toString(true, _bFormat, _sTagNamesSkipped));
                }
            }
        }
        if (!(!_bIncludingTag || HtmlElement.isAloneTag(this.name) || _sTagNamesSkipped != null && HtmlElement.checkTagIn(this.name, _sTagNamesSkipped))) {
            HTML.Tag tag;
            if (_bFormat && (tag = this.getTag()) != null && tag.breakBeforeEnd()) {
                textContent.append("\n");
                textContent.append(CMyString.makeBlanks(this.getLevel() * 2));
            }
            if (!this.ONLY_SEARCH_SELF) {
                textContent.append("</").append(this.name).append(">");
            }
        }
        return textContent.toString();
    }

    public String toString(boolean _bIncludingTag, boolean _bFormat) {
        return this.toString(_bIncludingTag, _bFormat, null);
    }

    public int fromString(String _strSrc, String _sTagsToSkip) throws CMyException {
        int nLen;
        if (this.attributes != null) {
            this.attributes.clear();
        }
        if (this.content != null) {
            this.content.clear();
        }
        if ((nLen = _strSrc.length()) < 1) {
            return 0;
        }
        char[] srcBuffer = new char[nLen + 1];
        _strSrc.getChars(0, nLen, srcBuffer, 0);
        return this.fromString(srcBuffer, 0, _sTagsToSkip);
    }

    public int fromString(String _strSrc) throws CMyException {
        return this.fromString(_strSrc, null);
    }

    public int fromString(char[] _srcBuffer, int _nStart, String _sTagsToSkip) throws CMyException {
        boolean bCanEnd;
        char aChar;
        int nPos;
        if (_nStart < 0) {
            return -1;
        }
        int nLen = _srcBuffer.length;
        StringBuffer conBuffer = null;
        String sValue = null;
        for (nPos = _nStart; nPos < nLen && _srcBuffer[nPos] != '<'; ++nPos) {
        }
        ++nPos;
        conBuffer = new StringBuffer();
        while (nPos < nLen && !Character.isWhitespace(aChar = _srcBuffer[nPos]) && aChar != '>') {
            conBuffer.append(aChar);
            ++nPos;
        }
        this.name = conBuffer.toString();
        if (ISDEBUG) {
            System.out.println("\n Analyze Element [" + this.name + "]");
        }
        if (this.ONLY_SEARCH_SELF) {
            return nPos;
        }
        boolean bOver = HtmlElement.isAloneTag(this.name) || HtmlElement.checkTagIn(this.name, _sTagsToSkip);
        HTML.Tag tag = this.getTag();
        if (!bOver && tag != null && tag.isPreformatted()) {
            conBuffer = new StringBuffer();
            bCanEnd = true;
            for (nPos = this.readAttributes(_srcBuffer, nPos); nPos < nLen; ++nPos) {
                int nNextPos;
                aChar = _srcBuffer[nPos];
                if (aChar == '\"') {
                    bCanEnd = !bCanEnd;
                } else if (aChar == '<' && bCanEnd && (nNextPos = this.checkAtEndTag(_srcBuffer, nPos)) > 0) {
                    nPos = nNextPos;
                    break;
                }
                conBuffer.append(aChar);
            }
            this.addContent(conBuffer.toString());
            bOver = true;
        }
        while (!bOver && nPos < nLen) {
            while (nPos < nLen && Character.isWhitespace(_srcBuffer[nPos])) {
                ++nPos;
            }
            if (nPos >= nLen) break;
            if (_srcBuffer[nPos] != '<') {
                conBuffer = new StringBuffer();
                bCanEnd = true;
                while (nPos < nLen) {
                    aChar = _srcBuffer[nPos];
                    if (aChar == '\"') {
                        bCanEnd = !bCanEnd;
                    } else if (aChar == '<' && bCanEnd) break;
                    conBuffer.append(aChar);
                    ++nPos;
                }
                this.addContent(conBuffer.toString());
                continue;
            }
            if (_srcBuffer[nPos + 1] == '!') {
                HtmlComment comment = new HtmlComment();
                conBuffer = new StringBuffer();
                while (nPos < nLen) {
                    aChar = _srcBuffer[nPos++];
                    conBuffer.append(aChar);
                    if (aChar != '-' || _srcBuffer[nPos] != '-' || _srcBuffer[nPos + 1] != '>') continue;
                    conBuffer.append("->");
                    nPos += 2;
                    break;
                }
                if (ISDEBUG) {
                    System.out.println("\nGet comment:\n" + conBuffer.toString());
                }
                if (!comment.fromString(conBuffer.toString())) continue;
                this.addContent(comment);
                continue;
            }
            if (_srcBuffer[nPos + 1] == '/') {
                conBuffer = new StringBuffer();
                nPos += 2;
                while (nPos < nLen && (aChar = _srcBuffer[nPos++]) != '>') {
                    if (Character.isWhitespace(aChar)) continue;
                    conBuffer.append(aChar);
                }
                sValue = conBuffer.toString();
                if (_sTagsToSkip == null || this.nameIs(sValue) || !HtmlElement.checkTagIn(sValue, _sTagsToSkip)) {
                    bOver = true;
                    continue;
                }
                this.addContent("</" + sValue + ">");
                continue;
            }
            HtmlElement element = new HtmlElement();
            int nNextPos = element.fromString(_srcBuffer, nPos, _sTagsToSkip);
            String sNextTagName = element.getName();
            if (ISDEBUG && this.name.compareToIgnoreCase("form") == 0) {
                System.out.println("\n Analyze Child Element [" + sNextTagName + "]");
                System.out.println("\n ===cotent===== \n" + element.toString(true, false));
            }
            if (sNextTagName != null) {
                this.addContent(element);
            }
            nPos = nNextPos;
        }
        return nPos;
    }

    public int fromString(char[] _srcBuffer, int _nStart) throws CMyException {
        return this.fromString(_srcBuffer, _nStart, null);
    }

    private int readAttributes(char[] _srcBuffer, int _nStart) {
        int nPos = _nStart;
        int nLen = _srcBuffer.length;
        StringBuffer conBuffer = null;
        int aChar = 32;
        int chrQuote = 32;
        boolean bCanEnd = true;
        while (nPos < nLen) {
            while (nPos < nLen && Character.isWhitespace(_srcBuffer[nPos])) {
                ++nPos;
            }
            if (nPos >= nLen || _srcBuffer[nPos] == '>' && bCanEnd) break;
            HtmlAttribute attribute = new HtmlAttribute();
            conBuffer = new StringBuffer();
            while (nPos < nLen) {
                aChar = _srcBuffer[nPos];
                if ((aChar == 34 || aChar == 39) && _srcBuffer[nPos - 1] != '\\') {
                    if (chrQuote == 32) {
                        chrQuote = aChar;
                        bCanEnd = false;
                    } else if (aChar == chrQuote) {
                        bCanEnd = !bCanEnd;
                        chrQuote = 32;
                    }
                }
                if (bCanEnd && (Character.isWhitespace((char)aChar) || aChar == 62)) break;
                if (bCanEnd && aChar == 47 && _srcBuffer[nPos + 1] == '>') {
                    ++nPos;
                    this.m_bEndSelf = true;
                    break;
                }
                conBuffer.append((char)aChar);
                ++nPos;
            }
            if (!attribute.fromString(conBuffer.toString())) continue;
            this.setAttribute(attribute);
        }
        return ++nPos;
    }

    private static int checkAtEndTag(char[] _srcBuffer, int _nPos, String _sTagName) {
        char[] tagName = ("</" + _sTagName + ">").toLowerCase().toCharArray();
        int nPos = _nPos;
        for (int i = 0; i < tagName.length && nPos < _srcBuffer.length; ++i) {
            if (Character.toLowerCase(_srcBuffer[nPos++]) == tagName[i]) continue;
            return -1;
        }
        return nPos;
    }

    private int checkAtEndTag(char[] _srcBuffer, int _nPos) {
        return HtmlElement.checkAtEndTag(_srcBuffer, _nPos, this.name);
    }

    public static void main(String[] args) {
        ISDEBUG = false;
        HtmlElement element = new HtmlElement();
        try {
            String strSrc = CMyFile.readFile("d:\\test\\sina.htm");
            String sTagsToSkip = TAGS_TOSKIP;
            element.fromString("<BODY>" + strSrc + "</BODY>", sTagsToSkip);
            System.out.println(element.toString(false, true, sTagsToSkip));
        }
        catch (Exception ex) {
            ex.printStackTrace(System.out);
        }
    }
}

