/*
 * Decompiled with CFR 0.152.
 */
package com.trs.infra.util;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;

public class AutoClient {
    private final String host;
    private final int port;
    private final String loginUrl;
    private final String user;
    private final String passwd;

    public AutoClient(String host, int port, String loginUrl, String user, String passwd) {
        this.host = host;
        this.port = port;
        this.loginUrl = loginUrl;
        this.user = user;
        this.passwd = passwd;
    }

    public void start(final List urls, final long waitMillis) {
        if (urls == null || urls.isEmpty()) {
            return;
        }
        new Thread(){

            @Override
            public void run() {
                try {
                    Thread.sleep(waitMillis);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                HttpClient client = new HttpClient();
                client.getHostConfiguration().setHost(AutoClient.this.host, AutoClient.this.port, "http");
                client.getParams().setContentCharset("utf-8");
                client.getParams().setCookiePolicy("compatibility");
                PostMethod authpost = new PostMethod(AutoClient.this.loginUrl);
                NameValuePair name = new NameValuePair("UserName", AutoClient.this.user);
                NameValuePair pass = new NameValuePair("PassWord", AutoClient.this.passwd);
                authpost.setRequestBody(new NameValuePair[]{name, pass});
                int status = 0;
                try {
                    status = client.executeMethod((HttpMethod)authpost);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                authpost.releaseConnection();
                if (status != 200 && status != 302) {
                    System.out.println("login failed. status=" + status);
                    return;
                }
                for (int i = urls.size() - 1; i >= 0; --i) {
                    String url = (String)urls.get(i);
                    GetMethod pageGet = new GetMethod(url);
                    try {
                        client.executeMethod((HttpMethod)pageGet);
                        continue;
                    }
                    catch (Exception e) {
                        System.out.println("visit failed." + url);
                        e.printStackTrace(System.out);
                    }
                }
            }
        }.start();
    }

    public static void main(String[] args) {
        int ix = 0;
        String host = args[ix++];
        int port = 8080;
        try {
            port = Integer.parseInt(args[ix++]);
        }
        catch (Exception exception) {
            // empty catch block
        }
        String loginUrl = args[ix++];
        String user = args[ix++];
        String passwd = args[ix++];
        AutoClient client = new AutoClient(host, port, loginUrl, user, passwd);
        long waitMillis = 0L;
        try {
            waitMillis = (long)(Integer.parseInt(args[ix++]) * 60) * 1000L;
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (waitMillis <= 0L) {
            waitMillis = 60000L;
        }
        int len = args.length;
        ArrayList<String> urls = new ArrayList<String>(len - ix);
        while (ix < len) {
            urls.add(args[ix++]);
        }
        client.start(urls, waitMillis);
    }
}

