/*
 * Decompiled with CFR 0.152.
 */
package com.trs.infra.support.log;

import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.common.WCMTypes;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.support.log.ILog;
import com.trs.infra.support.log.Log;
import com.trs.infra.support.log.LogType;
import com.trs.infra.support.log.OperType;
import com.trs.infra.util.CMyDateTime;
import com.trs.infra.util.CMyString;

public abstract class BaseDBLog
extends BaseObj
implements ILog {
    @Override
    public boolean isValid() throws WCMException {
        if (this.isAddMode()) {
            if (this.getProperty("LOGTYPE") == null) {
                throw new WCMException(1106, I18NMessage.get(BaseDBLog.class, "BaseDBLog.label1", "\u5c5e\u6027Type\u6ca1\u6709\u8bbe\u7f6e(Log.isValid)"));
            }
            if (this.getProperty("LOGOBJTYPE") == null) {
                throw new WCMException(1106, I18NMessage.get(BaseDBLog.class, "BaseDBLog.label2", "\u5c5e\u6027ObjType\u6ca1\u6709\u8bbe\u7f6e(Log.isValid)"));
            }
            if (this.getProperty("LOGOBJID") == null) {
                throw new WCMException(1106, I18NMessage.get(BaseDBLog.class, "BaseDBLog.label3", "\u5c5e\u6027ObjId\u6ca1\u6709\u8bbe\u7f6e(Log.isValid)"));
            }
            if (this.getProperty("LOGRESULT") == null) {
                throw new WCMException(1106, I18NMessage.get(BaseDBLog.class, "BaseDBLog.label4", "\u5c5e\u6027Result\u6ca1\u6709\u8bbe\u7f6e(Log.isValid)"));
            }
        } else if (!this.isModified()) {
            throw new WCMException(1107, I18NMessage.get(BaseDBLog.class, "BaseDBLog.label5", "\u5bf9\u8c61\u5c5e\u6027\u6ca1\u6709\u66f4\u6539(Log.isValid)"));
        }
        return true;
    }

    @Override
    public LogType getLogType() throws WCMException {
        int nLogTypeId = this.getPropertyAsInt("LOGTYPE", 0);
        return LogType.findById(nLogTypeId);
    }

    @Override
    public boolean setLogType(int _typeId) throws WCMException {
        return this.setProperty("LOGTYPE", _typeId);
    }

    @Override
    public boolean setLogType(LogType _logType) throws WCMException {
        if (_logType == null) {
            throw new WCMException(10, I18NMessage.get(BaseDBLog.class, "BaseDBLog.label6", "\u65e0\u6548\u7684\u65e5\u5fd7\u7c7b\u578b\u5bf9\u8c61(Log.setLogType)"));
        }
        return this.setLogType(_logType.getId());
    }

    @Override
    public int getOpType() {
        return this.getPropertyAsInt("LOGOPTYPE", 0);
    }

    @Override
    public boolean setOpType(int _opType) throws WCMException {
        return this.setProperty("LOGOPTYPE", _opType);
    }

    @Override
    public String getDesc() {
        return (String)this.getProperty("LOGDESC");
    }

    @Override
    public boolean setDesc(String _desc) throws WCMException {
        return this.setProperty("LOGDESC", _desc);
    }

    @Override
    public String getUserName() {
        return (String)this.getProperty("LOGUSER");
    }

    @Override
    public boolean setUser(String _userName) throws WCMException {
        return this.setProperty("LOGUSER", _userName == null ? "" : _userName);
    }

    @Override
    public int getObjType() {
        return this.getPropertyAsInt("LOGOBJTYPE", 0);
    }

    @Override
    public boolean setObjType(int _objType) throws WCMException {
        return this.setProperty("LOGOBJTYPE", _objType);
    }

    @Override
    public int getObjId() {
        return this.getPropertyAsInt("LOGOBJID", 0);
    }

    @Override
    public boolean setObj(BaseObj _baseObj) throws WCMException {
        this.setObjType(_baseObj.getWCMType());
        this.setObjId(_baseObj.getId());
        String sObjName = _baseObj.getPropertyAsString("NAME");
        if (sObjName == null) {
            sObjName = _baseObj.toString();
        }
        if (sObjName.indexOf(91) == -1) {
            String typeName = WCMTypes.getObjName(_baseObj.getWCMType(), true);
            if ("Unknown".equalsIgnoreCase(typeName)) {
                typeName = _baseObj.getClassName(false);
            }
            sObjName = sObjName + " [" + typeName + "-" + _baseObj.getId() + "]";
        }
        this.setObjName(sObjName);
        return true;
    }

    public boolean setObj(int _nObjType, int _nObjId) throws WCMException {
        this.setObjType(_nObjType);
        this.setObjId(_nObjId);
        BaseObj _baseObj = BaseObj.findById(_nObjType, _nObjId);
        String sObjName = null;
        if (_baseObj != null) {
            sObjName = _baseObj.getPropertyAsString("NAME");
            if (sObjName == null) {
                sObjName = _baseObj.toString();
            }
            if (sObjName.indexOf(91) == -1) {
                String typeName = WCMTypes.getObjName(_baseObj.getWCMType(), true);
                if ("Unknown".equalsIgnoreCase(typeName)) {
                    typeName = _baseObj.getClassName(false);
                }
                sObjName = sObjName + " [" + typeName + "-" + _baseObj.getId() + "]";
            }
        } else {
            sObjName = "Object not found![" + _nObjType + ", " + _nObjId + "]";
        }
        this.setObjName(sObjName);
        return true;
    }

    @Override
    public boolean setObjId(int _objId) throws WCMException {
        return this.setProperty("LOGOBJID", _objId);
    }

    @Override
    public String getObjName() {
        return (String)this.getProperty("LOGOBJNAME");
    }

    @Override
    public boolean setObjName(String _objName) throws WCMException {
        _objName = CMyString.truncateStr(_objName, 450);
        return this.setProperty("LOGOBJNAME", _objName);
    }

    @Override
    public int getOpTypeId() {
        return this.getPropertyAsInt("LOGOPTYPE", 0);
    }

    @Override
    public boolean setObjTypeId(int _objTypeId) throws WCMException {
        return this.setProperty("LOGOPTYPE", _objTypeId);
    }

    @Override
    public String getOpArgs() {
        return (String)this.getProperty("LOGOPARGS");
    }

    @Override
    public boolean setOpArgs(String _opArgs) throws WCMException {
        return this.setProperty("LOGOPARGS", _opArgs);
    }

    @Override
    public int getResult() {
        return this.getPropertyAsInt("LOGRESULT", 0);
    }

    @Override
    public boolean setResult(int _result) throws WCMException {
        return this.setProperty("LOGRESULT", _result);
    }

    @Override
    public CMyDateTime getOpTime() {
        return (CMyDateTime)this.getProperty("LOGOPTIME");
    }

    @Override
    public boolean setOpTime(CMyDateTime _opTime) throws WCMException {
        return this.setProperty("LOGOPTIME", _opTime);
    }

    @Override
    public boolean setOpTime() throws WCMException {
        CMyDateTime opTime = new CMyDateTime();
        opTime.setDateTimeWithCurrentTime();
        return this.setProperty("LOGOPTIME", opTime);
    }

    @Override
    public int getTopLogId() {
        return this.getPropertyAsInt("TOPID", 0);
    }

    @Override
    public boolean setTopLogId(int _nTopLogId) throws WCMException {
        return this.setProperty("TOPID", _nTopLogId);
    }

    @Override
    public String getLogUserIP() {
        return this.getPropertyAsString("LOGUSERIP");
    }

    @Override
    public boolean setLogUserIP(String _sLogUserIP) throws WCMException {
        return this.setProperty("LOGUSERIP", _sLogUserIP);
    }

    protected ILog save(String _sUserName, int _nOperType, String _sLogDesc, int _nLogType, BaseObj _obj) throws WCMException {
        Log log = new Log();
        log.setDesc(_sLogDesc);
        log.setLogType(_nLogType);
        log.setOpType(_nOperType);
        log.setUser(_sUserName);
        log.setObjName(_obj.toString());
        log.setObjId(_obj.getId());
        log.setObjType(_obj.getWCMType());
        log.setResult(1);
        log.insert();
        return log;
    }

    @Override
    public void saveLog() throws WCMException {
        super.save();
    }

    @Override
    public boolean deleteLog() throws WCMException {
        return super.delete() == 1;
    }

    @Override
    public boolean setStartTimeMillis(long _lStartTime) throws WCMException {
        return this.setProperty("STimeMillis", _lStartTime);
    }

    @Override
    public long getStartTimeMillis() {
        return this.getPropertyAsLong("STimeMillis", System.currentTimeMillis());
    }

    @Override
    public boolean setEndTimeMillis(long _lEndTime) throws WCMException {
        return this.setProperty("ETimeMillis", _lEndTime);
    }

    @Override
    public boolean setExecTime(long _lExecTime) throws WCMException {
        return this.setProperty("ExecTime", _lExecTime);
    }

    @Override
    public long getExecTime() {
        return this.getPropertyAsLong("ExecTime", 0L);
    }

    @Override
    public void loadByStartId(long _lStartId) throws WCMException {
        this.loadById((int)_lStartId, "LOGID,TOPID,LOGDESC,STIMEMILLIS,LOGOBJTYPE,LOGOBJID,LOGOBJNAME");
    }

    @Override
    public String getOperTypeDesc() throws WCMException {
        int nOperType = this.getOpType();
        OperType operType = OperType.findById(nOperType);
        return operType != null ? operType.getDesc() : I18NMessage.get(BaseDBLog.class, "BaseDBLog.label9", "\u672a\u77e5");
    }

    @Override
    public long getStartId() {
        return this.getId();
    }
}

